/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.model.session;

import android.annotation.SuppressLint;
import android.content.Context;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.Feature;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.internal.device.InstabugDeviceProperties;
import com.instabug.library.internal.storage.cache.db.userAttribute.UserAttributesDbHelper;
import com.instabug.library.logging.InstabugUserEventLogger;
import com.instabug.library.model.UserAttributes;
import com.instabug.library.model.common.Session;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.user.UserEvent;
import com.instabug.library.user.b;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.filters.Filters;
import com.instabug.library.util.filters.a;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.JSONException;

@Keep
public class SessionLocalEntity {
    private static final String TAG = "SessionLocalEntity";
    private final String id;
    private final String os;
    private final String device;
    private final long duration;
    private final long startedAt;
    private final String userName;
    private final String userEmail;
    private final String sdkVersion;
    private final String appVersion;
    private final String userEvents;
    private final String customAttributes;
    private final String userEventsKeys;
    private final String customAttributesKeys;
    private final boolean crashReportingEnabled;
    private final int syncStatus;
    private final String uuid;
    private final String appToken;
    private final boolean usersPageEnabled;

    /*
     * WARNING - void declaration
     */
    public SessionLocalEntity(String id2, String os, String device, long duration, long startedAt, String userName, String userEmail, String sdkVersion, String appVersion, String userEvents, String customAttributes, String userEventsKeys, String customAttributesKeys, boolean crashReportingEnabled, int syncStatus, String uuid, String appToken, boolean usersPageEnabled) {
        void var20_18;
        void var19_17;
        void var18_16;
        void var17_15;
        void var16_14;
        void var15_13;
        void var14_12;
        void var13_11;
        void var12_10;
        void var11_9;
        void var10_8;
        void var9_7;
        void var8_6;
        void var6_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        this.id = var1_1;
        this.os = var2_2;
        this.device = var3_3;
        this.duration = var4_4;
        this.startedAt = var6_5;
        this.userName = var8_6;
        this.userEmail = var9_7;
        this.sdkVersion = var10_8;
        this.appVersion = var11_9;
        this.userEvents = var12_10;
        this.customAttributes = var13_11;
        this.userEventsKeys = var14_12;
        this.customAttributesKeys = var15_13;
        this.crashReportingEnabled = var16_14;
        this.syncStatus = var17_15;
        this.uuid = var18_16;
        this.appToken = var19_17;
        this.usersPageEnabled = var20_18;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getAppToken() {
        return this.appToken;
    }

    public String getId() {
        return this.id;
    }

    public String getOs() {
        return this.os;
    }

    public String getDevice() {
        return this.device;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getStartTimestampMicros() {
        return this.startedAt;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserEmail() {
        return this.userEmail;
    }

    public String getSdkVersion() {
        return this.sdkVersion;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public String getUserEvents() {
        return this.userEvents;
    }

    public String getCustomAttributes() {
        return this.customAttributes;
    }

    public String getUserEventsKeys() {
        return this.userEventsKeys;
    }

    public String getCustomAttributesKeys() {
        return this.customAttributesKeys;
    }

    public boolean isCrashReportingEnabled() {
        return this.crashReportingEnabled;
    }

    public int getSyncStatus() {
        return this.syncStatus;
    }

    public boolean isUsersPageEnabled() {
        return this.usersPageEnabled;
    }

    public static class Factory {
        private boolean isCrashReportingEnabled() {
            return InstabugCore.isFeatureEnabled(Feature.CRASH_REPORTING);
        }

        @Nullable
        private String getOs(boolean usersPageEnabled) {
            return usersPageEnabled ? "SDK Level " + InstabugDeviceProperties.getCurrentOSLevel() : null;
        }

        @Nullable
        private String getDevice(boolean usersPageEnabled) {
            return usersPageEnabled ? InstabugDeviceProperties.getDeviceType() : null;
        }

        private long getCurrentSessionTimeUntilNow() {
            long l2 = SettingsManager.getInstance().getSessionStartedAt();
            if (l2 == 0L) {
                return 0L;
            }
            return System.currentTimeMillis() / 1000L - l2;
        }

        private long getSessionStartedAt() {
            return SettingsManager.getInstance().getSessionStartedAt();
        }

        @Nullable
        private String getUserName(boolean usersPageEnabled) {
            return usersPageEnabled ? b.f() : null;
        }

        @Nullable
        private String getUserEmail(boolean usersPageEnabled) {
            return usersPageEnabled ? b.e() : null;
        }

        @NonNull
        private String getSdkVersion() {
            return "10.4.2";
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        private String getAppVersion(Context context) {
            void var1_1;
            return context == null ? null : InstabugDeviceProperties.getAppVersion((Context)var1_1);
        }

        @NonNull
        private String getUserAttributesAsStringJsonObject() {
            Object object = "{}";
            HashMap<String, String> hashMap = Filters.applyOn(UserAttributesDbHelper.getAll()).apply(a.g()).thenGet();
            if (hashMap != null && hashMap.size() != 0) {
                UserAttributes userAttributes = new UserAttributes();
                userAttributes.putMap(hashMap);
                object = userAttributes.toString();
            }
            return object;
        }

        @NonNull
        private String getUserAttributesKeysAsStringJsonArray() {
            Object object = "[]";
            HashMap<String, String> hashMap = Filters.applyOn(UserAttributesDbHelper.getAll()).apply(a.g()).thenGet();
            if (hashMap != null && hashMap.size() != 0) {
                UserAttributes userAttributes = new UserAttributes();
                userAttributes.putMap(hashMap);
                object = userAttributes.keysAsStringJsonArray();
            }
            return object;
        }

        @NonNull
        private String getUserEventsAsStringJsonArray() {
            Object object = "[]";
            List<UserEvent> list = InstabugUserEventLogger.getInstance().getUserEvents();
            try {
                object = UserEvent.toJson(new ArrayList<UserEvent>(list)).toString();
            }
            catch (JSONException jSONException) {
                InstabugSDKLogger.e(SessionLocalEntity.TAG, "parsing user events got error: " + jSONException.getMessage(), jSONException);
            }
            return object;
        }

        @NonNull
        private String getUserEventsKeysAsStringJsonArray() {
            List<UserEvent> list = InstabugUserEventLogger.getInstance().getUserEvents();
            return UserEvent.keysAsJsonArray(new ArrayList<UserEvent>(list)).toString();
        }

        private boolean isFirstSession() {
            return SettingsManager.getInstance().isFirstSession();
        }

        private int getSyncStatus() {
            return this.isFirstSession() ? 1 : 0;
        }

        @NonNull
        private String getUuid() {
            return b.h();
        }

        @Nullable
        private String getAppToken() {
            return SettingsManager.getInstance().getAppToken();
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
        public SessionLocalEntity create(Context context, @NonNull Session session, boolean usersPageEnabled) {
            String string2;
            void var3_3;
            String string3;
            Factory factory = string4;
            String string4 = string3.getId();
            string3 = factory.getOs((boolean)var3_3);
            String string5 = factory.getDevice((boolean)var3_3);
            long l2 = factory.getCurrentSessionTimeUntilNow();
            long l3 = factory.getSessionStartedAt();
            String string6 = factory.getUserName((boolean)var3_3);
            String string7 = factory.getUserEmail((boolean)var3_3);
            String string8 = factory.getSdkVersion();
            string2 = factory.getAppVersion((Context)string2);
            String string9 = factory.getUserEventsAsStringJsonArray();
            String string10 = factory.getUserAttributesAsStringJsonObject();
            String string11 = factory.getUserEventsKeysAsStringJsonArray();
            String string12 = factory.getUserAttributesKeysAsStringJsonArray();
            boolean bl = factory.isCrashReportingEnabled();
            int n2 = factory.getSyncStatus();
            String string13 = factory.getUuid();
            String string14 = factory.getAppToken();
            return new SessionLocalEntity(string4, string3, string5, l2, l3, string6, string7, string8, string2, string9, string10, string11, string12, bl, n2, string13, string14, (boolean)var3_3);
        }
    }
}

