/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util.threading;

import android.os.Looper;
import androidx.annotation.Nullable;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ThreadUtils {
    private static final String TAG = "ThreadUtils";

    public static boolean isCurrentThreadMain() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    private static String getMainThreadStackTrace(String errorName) {
        String string;
        return ThreadUtils.buildStackTraceFromElements(Looper.getMainLooper().getThread().getStackTrace(), string);
    }

    public static String buildStackTraceFromElements(StackTraceElement[] stackTraceElements, String errorName) {
        StringBuilder stringBuilder;
        stringBuilder = new StringBuilder().append((String)((Object)stringBuilder)).append("\n");
        int n2 = stackTraceElements.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            StackTraceElement[] stackTraceElementArray;
            StringBuilder stringBuilder2 = stringBuilder;
            StackTraceElement stackTraceElement = stackTraceElementArray[i2];
            stringBuilder2.append("\t at ");
            stringBuilder2.append(stackTraceElement.toString());
            stringBuilder2.append("\n");
        }
        return stringBuilder.toString();
    }

    public static JSONObject getMainThreadData(@Nullable String errorName) throws JSONException {
        String string;
        JSONObject jSONObject = ThreadUtils.getThreadData(Looper.getMainLooper().getThread());
        jSONObject.put("error", (Object)ThreadUtils.getStackTraceAsError(Looper.getMainLooper().getThread(), string));
        return jSONObject;
    }

    private static JSONObject getStackTraceAsError(Thread thread, @Nullable String errorName) {
        Object object;
        String string;
        String string2;
        JSONObject jSONObject;
        block14: {
            block13: {
                JSONObject jSONObject2;
                jSONObject = jSONObject2;
                jSONObject2 = new JSONObject();
                if (errorName != null) {
                    JSONObject jSONObject3 = jSONObject;
                    JSONObject jSONObject4 = jSONObject3;
                    jSONObject3.put("name", (Object)string2);
                    jSONObject4.put("exception", (Object)string2);
                }
                Thread thread2 = string;
                object = null;
                thread2.getStackTrace();
                if (thread2.getStackTrace().length <= 0) break block13;
                object = ((Thread)((Object)string)).getStackTrace()[0];
            }
            if (object != null) {
                if (((StackTraceElement)object).getFileName() == null) break block14;
                jSONObject.put("location", (Object)(((StackTraceElement)object).getFileName() + ":" + ((StackTraceElement)object).getLineNumber()));
            }
        }
        if (string2 == null) {
            string2 = "";
        }
        string = "stackTrace";
        try {
            jSONObject.put(string, (Object)ThreadUtils.getMainThreadStackTrace(string2));
        }
        catch (JSONException jSONException) {
            string2 = TAG;
            object = jSONException.getMessage() != null ? jSONException.getMessage() : "Json exception while creating formatted exception";
            InstabugSDKLogger.e(string2, (String)object, jSONException);
        }
        return jSONObject;
    }

    private static JSONObject getThreadData(Thread thread) throws JSONException {
        ThreadGroup threadGroup;
        JSONObject jSONObject;
        JSONObject jSONObject2;
        JSONObject jSONObject3 = jSONObject2;
        jSONObject2 = new JSONObject();
        JSONObject jSONObject4 = jSONObject;
        jSONObject4();
        jSONObject4.put("threadName", (Object)((Thread)((Object)threadGroup)).getName());
        long l2 = ((Thread)((Object)threadGroup)).getId();
        jSONObject4.put("threadId", l2);
        jSONObject4.put("threadPriority", ((Thread)((Object)threadGroup)).getPriority());
        jSONObject.put("threadState", (Object)((Thread)((Object)threadGroup)).getState().toString());
        threadGroup = thread.getThreadGroup();
        if (threadGroup != null) {
            JSONObject jSONObject5;
            JSONObject jSONObject6 = jSONObject5;
            jSONObject6();
            jSONObject6.put("name", (Object)threadGroup.getName());
            jSONObject6.put("maxPriority", threadGroup.getMaxPriority());
            jSONObject5.put("activeCount", threadGroup.activeCount());
            jSONObject4.put("threadGroup", (Object)jSONObject6);
        }
        JSONObject jSONObject7 = jSONObject3;
        jSONObject7.put("thread", (Object)jSONObject4);
        return jSONObject7;
    }

    public static JSONArray getThreadsData() throws JSONException {
        JSONArray jSONArray;
        JSONArray jSONArray2 = jSONArray;
        jSONArray = new JSONArray();
        Iterator<Thread> iterator = Thread.getAllStackTraces().keySet().iterator();
        while (iterator.hasNext()) {
            jSONArray2.put((Object)ThreadUtils.getThreadData(iterator.next()));
        }
        return jSONArray2;
    }
}

