/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.model.session;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.internal.utils.stability.execution.ReturnableExecutable;
import com.instabug.library.internal.utils.stability.handler.exception.ExceptionHandler;
import com.instabug.library.model.session.CoreSession;
import com.instabug.library.model.session.SessionLocalEntity;
import com.instabug.library.model.session.SessionRemoteEntity;
import com.instabug.library.model.session.SessionsBatchDTO;
import com.instabug.library.network.NetworkManager;
import com.instabug.library.network.Request;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Keep
public class SessionMapper {
    private SessionMapper() {
    }

    @NonNull
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static SessionRemoteEntity toRemoteEntity(@NonNull CoreSession session) {
        CoreSession coreSession;
        HashMap<String, Object> hashMap;
        HashMap<String, Object> hashMap2 = hashMap;
        hashMap2();
        hashMap2.put("os", coreSession.getOs());
        hashMap2.put("device", coreSession.getDevice());
        hashMap2.put("duration", coreSession.getDuration());
        hashMap2.put("started_at", coreSession.getStartTimestampMicros());
        hashMap2.put("name", coreSession.getUserName());
        hashMap2.put("email", coreSession.getUserEmail());
        hashMap2.put("sdk_version", coreSession.getSdkVersion());
        hashMap.put("app_version", coreSession.getAppVersion());
        String string2 = session.isUsersPageEnabled() ? "user_events" : "user_event_keys";
        hashMap2.put(string2, coreSession.getUserEvents());
        string2 = coreSession.isUsersPageEnabled() ? "custom_attributes" : "custom_attribute_keys";
        hashMap2.put(string2, coreSession.getCustomAttributes());
        hashMap2.put("crash_reporting_enabled", coreSession.isCrashReportingEnabled());
        hashMap2.put("uuid", coreSession.getUuid());
        hashMap2.put("application_token", coreSession.getAppToken());
        return SessionMapper.toRemoteEntity(coreSession.getId(), hashMap2);
    }

    @NonNull
    public static List<SessionRemoteEntity> toRemoteEntities(@NonNull List<CoreSession> batch) {
        ArrayList<SessionRemoteEntity> arrayList;
        ArrayList<SessionRemoteEntity> arrayList2 = arrayList;
        arrayList = new ArrayList<SessionRemoteEntity>();
        Iterator<CoreSession> iterator = batch.iterator();
        while (iterator.hasNext()) {
            arrayList2.add(SessionMapper.toRemoteEntity(iterator.next()));
        }
        return arrayList2;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static SessionRemoteEntity toRemoteEntity(String id2, @NonNull Map<String, Object> map) {
        void var1_1;
        String string2;
        return new SessionRemoteEntity(string2, (Map<String, Object>)var1_1);
    }

    @NonNull
    public static SessionsBatchDTO toDTO(@NonNull SessionRemoteEntity session) {
        SessionRemoteEntity sessionRemoteEntity;
        return SessionMapper.toDTO(Collections.emptyMap(), Collections.singletonList(sessionRemoteEntity));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static SessionsBatchDTO toDTO(@NonNull Map<String, Object> commonKeys, @NonNull List<SessionRemoteEntity> sessions) {
        void var1_1;
        Map<String, Object> map;
        return new SessionsBatchDTO(map, (List<SessionRemoteEntity>)var1_1);
    }

    @NonNull
    public static CoreSession toModel(@NonNull SessionLocalEntity entity) {
        CoreSession coreSession;
        SessionLocalEntity sessionLocalEntity;
        SessionLocalEntity sessionLocalEntity2 = entity;
        String string2 = sessionLocalEntity2.getId();
        String string3 = sessionLocalEntity2.getOs();
        String string4 = sessionLocalEntity2.getDevice();
        long l2 = sessionLocalEntity2.getDuration();
        long l3 = sessionLocalEntity2.getStartTimestampMicros();
        long l4 = 0L;
        String string5 = sessionLocalEntity2.getUserName();
        String string6 = sessionLocalEntity2.getUserEmail();
        String string7 = sessionLocalEntity2.getSdkVersion();
        String string8 = sessionLocalEntity2.getAppVersion();
        String string9 = sessionLocalEntity2.isUsersPageEnabled() ? sessionLocalEntity.getUserEvents() : sessionLocalEntity.getUserEventsKeys();
        String string10 = sessionLocalEntity.isUsersPageEnabled() ? sessionLocalEntity.getCustomAttributes() : sessionLocalEntity.getCustomAttributesKeys();
        CoreSession coreSession2 = coreSession;
        SessionLocalEntity sessionLocalEntity3 = sessionLocalEntity;
        boolean bl = sessionLocalEntity3.isCrashReportingEnabled();
        int n2 = sessionLocalEntity3.getSyncStatus();
        String string11 = sessionLocalEntity3.getUuid();
        String string12 = sessionLocalEntity3.getAppToken();
        boolean bl2 = sessionLocalEntity3.isUsersPageEnabled();
        coreSession2(string2, string3, string4, l2, l3, l4, string5, string6, string7, string8, string9, string10, bl, n2, string11, string12, bl2);
        return coreSession2;
    }

    @NonNull
    public static List<CoreSession> toModels(@NonNull List<SessionLocalEntity> entities) {
        ArrayList<CoreSession> arrayList;
        ArrayList<CoreSession> arrayList2 = arrayList;
        arrayList = new ArrayList<CoreSession>();
        Iterator<SessionLocalEntity> iterator = entities.iterator();
        while (iterator.hasNext()) {
            arrayList2.add(SessionMapper.toModel(iterator.next()));
        }
        return arrayList2;
    }

    @NonNull
    public static ContentValues toContentValues(SessionLocalEntity entity) {
        SessionLocalEntity sessionLocalEntity;
        ContentValues contentValues;
        ContentValues contentValues2;
        ContentValues contentValues3 = contentValues2 = contentValues;
        contentValues2();
        contentValues2.put("session_id", sessionLocalEntity.getId());
        contentValues2.put("started_at", Long.valueOf(sessionLocalEntity.getStartTimestampMicros()));
        contentValues2.put("duration", Long.valueOf(sessionLocalEntity.getDuration()));
        contentValues2.put("user_attributes", sessionLocalEntity.getUserEvents());
        contentValues2.put("user_events", sessionLocalEntity.getCustomAttributes());
        contentValues2.put("user_attributes_keys", sessionLocalEntity.getUserEventsKeys());
        contentValues2.put("user_events_keys", sessionLocalEntity.getCustomAttributesKeys());
        contentValues2.put("user_email", sessionLocalEntity.getUserEmail());
        contentValues2.put("user_name", sessionLocalEntity.getUserName());
        contentValues2.put("uuid", sessionLocalEntity.getUuid());
        contentValues2.put("app_token", sessionLocalEntity.getAppToken());
        contentValues2.put("os", sessionLocalEntity.getOs());
        contentValues2.put("device", sessionLocalEntity.getDevice());
        contentValues2.put("sdk_version", sessionLocalEntity.getSdkVersion());
        contentValues3.put("app_version", sessionLocalEntity.getAppVersion());
        contentValues3.put("crash_reporting_enabled", Integer.valueOf(sessionLocalEntity.isCrashReportingEnabled() ? 1 : 0));
        contentValues3.put("users_page_enabled", Integer.valueOf(sessionLocalEntity.isUsersPageEnabled() ? 1 : 0));
        contentValues.put("sync_status", Integer.valueOf(sessionLocalEntity.getSyncStatus()));
        return contentValues;
    }

    @NonNull
    public static JSONObject toJson(@NonNull SessionRemoteEntity entity) {
        JSONObject jSONObject;
        SessionRemoteEntity sessionRemoteEntity;
        ReturnableExecutable<JSONObject> returnableExecutable = new ReturnableExecutable<JSONObject>(){

            @Override
            public JSONObject execute() throws Exception {
                JSONObject jSONObject;
                a a2 = a3;
                a a3 = jSONObject;
                jSONObject = new JSONObject();
                for (Map.Entry<String, Object> entry : a2.sessionRemoteEntity.getMap().entrySet()) {
                    a3.put(entry.getKey(), SessionMapper.extractJsonValue(entry.getValue()));
                }
                return a3;
            }
        };
        sessionRemoteEntity = jSONObject;
        jSONObject = new JSONObject();
        return (JSONObject)new ExceptionHandler().withPenaltyLog().executeAndGet(returnableExecutable, sessionRemoteEntity);
    }

    @NonNull
    public static JSONObject toJson(@NonNull SessionsBatchDTO batch) {
        JSONObject jSONObject;
        SessionsBatchDTO sessionsBatchDTO;
        ReturnableExecutable<JSONObject> returnableExecutable = new ReturnableExecutable<JSONObject>(){

            @Override
            public JSONObject execute() throws Exception {
                JSONArray jSONArray;
                JSONObject jSONObject;
                JSONObject jSONObject2 = jSONObject;
                jSONObject = new JSONObject();
                for (Map.Entry<String, Object> entry : b3.sessionsBatchDTO.getCommonKeys().entrySet()) {
                    jSONObject2.put(entry.getKey(), SessionMapper.extractJsonValue(entry.getValue()));
                }
                b b2 = b3;
                b b3 = jSONArray;
                jSONArray = new JSONArray();
                Iterator<Object> iterator = b2.sessionsBatchDTO.getSessions().iterator();
                while (iterator.hasNext()) {
                    b3.put(SessionMapper.toJson((SessionRemoteEntity)iterator.next()));
                }
                JSONObject jSONObject3 = jSONObject2;
                jSONObject3.put("sessions", (Object)b3);
                return jSONObject3;
            }
        };
        sessionsBatchDTO = jSONObject;
        jSONObject = new JSONObject();
        return (JSONObject)new ExceptionHandler().withPenaltyLog().executeAndGet(returnableExecutable, sessionsBatchDTO);
    }

    @NonNull
    public static Request toRequest(@NonNull JSONObject batch) {
        JSONObject jSONObject;
        Request request;
        final Request request2 = request;
        new Request(Request.Endpoint.SEND_SESSION, NetworkManager.RequestType.NORMAL).setRequestMethod(Request.RequestMethod.Post);
        return new ExceptionHandler().withPenaltyLog().executeAndGet(new ReturnableExecutable<Request>(){

            @Override
            public Request execute() throws Exception {
                Iterator iterator = jSONObject.keys();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    request2.addRequestBodyParameter(string2, jSONObject.get(string2));
                }
                return request2;
            }
        }, request2);
    }

    @NonNull
    public static SessionLocalEntity toLocalEntity(ContentValues contentValues) {
        SessionLocalEntity sessionLocalEntity;
        ContentValues contentValues2;
        ContentValues contentValues3 = contentValues;
        String string2 = contentValues3.getAsString("session_id");
        String string3 = contentValues3.getAsString("os");
        String string4 = contentValues3.getAsString("device");
        long l2 = contentValues3.getAsLong("duration");
        long l3 = contentValues3.getAsLong("started_at");
        String string5 = contentValues3.getAsString("user_name");
        String string6 = contentValues3.getAsString("user_email");
        String string7 = contentValues3.getAsString("sdk_version");
        String string8 = contentValues3.getAsString("app_version");
        String string9 = contentValues3.getAsString("user_attributes");
        String string10 = contentValues3.getAsString("user_events");
        String string11 = contentValues3.getAsString("user_attributes_keys");
        String string12 = contentValues3.getAsString("user_events_keys");
        boolean bl = contentValues3.getAsInteger("crash_reporting_enabled") == 1;
        ContentValues contentValues4 = contentValues2;
        int n2 = contentValues4.getAsInteger("sync_status");
        String string13 = contentValues4.getAsString("uuid");
        String string14 = contentValues4.getAsString("app_token");
        boolean bl2 = contentValues4.getAsInteger("users_page_enabled") == 1;
        SessionLocalEntity sessionLocalEntity2 = sessionLocalEntity;
        sessionLocalEntity2(string2, string3, string4, l2, l3, string5, string6, string7, string8, string9, string10, string11, string12, bl, n2, string13, string14, bl2);
        return sessionLocalEntity2;
    }

    @NonNull
    public static List<String> toIDs(@NonNull SessionsBatchDTO batch) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        Iterator<SessionRemoteEntity> iterator = batch.getSessions().iterator();
        while (iterator.hasNext()) {
            arrayList2.add(iterator.next().getId());
        }
        return arrayList2;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static CoreSession toSession(@NonNull String id2, @NonNull String os, @NonNull String uuid, @Nullable String appVersion, long startTimestampMicros, long startNanoTime) {
        void var6_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        String string2;
        return new CoreSession(string2, (String)var1_1, (String)var2_2, (String)var3_3, (long)var4_4, (long)var6_5);
    }

    private static Object extractJsonValue(Object value) {
        Object object;
        if (value != null && (object.toString().contains("{") || object.toString().contains("["))) {
            try {
                return new JSONObject(object.toString());
            }
            catch (JSONException jSONException) {
                try {
                    return new JSONArray(object.toString());
                }
                catch (JSONException jSONException2) {}
            }
        }
        return object;
    }
}

