/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.HandlerThread;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.instabug.library.APIBuildChecker;
import com.instabug.library.Feature;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.InstabugState;
import com.instabug.library.Platform;
import com.instabug.library.analytics.AnalyticsWrapper;
import com.instabug.library.analytics.model.Api;
import com.instabug.library.c;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.coreeventbus.SDKCoreEvent;
import com.instabug.library.core.eventbus.coreeventbus.SDKCoreEventPublisher;
import com.instabug.library.d;
import com.instabug.library.h;
import com.instabug.library.internal.video.InternalScreenRecordHelper;
import com.instabug.library.invocation.InstabugInvocationEvent;
import com.instabug.library.invocation.InvocationManager;
import com.instabug.library.invocation.util.InstabugFloatingButtonEdge;
import com.instabug.library.logging.InstabugUserEventLogger;
import com.instabug.library.model.Report;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.ui.onboarding.WelcomeMessage;
import com.instabug.library.user.UserEventParam;
import com.instabug.library.user.b;
import com.instabug.library.util.InstabugDeprecationLogger;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.StringUtility;
import com.instabug.library.visualusersteps.State;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class Instabug {
    @Nullable
    private static Instabug INSTANCE;
    private static final String TAG = "Instabug";
    private static InstabugState INSTABUG_STATE;
    private c delegate;

    /*
     * WARNING - void declaration
     */
    private Instabug(@NonNull c delegate) {
        void var1_1;
        this.delegate = var1_1;
    }

    static Instabug getInstance() throws IllegalStateException {
        Instabug instabug = INSTANCE;
        if (instabug != null) {
            return instabug;
        }
        throw new IllegalStateException("Instabug getInstance called before Instabug.Builder().build() was called");
    }

    @Nullable
    public static Context getApplicationContext() {
        return Instabug.getInstance().delegate.d();
    }

    public static void setDebugEnabled(boolean isDebugEnabled) {
        boolean bl;
        APIBuildChecker.check();
        AnalyticsWrapper.getInstance().catchApiUsage(new Api.Parameter().setName("isDebugEnabled").setType(Boolean.TYPE).setValue(bl));
        SettingsManager.getInstance().setDebugEnabled(bl);
        InstabugSDKLogger.i(TAG, "setDebugEnabled " + bl);
    }

    public static int getPrimaryColor() throws IllegalStateException {
        APIBuildChecker.check();
        return SettingsManager.getInstance().getPrimaryColor();
    }

    public static void setPrimaryColor(@ColorInt int primaryColorValue) throws IllegalStateException {
        int n2;
        APIBuildChecker.check();
        AnalyticsWrapper.getInstance().catchApiUsage(new Api.Parameter().setName("primaryColorValue").setType(Integer.TYPE).setValue(String.valueOf(n2)));
        SettingsManager.getInstance().setPrimaryColor(n2);
        InstabugSDKLogger.i(TAG, "setPrimaryColor");
    }

    public static InstabugColorTheme getTheme() throws IllegalStateException {
        APIBuildChecker.check();
        return SettingsManager.getInstance().getTheme();
    }

    /*
     * WARNING - void declaration
     */
    public static void addFileAttachment(@NonNull Uri fileUri, @NonNull String fileNameWithExtension) throws IllegalStateException {
        Uri uri;
        void var1_1;
        APIBuildChecker.check();
        if (fileUri == null) {
            InstabugSDKLogger.w(TAG, "fileUri object passed to Instabug.addFileAttachment() is null");
            return;
        }
        if (var1_1 == null) {
            InstabugSDKLogger.w(TAG, "fileNameWithExtension object passed to Instabug.addFileAttachment() is null");
            return;
        }
        AnalyticsWrapper.getInstance().catchLoggingApiUsage(new Api.Parameter().setName("fileUri").setType(Uri.class), new Api.Parameter().setName("fileNameWithExtension").setType(String.class));
        SettingsManager.getInstance().addExtraAttachmentFile(uri, (String)var1_1);
        InstabugSDKLogger.i(TAG, "addFileAttachment uriFile");
    }

    /*
     * WARNING - void declaration
     */
    public static void addFileAttachment(@NonNull byte[] data, @NonNull String fileNameWithExtension) throws IllegalStateException {
        byte[] byArray;
        void var1_1;
        APIBuildChecker.check();
        if (data == null) {
            InstabugSDKLogger.w(TAG, "data object passed to Instabug.addFileAttachment() is null");
            return;
        }
        if (var1_1 == null) {
            InstabugSDKLogger.w(TAG, "fileNameWithExtension object passed to Instabug.addFileAttachment() is null");
            return;
        }
        AnalyticsWrapper.getInstance().catchLoggingApiUsage(new Api.Parameter().setName("data").setType(Uri.class), new Api.Parameter().setName("fileNameWithExtension").setType(String.class));
        SettingsManager.getInstance().addExtraAttachmentFile(byArray, (String)var1_1);
        InstabugSDKLogger.i(TAG, "addFileAttachment bytes");
    }

    public static void clearFileAttachment() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsWrapper.getInstance().catchLoggingApiUsage(new Api.Parameter[0]);
        SettingsManager.getInstance().clearExtraAttachmentFiles();
        InstabugSDKLogger.i(TAG, "clearFileAttachment");
    }

    public static String getUserData() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsWrapper.getInstance().catchApiUsage(new Api.Parameter[0]);
        InstabugSDKLogger.i(TAG, "getUserData");
        return SettingsManager.getInstance().getUserData();
    }

    public static void setUserData(@NonNull String userData) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsWrapper.getInstance().catchApiUsage(new Api.Parameter().setName("userData").setType(String.class));
        if (d.d().a((Object)Feature.USER_DATA) == Feature.State.ENABLED) {
            String string;
            SettingsManager.getInstance().setUserData(StringUtility.trimString(string, 1000));
            InstabugSDKLogger.i(TAG, "setUserData");
        }
    }

    public static String getUserEmail() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsWrapper.getInstance().catchApiUsage(new Api.Parameter[0]);
        InstabugSDKLogger.i(TAG, "getUserEmail");
        return b.e();
    }

    @Nullable
    public static String getAppToken() throws IllegalStateException {
        APIBuildChecker.check();
        return SettingsManager.getInstance().getAppToken();
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static void identifyUser(@NonNull String username, @NonNull String email) {
        void var1_1;
        String string;
        APIBuildChecker.check();
        AnalyticsWrapper.getInstance().catchApiUsage(new Api.Parameter().setName("username").setType(String.class), new Api.Parameter().setName("email"));
        b.a(Instabug.getApplicationContext(), string, (String)var1_1);
        InstabugSDKLogger.i(TAG, "identifyUser username: " + string + " email" + (String)var1_1);
    }

    public static void logoutUser() {
        APIBuildChecker.check();
        AnalyticsWrapper.getInstance().catchApiUsage(new Api.Parameter[0]);
        b.n();
        InstabugSDKLogger.i(TAG, "logoutUser");
    }

    public static void setState(@NonNull InstabugState instabugState) {
        InstabugState instabugState2;
        if (instabugState == null) {
            InstabugSDKLogger.w(TAG, "instabugState object passed to Instabug.setState() is null");
            return;
        }
        INSTABUG_STATE = instabugState2;
    }

    public static InstabugState getState() {
        return INSTABUG_STATE;
    }

    public static boolean isBuilt() {
        return INSTANCE != null && Instabug.getState() != InstabugState.NOT_BUILT;
    }

    public static boolean isEnabled() {
        if (!Instabug.isBuilt()) {
            return false;
        }
        return d.d().b((Object)Feature.INSTABUG) && d.d().a((Object)Feature.INSTABUG) == Feature.State.ENABLED;
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static void enable() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsWrapper.getInstance().catchApiUsage(new Api.Parameter[0]);
        if (!Instabug.isEnabled()) {
            d.d().a(Feature.INSTABUG, Feature.State.ENABLED);
            d.d().d(Instabug.getApplicationContext());
            Instabug.getInstance().delegate.h();
        }
        InstabugSDKLogger.i(TAG, "enable");
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static void disable() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsWrapper.getInstance().catchApiUsage(new Api.Parameter[0]);
        if (Instabug.isEnabled()) {
            d.d().a(Feature.INSTABUG, Feature.State.DISABLED);
            d.d().d(Instabug.getApplicationContext());
            Instabug.getInstance().delegate.j();
        }
        InstabugSDKLogger.i(TAG, "disable");
    }

    public static void pauseSdk() throws IllegalStateException {
        APIBuildChecker.check();
        if (Instabug.getState().equals((Object)InstabugState.ENABLED)) {
            Instabug.getInstance().delegate.e();
        }
        InstabugSDKLogger.i(TAG, "pauseSdk");
    }

    public static void resumeSdk() throws IllegalStateException {
        APIBuildChecker.check();
        Instabug.getInstance().delegate.g();
        InstabugSDKLogger.i(TAG, "pauseSdk");
    }

    public static void setLocale(@NonNull Locale locale) throws IllegalStateException {
        Locale locale2;
        APIBuildChecker.check();
        if (locale == null) {
            InstabugSDKLogger.w(TAG, "locale object passed to Instabug.setLocale is null");
            return;
        }
        AnalyticsWrapper.getInstance().catchApiUsage(new Api.Parameter().setName("locale").setType(Locale.class).setValue(locale2));
        Instabug.getInstance().delegate.a(locale2);
        InstabugSDKLogger.i(TAG, "setLocale");
    }

    public static Locale getLocale(@NonNull Context context) throws IllegalStateException {
        Context context2;
        APIBuildChecker.check();
        return SettingsManager.getInstance().getInstabugLocale(context2);
    }

    public static void addTags(String ... tags) {
        APIBuildChecker.check();
        AnalyticsWrapper.getInstance().catchApiUsage(new Api.Parameter[0]);
        SettingsManager.getInstance().addTags(StringUtility.trimStrings(tags));
        InstabugSDKLogger.i(TAG, "addTags");
    }

    @Nullable
    public static ArrayList<String> getTags() {
        APIBuildChecker.check();
        AnalyticsWrapper.getInstance().catchApiUsage(new Api.Parameter[0]);
        return SettingsManager.getInstance().getTags();
    }

    public static void resetTags() {
        APIBuildChecker.check();
        AnalyticsWrapper.getInstance().catchApiUsage(new Api.Parameter[0]);
        SettingsManager.getInstance().resetTags();
        InstabugSDKLogger.i(TAG, "resetTags");
    }

    public static void setCustomTextPlaceHolders(@NonNull InstabugCustomTextPlaceHolder instabugCustomTextPlaceHolder) {
        InstabugCustomTextPlaceHolder instabugCustomTextPlaceHolder2;
        APIBuildChecker.check();
        if (instabugCustomTextPlaceHolder == null) {
            InstabugSDKLogger.w(TAG, "instabugCustomTextPlaceHolder object passed to Instabug.setCustomTextPlaceHolders() is null");
            return;
        }
        AnalyticsWrapper.getInstance().catchApiUsage(new Api.Parameter().setName("instabugCustomTextPlaceHolder").setType(InstabugCustomTextPlaceHolder.class));
        SettingsManager.getInstance().setCustomPlaceHolders(instabugCustomTextPlaceHolder2);
        InstabugSDKLogger.i(TAG, "setCustomTextPlaceHolders");
    }

    @Nullable
    public static HashMap<String, String> getAllUserAttributes() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsWrapper.getInstance().catchApiUsage(new Api.Parameter[0]);
        InstabugSDKLogger.i(TAG, "getAllUserAttributes");
        return Instabug.getInstance().delegate.c();
    }

    /*
     * WARNING - void declaration
     */
    public static void setUserAttribute(@NonNull String key, @NonNull String value) throws IllegalStateException {
        void var1_1;
        String string;
        APIBuildChecker.check();
        AnalyticsWrapper.getInstance().catchApiUsage(new Api.Parameter().setName("key").setType(String.class), new Api.Parameter().setName("value").setType(String.class));
        Instabug.getInstance().delegate.a(string, (String)var1_1);
        InstabugSDKLogger.i(TAG, "setUserAttribute");
    }

    @Nullable
    public static String getUserAttribute(@NonNull String key) throws IllegalStateException {
        String string;
        APIBuildChecker.check();
        AnalyticsWrapper.getInstance().catchApiUsage(new Api.Parameter().setName("key").setType(String.class));
        InstabugSDKLogger.i(TAG, "getUserAttribute");
        return Instabug.getInstance().delegate.a(string);
    }

    public static void removeUserAttribute(@NonNull String key) throws IllegalStateException {
        String string;
        APIBuildChecker.check();
        AnalyticsWrapper.getInstance().catchApiUsage(new Api.Parameter().setName("key").setType(String.class));
        Instabug.getInstance().delegate.b(string);
        InstabugSDKLogger.i(TAG, "removeUserAttribute");
    }

    public static void clearAllUserAttributes() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsWrapper.getInstance().catchApiUsage(new Api.Parameter[0]);
        Instabug.getInstance().delegate.b();
        InstabugSDKLogger.i(TAG, "clearAllUserAttributes");
    }

    public static Date getFirstRunAt() {
        return SettingsManager.getInstance().getFirstRunAt();
    }

    public static boolean isAppOnForeground() {
        return SettingsManager.getInstance().isAppOnForeground();
    }

    public static void setWelcomeMessageState(@NonNull WelcomeMessage.State welcomeMessageState) {
        WelcomeMessage.State state;
        if (welcomeMessageState == null) {
            InstabugSDKLogger.w(TAG, "welcomeMessageState object passed to Instabug.setWelcomeMessageState() is null");
            return;
        }
        APIBuildChecker.check();
        AnalyticsWrapper.getInstance().catchApiUsage(new Api.Parameter().setName("WelcomeMessageState").setType(String.class).setValue(state.toString()));
        SettingsManager.getInstance().setWelcomeMessageState(state);
        InstabugSDKLogger.i(TAG, "setWelcomeMessageState: " + state.name());
    }

    public static void showWelcomeMessage(@NonNull WelcomeMessage.State welcomeMessageState) {
        WelcomeMessage.State state;
        if (welcomeMessageState == null) {
            InstabugSDKLogger.w(TAG, "welcomeMessageState object passed to Instabug.showWelcomeMessage() is null");
            return;
        }
        APIBuildChecker.check();
        AnalyticsWrapper.getInstance().catchApiUsage(new Api.Parameter().setName("showWelcomeMessage").setType(String.class).setValue(state.toString()));
        if (!InstabugCore.isForegroundBusy()) {
            Instabug.getInstance().delegate.a(state);
        }
        InstabugSDKLogger.i(TAG, "showWelcomeMessage: " + state.name());
    }

    @Deprecated
    public static void setViewHierarchyState(@NonNull Feature.State state) {
        Feature.State state2;
        APIBuildChecker.check();
        if (state == null) {
            InstabugSDKLogger.w(TAG, "state object passed to Instabug.setViewHierarchyState() is null");
            return;
        }
        AnalyticsWrapper.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state2));
        d.d().a(Feature.VIEW_HIERARCHY_V2, state2);
        InstabugSDKLogger.i(TAG, "setViewHierarchyState: " + state2.name());
    }

    @Deprecated
    public static void setAutoScreenRecordingMaxDuration(int autoScreenRecordingMaxDuration) {
        int n2;
        APIBuildChecker.check();
        AnalyticsWrapper.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("setAutoScreenRecordingMaxDuration").setType(Boolean.class).setValue(String.valueOf(n2)));
        SettingsManager.getInstance().setAutoScreenRecordingMaxDuration(n2);
        Log.e((String)Instabug.class.getName(), (String)"AutoScreen recording is disabled please contact support for further details.");
        InstabugSDKLogger.i(TAG, "setAutoScreenRecordingMaxDuration " + n2);
    }

    public static void setSessionProfilerState(@NonNull Feature.State state) {
        Feature.State state2;
        APIBuildChecker.check();
        if (state == null) {
            InstabugSDKLogger.w(TAG, "state object passed to Instabug.setSessionProfilerState() is null");
            return;
        }
        AnalyticsWrapper.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state2));
        Instabug.getInstance().delegate.a(state2);
        InstabugSDKLogger.i(TAG, "setSessionProfilerState: " + state2.name());
    }

    public static void setTrackingUserStepsState(@NonNull Feature.State state) {
        Feature.State state2;
        APIBuildChecker.check();
        if (state == null) {
            InstabugSDKLogger.w(TAG, "state object passed to Instabug.setTrackingUserStepsState() is null");
            return;
        }
        AnalyticsWrapper.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state2));
        d.d().a(Feature.TRACK_USER_STEPS, state2);
        InstabugSDKLogger.i(TAG, "setTrackingUserStepsState: " + state2.name());
    }

    public static void setReproStepsState(State reproStepsState) {
        State state;
        if (reproStepsState == null) {
            InstabugSDKLogger.w(TAG, "reproStepsState object passed to Instabug.setReproStepsState() is null");
            return;
        }
        if (state == State.ENABLED) {
            d.d().a(Feature.REPRO_STEPS, Feature.State.ENABLED);
            SettingsManager.getInstance().setReproStepsScreenshotEnabled(true);
        } else if (state == State.ENABLED_WITH_NO_SCREENSHOTS) {
            d.d().a(Feature.REPRO_STEPS, Feature.State.ENABLED);
            SettingsManager.getInstance().setReproStepsScreenshotEnabled(false);
        } else if (state == State.DISABLED) {
            d.d().a(Feature.REPRO_STEPS, Feature.State.DISABLED);
        }
        InstabugSDKLogger.i(TAG, "setReproStepsState: " + state.name());
    }

    public static void setColorTheme(@NonNull InstabugColorTheme instabugTheme) {
        InstabugColorTheme instabugColorTheme;
        APIBuildChecker.check();
        if (instabugTheme == null) {
            InstabugSDKLogger.w(TAG, "instabugTheme object passed to Instabug.setColorTheme() is null");
            return;
        }
        AnalyticsWrapper.getInstance().catchApiUsage(new Api.Parameter().setName("instabugTheme").setType(InstabugColorTheme.class).setValue((Object)instabugColorTheme));
        SettingsManager.getInstance().setTheme(instabugColorTheme);
        int n2 = a.a[instabugColorTheme.ordinal()];
        if (n2 != 1) {
            if (n2 == 2) {
                SettingsManager.getInstance().setPrimaryColor(-15893761);
                SettingsManager.getInstance().setStatusBarColor(-3815737);
            }
        } else {
            SettingsManager.getInstance().setPrimaryColor(-9580554);
            SettingsManager.getInstance().setStatusBarColor(-16119286);
        }
        InstabugSDKLogger.i(TAG, "setColorTheme: " + instabugColorTheme.name());
    }

    public static void logUserEvent(@NonNull String eventIdentifier) throws IllegalStateException {
        String string;
        APIBuildChecker.check();
        AnalyticsWrapper.getInstance().catchApiUsage(new Api.Parameter().setName("eventIdentifier").setType(String.class));
        InstabugUserEventLogger.getInstance().logUserEvent(string, new UserEventParam[0]);
        InstabugSDKLogger.i(TAG, "logUserEvent");
    }

    public static void onReportSubmitHandler(Report.OnReportCreatedListener listener) {
        Report.OnReportCreatedListener onReportCreatedListener;
        APIBuildChecker.check();
        AnalyticsWrapper.getInstance().catchApiUsage(new Api.Parameter().setName("listener").setType(Report.OnReportCreatedListener.class));
        SettingsManager.getInstance().setOnReportCreatedListener(onReportCreatedListener);
        InstabugSDKLogger.i(TAG, "onReportSubmitHandler");
    }

    @VisibleForTesting
    static void setAutoScreenRecordingDuration(@IntRange(from=30L, to=180L) int maxDuration) {
        int n2;
        AnalyticsWrapper.getInstance().catchApiUsage(new Api.Parameter().setName("maxDuration").setType(Integer.class).setValue(n2));
        SettingsManager.getInstance().setAutoScreenRecordingDuration(n2);
        InstabugSDKLogger.i(TAG, "setAutoScreenRecordingDuration: " + n2);
    }

    @VisibleForTesting
    static void setAutoScreenRecordingAudioCapturingEnabled(Feature.State isASRAudioEnabled) {
        Feature.State state;
        if (isASRAudioEnabled == null) {
            InstabugSDKLogger.w(TAG, "isASRAudioEnabled object passed to Instabug.setAutoScreenRecordingAudioCapturingEnabled() is null");
            return;
        }
        AnalyticsWrapper.getInstance().catchApiUsage(new Api.Parameter().setName("asrAudioCapturingEnabled").setType(Feature.State.class).setValue(state.name()));
        SettingsManager.getInstance().setAutoScreenRecordingAudioCapturingState(state);
        InstabugSDKLogger.i(TAG, "setAutoScreenRecordingAudioCapturingEnabled: " + state.name());
    }

    public static void show() {
        APIBuildChecker.check();
        AnalyticsWrapper.getInstance().catchApiUsage(new Api.Parameter[0]);
        InvocationManager.getInstance().show();
        InstabugSDKLogger.i(TAG, "show");
    }

    @Deprecated
    public static void setViewsAsPrivate(View ... views) {
        APIBuildChecker.check();
        AnalyticsWrapper.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        if (Instabug.getInstance() != null && Instabug.getInstance().delegate != null) {
            View[] viewArray;
            Instabug.getInstance().delegate.c(viewArray);
        }
        InstabugSDKLogger.i(TAG, "setViewsAsPrivate");
    }

    public static void addPrivateViews(View ... views) {
        APIBuildChecker.check();
        AnalyticsWrapper.getInstance().catchApiUsage(new Api.Parameter[0]);
        if (Instabug.getInstance() != null && Instabug.getInstance().delegate != null) {
            View[] viewArray;
            Instabug.getInstance().delegate.a(viewArray);
        }
        InstabugSDKLogger.i(TAG, "addPrivateViews");
    }

    public static void removePrivateViews(View ... views) {
        APIBuildChecker.check();
        AnalyticsWrapper.getInstance().catchApiUsage(new Api.Parameter[0]);
        if (Instabug.getInstance() != null && Instabug.getInstance().delegate != null) {
            View[] viewArray;
            Instabug.getInstance().delegate.b(viewArray);
        }
        InstabugSDKLogger.i(TAG, "removePrivateViews");
    }

    public static boolean isBuilding() {
        return Instabug.getState() == InstabugState.BUILDING;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    private static void disableInternal() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsWrapper.getInstance().catchApiUsage(new Api.Parameter[0]);
        Instabug.getInstance().delegate.j();
        InstabugSDKLogger.i(TAG, "disable");
    }

    /*
     * WARNING - void declaration
     */
    private static void reportScreenChange(@Nullable Bitmap screenshot, @NonNull String screenName) {
        void var1_1;
        Bitmap bitmap;
        if (!Instabug.isBuilt()) {
            Log.i((String)TAG, (String)"reportScreenChange() was called before building the SDK");
            return;
        }
        if (bitmap != null) {
            AnalyticsWrapper.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("screenshot").setType(Bitmap.class).setValue(bitmap));
        }
        AnalyticsWrapper.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("screenName").setType(String.class).setValue(var1_1));
        Instabug.getInstance().delegate.a(bitmap, (String)var1_1);
    }

    private static void setCurrentPlatform(@Platform int platform) {
        int n2;
        SettingsManager.getInstance().setCurrentPlatform(n2);
    }

    static {
        INSTABUG_STATE = InstabugState.NOT_BUILT;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    public static class Builder {
        private String applicationToken;
        private Context applicationContext;
        @Nullable
        private Application application;
        private int instabugStatusBarColor;
        private InstabugInvocationEvent[] instabugInvocationEvents;
        private Feature.State userDataState;
        private Feature.State consoleLogState;
        private Feature.State instabugLogState;
        private Feature.State inAppMessagingState;
        private Feature.State crashReportingState;
        private Feature.State pushNotificationState;
        private Feature.State trackingUserStepsState;
        private State reproStepsState;
        private Feature.State viewHierarchyState;
        private Feature.State surveysState;
        private Feature.State userEventsState;
        private Feature.State anrDefaultState;
        private boolean emailFieldRequired;
        private boolean emailFieldVisibility;
        private boolean commentFieldRequired;
        private boolean introMessageEnabled;
        private boolean shouldPlaySounds;
        private boolean successDialogEnabled;
        private InstabugFloatingButtonEdge instabugFloatingButtonEdge;
        private int shakingThreshold;
        private int floatingButtonOffsetFromTop;
        private boolean isSurveysAutoShowing;
        private boolean chatPromptOptionEnable;
        private boolean bugPromptOptionEnable;
        private boolean feedbackPromptOptionEnable;
        private List<Integer> deprecatedMethodsToBeLogedAfterBuild;

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull Application application, @NonNull String applicationToken) {
            void var2_2;
            void var1_1;
            InstabugInvocationEvent[] instabugInvocationEventArray = this_;
            InstabugInvocationEvent[] instabugInvocationEventArray2 = new InstabugInvocationEvent[1];
            InstabugInvocationEvent[] this_ = instabugInvocationEventArray2;
            instabugInvocationEventArray2[0] = InstabugInvocationEvent.SHAKE;
            super((Application)var1_1, (String)var2_2, this_);
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull Application application, @NonNull String applicationToken, InstabugInvocationEvent ... instabugInvocationEvent) {
            this(var1_1.getApplicationContext(), (String)var2_2, (InstabugInvocationEvent[])var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
            this.application = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        Builder(@NonNull Context applicationContext, @NonNull String applicationToken, InstabugInvocationEvent ... instabugInvocationEvents) {
            void var2_2;
            void var3_3;
            void var1_1;
            Builder builder = this_;
            Builder builder2 = this_;
            Builder builder3 = this_;
            this_.instabugStatusBarColor = -3815737;
            this_.instabugInvocationEvents = new InstabugInvocationEvent[]{InstabugInvocationEvent.SHAKE};
            Object this_ = d.g;
            v3.userDataState = this_;
            v3.consoleLogState = this_;
            v3.instabugLogState = this_;
            v3.inAppMessagingState = this_;
            v3.crashReportingState = this_;
            v3.pushNotificationState = this_;
            v3.trackingUserStepsState = this_;
            v3.reproStepsState = State.ENABLED;
            v3.viewHierarchyState = Feature.State.DISABLED;
            this_ = d.g;
            v3.surveysState = this_;
            v3.userEventsState = this_;
            v3.anrDefaultState = this_;
            v3.emailFieldRequired = true;
            v3.emailFieldVisibility = true;
            v3.commentFieldRequired = false;
            v3.introMessageEnabled = true;
            v3.shouldPlaySounds = false;
            v3.successDialogEnabled = true;
            v3.instabugFloatingButtonEdge = InstabugFloatingButtonEdge.RIGHT;
            v3.shakingThreshold = 650;
            v3.floatingButtonOffsetFromTop = -1;
            v3.isSurveysAutoShowing = true;
            v3.chatPromptOptionEnable = true;
            v3.bugPromptOptionEnable = true;
            v3.feedbackPromptOptionEnable = true;
            v3.deprecatedMethodsToBeLogedAfterBuild = new ArrayList<Integer>();
            builder3.applicationContext = var1_1;
            builder2.instabugInvocationEvents = var3_3;
            builder.applicationToken = var2_2;
        }

        private void logDeprecatedApis() {
            Iterator<Integer> this_ = ((Builder)((Object)this_)).deprecatedMethodsToBeLogedAfterBuild.iterator();
            while (this_.hasNext()) {
                InstabugDeprecationLogger.getInstance().log((Integer)this_.next());
            }
        }

        private void setFeaturesStates(Boolean isInstabugEnabled) {
            Feature feature = Feature.USER_DATA;
            d.d().a(feature, ((Builder)object).userDataState);
            feature = Feature.INSTABUG_LOGS;
            d.d().a(feature, ((Builder)object).instabugLogState);
            feature = Feature.CONSOLE_LOGS;
            d.d().a(feature, ((Builder)object).consoleLogState);
            feature = Feature.CRASH_REPORTING;
            d.d().a(feature, ((Builder)object).crashReportingState);
            feature = Feature.IN_APP_MESSAGING;
            d.d().a(feature, ((Builder)object).inAppMessagingState);
            feature = Feature.PUSH_NOTIFICATION;
            d.d().a(feature, ((Builder)object).pushNotificationState);
            feature = Feature.TRACK_USER_STEPS;
            d.d().a(feature, ((Builder)object).trackingUserStepsState);
            Instabug.setReproStepsState(((Builder)object).reproStepsState);
            feature = Feature.VIEW_HIERARCHY_V2;
            d.d().a(feature, ((Builder)object).viewHierarchyState);
            feature = Feature.SURVEYS;
            d.d().a(feature, ((Builder)object).surveysState);
            feature = Feature.USER_EVENTS;
            d.d().a(feature, ((Builder)object).userEventsState);
            Builder builder = object;
            Object object = Feature.ANR_REPORTING;
            d.d().a((Feature)((Object)object), builder.anrDefaultState);
            object = d.d();
            feature = Feature.INSTABUG;
            Feature.State state = isInstabugEnabled != false ? Feature.State.ENABLED : Feature.State.DISABLED;
            ((d)object).a(feature, state);
        }

        /*
         * WARNING - void declaration
         */
        private void logFeaturesStates(Boolean isInstabugEnabled) {
            void var1_1;
            Builder builder = this;
            InstabugSDKLogger.v(builder, "User data feature state is set to " + (Object)((Object)this.userDataState));
            InstabugSDKLogger.v(builder, "Console log feature state is set to " + (Object)((Object)this.consoleLogState));
            InstabugSDKLogger.v(builder, "Instabug logs feature state is set to " + (Object)((Object)this.instabugLogState));
            InstabugSDKLogger.v(builder, "Crash reporting feature state is set to " + (Object)((Object)this.crashReportingState));
            InstabugSDKLogger.v(builder, "In-App messaging feature state is set to" + (Object)((Object)this.inAppMessagingState));
            InstabugSDKLogger.v(builder, "Push notification feature state is set to " + (Object)((Object)this.pushNotificationState));
            InstabugSDKLogger.v(builder, "Tracking user steps feature state is set to " + (Object)((Object)this.trackingUserStepsState));
            InstabugSDKLogger.v(builder, "Repro steps feature state is set to " + (Object)((Object)this.reproStepsState));
            InstabugSDKLogger.v(builder, "View hierarchy feature state is set to " + (Object)((Object)this.viewHierarchyState));
            InstabugSDKLogger.v(builder, "Surveys feature state is set to " + (Object)((Object)this.surveysState));
            InstabugSDKLogger.v(builder, "User events feature state is set to " + (Object)((Object)this.userEventsState));
            InstabugSDKLogger.v(builder, "Instabug overall state is set to " + var1_1);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$600(Builder x0, Boolean x1) {
            void var1_1;
            x0.logFeaturesStates((Boolean)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public Builder setInvocationEvents(InstabugInvocationEvent ... instabugInvocationEvents) {
            void var1_1;
            AnalyticsWrapper.getInstance().catchApiUsage(new Api.Parameter().setName("instabugInvocationEvent").setType(InstabugInvocationEvent.class).setValue(TextUtils.join((CharSequence)",", (Object[])var1_1)));
            this.instabugInvocationEvents = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setTrackingUserStepsState(@NonNull Feature.State state) {
            void var1_1;
            AnalyticsWrapper.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue(var1_1));
            this.trackingUserStepsState = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setReproStepsState(State state) {
            void var1_1;
            AnalyticsWrapper.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(State.class).setValue(var1_1));
            this.reproStepsState = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setConsoleLogState(@NonNull Feature.State state) {
            void var1_1;
            AnalyticsWrapper.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue(var1_1));
            this.consoleLogState = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setInstabugLogState(@NonNull Feature.State state) {
            void var1_1;
            AnalyticsWrapper.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue(var1_1));
            this.instabugLogState = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setUserDataState(@NonNull Feature.State state) {
            void var1_1;
            AnalyticsWrapper.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue(var1_1));
            this.userDataState = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setInAppMessagingState(@NonNull Feature.State state) {
            void var1_1;
            AnalyticsWrapper.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue(var1_1));
            this.inAppMessagingState = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setViewHierarchyState(@NonNull Feature.State state) {
            void var1_1;
            AnalyticsWrapper.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue(var1_1));
            this.viewHierarchyState = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setUserEventsState(@NonNull Feature.State state) {
            void var1_1;
            AnalyticsWrapper.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue(var1_1));
            this.userEventsState = var1_1;
            return this;
        }

        public Instabug build(Feature.State instabugInitialState) {
            c c2;
            final c c3 = c2;
            c2 = new c(this.applicationContext);
            INSTANCE = new Instabug(c3);
            InstabugSDKLogger.initLogger(this.applicationContext);
            final boolean bl = instabugInitialState == Feature.State.ENABLED;
            Builder builder = this;
            builder.setFeaturesStates(bl);
            Instabug.setState(InstabugState.BUILDING);
            builder.logDeprecatedApis();
            String string = SettingsManager.getInstance().getAppToken();
            String string2 = builder.applicationToken;
            if (string2 != null && string != null && !string2.equals(string)) {
                b.n();
            }
            SettingsManager.getInstance().setAppToken(this.applicationToken);
            com.instabug.library.core.plugin.a.a(this.applicationContext);
            h.a(SettingsManager.getInstance());
            HandlerThread handlerThread = new HandlerThread("Sdk start thread"){

                @SuppressLint(value={"STRICT_MODE_VIOLATION"})
                protected void onLooperPrepared() {
                    a a2 = this;
                    a2.c3.a(Builder.this.applicationContext);
                    a2.c3.b(Builder.this.applicationContext);
                    a2.c3.h();
                    InvocationManager.getInstance().getCurrentInvocationSettings().setFloatingButtonEdge(Builder.this.instabugFloatingButtonEdge);
                    InvocationManager.getInstance().notifyPrimaryColorChanged();
                    InvocationManager.getInstance().setInstabugInvocationEvent(Builder.this.instabugInvocationEvents);
                    if (a2.Builder.this.floatingButtonOffsetFromTop != -1) {
                        InvocationManager.getInstance().getCurrentInvocationSettings().setFloatingButtonOffsetFromTop(Builder.this.floatingButtonOffsetFromTop);
                    }
                    Instabug.setState(bl ? InstabugState.ENABLED : InstabugState.DISABLED);
                    SDKCoreEventPublisher.post(new SDKCoreEvent("sdk_state", "built"));
                    Builder.access$600(Builder.this, bl);
                    InstabugSDKLogger.i(Instabug.TAG, "Built");
                }
            };
            handlerThread.setPriority(10);
            handlerThread.start();
            return INSTANCE;
        }

        public Instabug build() {
            if (Instabug.isBuilt()) {
                if (InternalScreenRecordHelper.getInstance().isRecording()) {
                    InternalScreenRecordHelper.getInstance().cancel();
                }
                Instabug.disable();
            }
            return this.build(Feature.State.ENABLED);
        }
    }
}

