/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Environment;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.Instabug;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

@SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
public class AttachmentManager {
    public static final String TAG = "AttachmentManager";
    private static final double MAX_FILE_SIZE_IN_MB = 50.0;

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static File getAttachmentDirectory(@Nullable Context context) {
        File file;
        Object object;
        if (context == null && Instabug.isBuilt()) {
            object = Instabug.getApplicationContext();
        }
        if (object == null) {
            return null;
        }
        if (object.getExternalFilesDir(null) != null && Environment.getExternalStorageState().equals("mounted")) {
            try {
                object = object.getExternalFilesDir(null).getAbsolutePath();
            }
            catch (NullPointerException nullPointerException) {
                object = AttachmentManager.getInternalStoragePath(object);
            }
        } else {
            object = AttachmentManager.getInternalStoragePath(object);
        }
        File file2 = file;
        if (!new File((String)object + "/instabug/").exists()) {
            file2.mkdirs();
            try {
                new File(file2, ".nomedia").createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file2;
    }

    /*
     * WARNING - void declaration
     */
    public static File getNewDirectory(@Nullable Context context, String directoryName) {
        void var1_1;
        Context context2;
        File file;
        File file2 = file;
        if (!new File(AttachmentManager.getAttachmentDirectory(context2) + "/" + (String)var1_1 + "/").exists()) {
            file2.mkdirs();
            try {
                new File(file2, ".nomedia").createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file2;
    }

    public static File getVideoFile(Context context) {
        SimpleDateFormat simpleDateFormat;
        Object object = AttachmentManager.getVideoRecordingVideosDirectory(context);
        Object object2 = simpleDateFormat;
        simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS", Locale.getDefault());
        object2 = "video-" + ((DateFormat)object2).format(new Date()) + ".mp4";
        return new File((File)object, (String)object2);
    }

    public static File getVideoRecordingFramesDirectory(Context context) {
        Context context2;
        File file;
        File file2 = file;
        if (!new File(AttachmentManager.getAttachmentDirectory(context2) + "/frames/").exists()) {
            file2.mkdirs();
            try {
                new File(file2, ".nomedia").createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file2;
    }

    public static File getVideoRecordingVideosDirectory(Context context) {
        Context context2;
        File file;
        File file2 = file;
        if (!new File(AttachmentManager.getAttachmentDirectory(context2) + "/videos/").exists()) {
            file2.mkdirs();
            try {
                new File(file2, ".nomedia").createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file2;
    }

    public static File getAutoScreenRecordingVideosDirectory(Context context) {
        Context context2;
        File file;
        File file2 = file;
        if (!new File(AttachmentManager.getAttachmentDirectory(context2) + "/auto_recording/").exists()) {
            file2.mkdirs();
            try {
                new File(file2, ".nomedia").createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file2;
    }

    public static File getAutoScreenRecordingFile(Context context) {
        SimpleDateFormat simpleDateFormat;
        Object object = AttachmentManager.getAutoScreenRecordingVideosDirectory(context);
        Object object2 = simpleDateFormat;
        simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS", Locale.ENGLISH);
        object2 = "auto-recording-" + ((DateFormat)object2).format(new Date()) + ".mp4";
        return new File((File)object, (String)object2);
    }

    private static String getInternalStoragePath(Context context) {
        InstabugSDKLogger.w(TAG, "External storage not available, saving file to internal storage.");
        return context.getFilesDir().getAbsolutePath();
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"RESOURCE_LEAK"})
    private static void saveBytesToFile(byte[] data, File file) {
        void var0_11;
        BufferedOutputStream bufferedOutputStream;
        block23: {
            void var1_12;
            byte[] byArray;
            BufferedOutputStream bufferedOutputStream2;
            Object var2_14 = null;
            bufferedOutputStream = bufferedOutputStream2;
            byte[] byArray2 = byArray;
            bufferedOutputStream(new FileOutputStream((File)var1_12));
            bufferedOutputStream2.write(byArray2);
            try {
                bufferedOutputStream2.flush();
                bufferedOutputStream2.close();
                return;
            }
            catch (IOException iOException) {
                void var0_2;
                block24: {
                    block22: {
                        block21: {
                            if (iOException.getMessage() == null) return;
                            break block24;
                            catch (IOException iOException2) {
                                break block21;
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                break block22;
                            }
                            catch (Throwable throwable) {
                                bufferedOutputStream = var2_14;
                                break block23;
                            }
                            catch (IOException iOException3) {
                                bufferedOutputStream = var2_14;
                            }
                        }
                        if (byArray.getMessage() != null) {
                            InstabugSDKLogger.e(TAG, byArray.getMessage(), (Throwable)byArray);
                        }
                        if (bufferedOutputStream == null) return;
                        try {
                            BufferedOutputStream bufferedOutputStream3 = bufferedOutputStream;
                            bufferedOutputStream3.flush();
                            bufferedOutputStream3.close();
                            return;
                        }
                        catch (IOException iOException4) {
                            if (iOException4.getMessage() == null) return;
                        }
                        break block24;
                        catch (FileNotFoundException fileNotFoundException) {
                            bufferedOutputStream = var2_14;
                        }
                    }
                    if (byArray.getMessage() != null) {
                        InstabugSDKLogger.e(TAG, byArray.getMessage(), (Throwable)byArray);
                    }
                    if (bufferedOutputStream == null) return;
                    try {
                        BufferedOutputStream bufferedOutputStream4 = bufferedOutputStream;
                        bufferedOutputStream4.flush();
                        bufferedOutputStream4.close();
                        return;
                    }
                    catch (IOException iOException5) {
                        if (iOException5.getMessage() == null) return;
                    }
                }
                InstabugSDKLogger.e(TAG, var0_2.getMessage(), (Throwable)var0_2);
                return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (bufferedOutputStream == null) throw var0_11;
        try {
            BufferedOutputStream bufferedOutputStream5 = bufferedOutputStream;
            bufferedOutputStream5.flush();
            bufferedOutputStream5.close();
            throw var0_11;
        }
        catch (IOException iOException) {
            if (iOException.getMessage() == null) throw var0_11;
            InstabugSDKLogger.e(TAG, iOException.getMessage(), iOException);
        }
        throw var0_11;
    }

    /*
     * WARNING - void declaration
     */
    private static File getAttachmentFile(Context context, String fileName) {
        void var1_1;
        File file;
        Object object = AttachmentManager.getAttachmentDirectory(context);
        File file2 = file;
        if (new File((File)object, (String)var1_1).exists()) {
            File file3;
            file2 = file3;
            file3 = new File((File)object, String.valueOf(System.currentTimeMillis()) + "_" + (String)var1_1);
        }
        return file2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static Uri getUriFromBytes(Context context, byte[] data, String fileName) {
        void var2_2;
        Object object;
        object = AttachmentManager.getAttachmentFile(object, (String)var2_2);
        AttachmentManager.saveBytesToFile(data, (File)object);
        return Uri.fromFile((File)object);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyFromUriIntoFile(@Nullable Context context, @NonNull Uri source, File target) {
        block40: {
            block33: {
                block41: {
                    block32: {
                        if (context == null) {
                            return;
                        }
                        if (var0 /* !! */ .getContentResolver() == null) {
                            return;
                        }
                        var3_19 = null;
                        var4_20 = null;
                        var1_15 = var0 /* !! */ .getContentResolver().openInputStream((Uri)var1_15);
                        var0 /* !! */  = var0 /* !! */ .getContentResolver().openOutputStream(Uri.fromFile((File)var2_17));
                        if (var1_15 == null) return;
                        if (var0 /* !! */  != null) break block32;
                        return;
                    }
                    var5_21 = v0;
                    v0 = new BufferedInputStream((InputStream)var1_15);
                    InstabugSDKLogger.d("AttachmentManager", "Target file path: " + var2_17.getPath());
                    var1_15 = v1;
                    v1 = new BufferedOutputStream((OutputStream)var0 /* !! */ );
                    var0 /* !! */  = (Context)new byte[32768];
                    break block41;
                    catch (Throwable var0_5) {
                        var1_15 = var4_20;
                        break block33;
                    }
                    catch (IOException var0_6) {
                        var1_15 = var4_20;
                        ** GOTO lbl61
                    }
                    catch (FileNotFoundException var0_7) {
                        var1_15 = var4_20;
                        ** GOTO lbl78
                    }
                    catch (Throwable var0_8) {
                        var5_21 = var3_19;
                        var1_15 = var4_20;
                        break block33;
                    }
                    catch (IOException var0_9) {
                        var1_15 = var4_20;
                        var5_21 = var3_19;
                        ** GOTO lbl61
                    }
                    catch (FileNotFoundException var0_11) {
                        var1_15 = var4_20;
                        var5_21 = var3_19;
                        ** GOTO lbl78
                    }
                }
                while ((var2_18 = var5_21.read((byte[])var0 /* !! */ )) > 0) {
                    var1_15.write((byte[])var0 /* !! */ , 0, var2_18);
                }
                try {
                    var1_15.close();
                    var5_21.close();
                    return;
                }
                catch (IOException var0_1) {
                    block42: {
                        block39: {
                            block38: {
                                block35: {
                                    block37: {
                                        block36: {
                                            block34: {
                                                if (var0_1.getMessage() == null) return;
                                                break block42;
                                                catch (IOException var0_3) {
                                                    break block34;
                                                }
                                                catch (FileNotFoundException var0_4) {
                                                    break block35;
                                                }
                                            }
                                            if (var0 /* !! */ .getMessage() != null) {
                                                InstabugSDKLogger.e("AttachmentManager", var0 /* !! */ .getMessage(), (Throwable)var0 /* !! */ );
                                            }
                                            if (var1_15 == null) break block36;
                                            try {
                                                var1_15.close();
                                            }
                                            catch (IOException var0_10) {
                                                break block37;
                                            }
                                        }
                                        if (var5_21 == null) return;
                                        var5_21.close();
                                        return;
                                    }
                                    if (var0_10.getMessage() == null) return;
                                    break block42;
                                }
                                if (var0 /* !! */ .getMessage() != null) {
                                    InstabugSDKLogger.e("AttachmentManager", var0 /* !! */ .getMessage(), (Throwable)var0 /* !! */ );
                                }
                                if (var1_15 == null) break block38;
                                try {
                                    var1_15.close();
                                }
                                catch (IOException var0_12) {
                                    break block39;
                                }
                            }
                            if (var5_21 == null) return;
                            var5_21.close();
                            return;
                        }
                        if (var0_12.getMessage() == null) return;
                    }
                    InstabugSDKLogger.e("AttachmentManager", var0_2.getMessage(), (Throwable)var0_2);
                    return;
                }
                catch (Throwable var0_13) {
                    // empty catch block
                }
            }
            if (var1_15 != null) {
                try {
                    var1_15.close();
                }
                catch (IOException var1_16) {
                    break block40;
                }
            }
            if (var5_21 == null) throw var0_14;
            var5_21.close();
            throw var0_14;
        }
        if (var1_16.getMessage() == null) throw var0_14;
        InstabugSDKLogger.e("AttachmentManager", var1_16.getMessage(), var1_16);
        throw var0_14;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static String getGalleryImagePath(Activity activity, Uri uri) {
        void var1_2;
        if (activity != null && var1_2 != null) {
            Cursor cursor;
            Cursor cursor2 = cursor;
            Cursor cursor3 = new String[1];
            cursor = cursor3;
            cursor3[0] = "_data";
            if ((cursor = cursor2.managedQuery((Uri)var1_2, (String[])cursor, null, null, null)) != null) {
                Cursor cursor4 = cursor;
                int n2 = cursor4.getColumnIndexOrThrow("_data");
                cursor4.moveToFirst();
                return cursor4.getString(n2);
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static Uri getNewFileUri(Context context, Uri originalUri, @Nullable String fileNameWithExtension) {
        Object object;
        void var2_2;
        void var1_1;
        if (originalUri == null) {
            return null;
        }
        String string = "";
        String string2 = var1_1.getLastPathSegment();
        if (string2 != null) {
            string = string2.toLowerCase();
        }
        if (var2_2 != null && SettingsManager.getInstance().getExtraAttachmentFiles() != null && SettingsManager.getInstance().getExtraAttachmentFiles().containsKey(var1_1)) {
            string = var2_2;
        }
        Context context2 = object;
        object = AttachmentManager.getAttachmentFile(object, string);
        AttachmentManager.copyFromUriIntoFile(context2, (Uri)var1_1, (File)object);
        if (!AttachmentManager.validateFileSize((Uri)var1_1, (File)object)) {
            return null;
        }
        return Uri.fromFile((File)object);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static Uri getNewFileUri(Context context, Uri originalUri) {
        void var1_1;
        return AttachmentManager.getNewFileUri(context, (Uri)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean validateFileSize(Uri uri, File attachmentFile) {
        Uri uri2;
        if (SettingsManager.getInstance().getExtraAttachmentFiles() != null && SettingsManager.getInstance().getExtraAttachmentFiles().containsKey(uri2)) {
            double d2;
            void var1_2;
            double d3 = (double)var1_2.length() / 1048576.0;
            if (d2 > 50.0) {
                InstabugSDKLogger.w(TAG, "Attachment size is" + d3 + ", exceeds " + 50.0 + " MBs file size limit, ignoring attachment");
                return false;
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static void saveBitmap(Bitmap bitmap, Context context, a callback) {
        block5: {
            var1_2 = AttachmentManager.getAttachmentDirectory(context);
            var3_4 = v0;
            v0 = new File((File)var1_2, "bug_" + System.currentTimeMillis() + "_.jpg");
            InstabugSDKLogger.v("AttachmentManager", "image path: " + var3_4.toString());
            var1_2 = v1;
            var1_2(new FileOutputStream(var3_4));
            var0.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)var1_2);
            v1.close();
            var0 = Uri.fromFile((File)v0);
            if (var0 == null) ** GOTO lbl17
            try {
                var2_3.onSuccess((Uri)var0);
                break block5;
lbl17:
                // 1 sources

                var2_3.onError(new Throwable("Uri equal null"));
            }
            catch (IOException var0_1) {
                var2_3.onError(var0_1);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void saveBitmap(Bitmap bitmap, File attachmentDirectory, a callback) {
        block11: {
            block12: {
                block10: {
                    var3_4 = v0;
                    v0 = new File((File)var1_2, "frame_" + System.currentTimeMillis() + "_.jpg");
                    InstabugSDKLogger.v("AttachmentManager", "video frame path: " + var3_4.toString());
                    var1_2 = v1;
                    v1 = new BufferedOutputStream(new FileOutputStream(var3_4));
                    if (bitmap.getWidth() <= var0.getHeight()) break block10;
                    v2 = var0.getWidth();
lbl10:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
                }
                v2 = var0.getHeight();
                ** continue;
                var4_5 = v2;
                if (var4_5 <= 640) break block12;
                v3 = AttachmentManager.resizeBitmap(var0, 640).compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)var1_2);
lbl20:
                // 2 sources

                while (true) {
                    ** GOTO lbl26
                    break;
                }
            }
            v3 = AttachmentManager.resizeBitmap(var0, 320).compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)var1_2);
            ** continue;
lbl26:
            // 1 sources

            var1_2.close();
            var0 = Uri.fromFile((File)var3_4);
            if (var0 == null) ** GOTO lbl32
            try {
                var2_3.onSuccess((Uri)var0);
                break block11;
lbl32:
                // 1 sources

                var2_3.onError(new Throwable("Uri equal null"));
            }
            catch (IOException var0_1) {
                var2_3.onError(var0_1);
            }
        }
    }

    private static Bitmap resizeBitmap(Bitmap image, int maxSize) {
        Bitmap bitmap;
        int n2;
        int n3;
        float f2;
        Bitmap bitmap2 = image;
        int n4 = bitmap2.getWidth();
        float f3 = (float)n4 / (float)bitmap2.getHeight();
        if (f2 > 1.0f) {
            n2 = (int)((float)n3 / f3);
            void v2 = n3;
            n3 = n2;
            n2 = v2;
        } else {
            n2 = (int)((float)n3 * f3);
        }
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)n2, (int)n3, (boolean)false);
    }

    public static void deleteRecursive(File fileOrDirectory) {
        File file;
        if (fileOrDirectory.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray != null && fileArray.length > 0) {
                int n2 = fileArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    AttachmentManager.deleteRecursive(fileArray[i2]);
                }
            }
            file.delete();
        } else {
            file.delete();
        }
    }

    public static interface a {
        public void onSuccess(Uri var1);

        public void onError(Throwable var1);
    }
}

