/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.ui.custom;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.util.Property;
import android.util.TypedValue;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.instabug.library.ui.custom.MaterialMenu;

@RequiresApi(api=14)
public class MaterialMenuDrawable
extends Drawable
implements MaterialMenu,
Animatable {
    public static final int DEFAULT_COLOR = -1;
    public static final int DEFAULT_SCALE = 1;
    public static final int DEFAULT_TRANSFORM_DURATION = 800;
    public static final boolean DEFAULT_VISIBLE = true;
    private static final int BASE_DRAWABLE_WIDTH = 40;
    private static final int BASE_DRAWABLE_HEIGHT = 40;
    private static final int BASE_ICON_WIDTH = 20;
    private static final int BASE_CIRCLE_RADIUS = 18;
    private static final float ARROW_MID_LINE_ANGLE = 180.0f;
    private static final float ARROW_TOP_LINE_ANGLE = 135.0f;
    private static final float ARROW_BOT_LINE_ANGLE = 225.0f;
    private static final float X_TOP_LINE_ANGLE = 44.0f;
    private static final float X_BOT_LINE_ANGLE = -44.0f;
    private static final float X_ROTATION_ANGLE = 90.0f;
    private static final float CHECK_MIDDLE_ANGLE = 135.0f;
    private static final float CHECK_BOTTOM_ANGLE = -90.0f;
    private static final float TRANSFORMATION_START = 0.0f;
    private static final float TRANSFORMATION_MID = 1.0f;
    private static final float TRANSFORMATION_END = 2.0f;
    private static final int DEFAULT_CIRCLE_ALPHA = 200;
    private final float diph;
    private final float dip1;
    private final float dip2;
    private final float dip3;
    private final float dip4;
    private final float dip8;
    private final int width;
    private final int height;
    private final float strokeWidth;
    private final float iconWidth;
    private final float topPadding;
    private final float sidePadding;
    private final float circleRadius;
    private final Stroke stroke;
    private final Object lock;
    private final Paint iconPaint;
    private final Paint circlePaint;
    private float transformationValue;
    private boolean transformationRunning;
    private IconState currentIconState;
    private AnimationState animationState;
    @Nullable
    private IconState animatingIconState;
    private boolean visible;
    private boolean rtlEnabled;
    private ObjectAnimator transformation;
    @Nullable
    private Animator.AnimatorListener animatorListener;
    private MaterialMenuState materialMenuState;
    private Property<MaterialMenuDrawable, Float> transformationProperty;

    /*
     * WARNING - void declaration
     */
    public MaterialMenuDrawable(Context context, int color2, Stroke stroke) {
        this((Context)var1_1, (int)var2_2, (Stroke)var3_3, 1, 800);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public MaterialMenuDrawable(Context context, int color2, Stroke stroke, int transformDuration) {
        this((Context)var1_1, (int)var2_2, (Stroke)var3_3, 1, (int)var4_4);
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public MaterialMenuDrawable(Context context, int color2, Stroke stroke, int scale, int transformDuration) {
        void var5_6;
        void var2_3;
        void var3_4;
        void var4_5;
        Resources resources;
        MaterialMenuDrawable materialMenuDrawable = this;
        this.lock = new Object();
        this.iconPaint = new Paint();
        this.circlePaint = new Paint();
        this.transformationValue = 0.0f;
        this.transformationRunning = false;
        this.currentIconState = IconState.BURGER;
        this.animationState = AnimationState.BURGER_ARROW;
        this.transformationProperty = new Property<MaterialMenuDrawable, Float>(this, Float.class, "transformation"){
            final /* synthetic */ MaterialMenuDrawable this$0;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                super((Class)var2_2, (String)var3_3);
            }

            public Float get(MaterialMenuDrawable object) {
                return object.getTransformationValue();
            }

            /*
             * WARNING - void declaration
             */
            public void set(MaterialMenuDrawable object, Float value) {
                void var2_2;
                object.setTransformationValue((Float)var2_2);
            }
        };
        resources = resources.getResources();
        MaterialMenuDrawable materialMenuDrawable2 = this;
        float f2 = (float)var4_5;
        this.dip1 = MaterialMenuDrawable.dpToPx(resources, 1.0f) * f2;
        this.dip2 = MaterialMenuDrawable.dpToPx(resources, 2.0f) * f2;
        this.dip3 = MaterialMenuDrawable.dpToPx(resources, 3.0f) * f2;
        this.dip4 = MaterialMenuDrawable.dpToPx(resources, 4.0f) * f2;
        this.dip8 = MaterialMenuDrawable.dpToPx(resources, 8.0f) * f2;
        this.diph = this.dip1 / 2.0f;
        materialMenuDrawable2.stroke = var3_4;
        materialMenuDrawable2.visible = true;
        this.width = (int)(MaterialMenuDrawable.dpToPx(resources, 40.0f) * f2);
        this.height = (int)(MaterialMenuDrawable.dpToPx(resources, 40.0f) * f2);
        this.iconWidth = MaterialMenuDrawable.dpToPx(resources, 20.0f) * f2;
        this.circleRadius = MaterialMenuDrawable.dpToPx(resources, 18.0f) * f2;
        materialMenuDrawable.strokeWidth = MaterialMenuDrawable.dpToPx(resources, ((Stroke)var3_4).strokeWidth) * f2;
        materialMenuDrawable.sidePadding = ((float)materialMenuDrawable.width - this.iconWidth) / 2.0f;
        materialMenuDrawable.topPadding = ((float)materialMenuDrawable.height - this.dip3 * 5.0f) / 2.0f;
        this.initPaint((int)var2_3);
        this.initAnimations((int)var5_6);
        this.materialMenuState = new MaterialMenuState();
    }

    /*
     * WARNING - void declaration
     */
    private MaterialMenuDrawable(int color2, Stroke stroke, long transformDuration, int width, int height, float iconWidth, float circleRadius, float strokeWidth, float dip1) {
        void var3_4;
        void var1_1;
        void var9_9;
        void var8_8;
        void var7_7;
        void var6_6;
        void var5_5;
        void var2_3;
        void var10_10;
        this.lock = new Object();
        this.iconPaint = new Paint();
        this.circlePaint = new Paint();
        this.transformationValue = 0.0f;
        this.transformationRunning = false;
        this.currentIconState = IconState.BURGER;
        this.animationState = AnimationState.BURGER_ARROW;
        this.transformationProperty = new /* invalid duplicate definition of identical inner class */;
        this.dip1 = var10_10;
        this.dip2 = var10_10 * 2.0f;
        void var1_2 = var10_10 * 3.0f;
        this.dip3 = var1_2;
        this.dip4 = var10_10 * 4.0f;
        this.dip8 = var10_10 * 8.0f;
        this.diph = var10_10 / 2.0f;
        this.stroke = var2_3;
        this.width = var5_5;
        this.height = var6_6;
        this.iconWidth = var7_7;
        this.circleRadius = var8_8;
        this.strokeWidth = var9_9;
        this.sidePadding = ((float)var5_5 - var7_7) / 2.0f;
        this.topPadding = ((float)var6_6 - var1_2 * 5.0f) / 2.0f;
        this.initPaint((int)var1_1);
        this.initAnimations((int)var3_4);
        this.materialMenuState = new MaterialMenuState();
    }

    private void initPaint(int color2) {
        int n2;
        MaterialMenuDrawable materialMenuDrawable = this;
        materialMenuDrawable.iconPaint.setAntiAlias(true);
        materialMenuDrawable.iconPaint.setStyle(Paint.Style.STROKE);
        materialMenuDrawable.iconPaint.setStrokeWidth(this.strokeWidth);
        materialMenuDrawable.iconPaint.setColor(n2);
        materialMenuDrawable.circlePaint.setAntiAlias(true);
        materialMenuDrawable.circlePaint.setStyle(Paint.Style.FILL);
        materialMenuDrawable.circlePaint.setColor(n2);
        materialMenuDrawable.circlePaint.setAlpha(200);
        int n3 = materialMenuDrawable.width;
        n2 = materialMenuDrawable.height;
        materialMenuDrawable.setBounds(0, 0, n3, n2);
    }

    /*
     * WARNING - void declaration
     */
    private void drawMiddleLine(Canvas canvas, float ratio) {
        void var1_1;
        MaterialMenuDrawable materialMenuDrawable = this_;
        void v1 = var1_1;
        v1.restore();
        v1.save();
        float f2 = 0.0f;
        int n2 = materialMenuDrawable.width;
        float f3 = (float)n2 / 2.0f;
        float f4 = (float)n2 / 2.0f;
        float f5 = materialMenuDrawable.sidePadding;
        float f6 = materialMenuDrawable.topPadding;
        float f7 = f6;
        float f8 = this_.dip3;
        float f9 = f7 + f8 / 2.0f * 5.0f;
        f7 = (float)n2 - f5;
        f8 = f6 + f8 / 2.0f * 5.0f;
        int n3 = 255;
        switch (3.$SwitchMap$com$instabug$library$ui$custom$MaterialMenuDrawable$AnimationState[this_.animationState.ordinal()]) {
            default: {
                break;
            }
            case 6: {
                float f10;
                void v3 = f10;
                void v4 = f10;
                void v5 = f10;
                n3 = (int)(v5 * 255.0f);
                f2 = v5 * 135.0f;
                f10 = this_.dip3;
                f5 += v4 * (this_.dip4 + f10 / 2.0f);
                f7 += v3 * this_.dip1;
                f3 = (float)this_.width / 2.0f + f10 + this_.diph;
                break;
            }
            case 5: {
                float f10;
                void v6 = f10;
                void v7 = f10;
                f2 = f10 * 135.0f;
                f10 = this_.dip3;
                f5 += v7 * (this_.dip4 + f10 / 2.0f);
                f7 += v6 * this_.dip1;
                f3 = (float)this_.width / 2.0f + f10 + this_.diph;
                break;
            }
            case 4: {
                float f10;
                f2 = this_.isMorphingForward() ? f10 * 135.0f : 135.0f - (1.0f - f10) * 135.0f;
                f3 = this_.dip3;
                f5 += f3 / 2.0f + this_.dip4 - (1.0f - f10) * this_.dip2;
                f7 += f10 * this_.dip1;
                f3 = (float)this_.width / 2.0f + f3 + this_.diph;
                break;
            }
            case 3: {
                float f10;
                float f11 = 1.0f - f10;
                n3 = (int)(f11 * 255.0f);
                f5 += f11 * this_.dip2;
                break;
            }
            case 2: {
                float f10;
                n3 = (int)((1.0f - f10) * 255.0f);
                break;
            }
            case 1: {
                float f10;
                f2 = this_.isMorphingForward() ? f10 * 180.0f : (1.0f - f10) * 180.0f + 180.0f;
                f7 -= f10 * this_.resolveStrokeModifier(f10) / 2.0f;
            }
        }
        MaterialMenuDrawable materialMenuDrawable2 = this_;
        this_.iconPaint.setAlpha(n3);
        var1_1.rotate(f2, f3, f4);
        MaterialMenuDrawable this_ = this_.iconPaint;
        var1_1.drawLine(f5, f9, f7, f8, (Paint)this_);
        materialMenuDrawable2.iconPaint.setAlpha(255);
    }

    /*
     * WARNING - void declaration
     */
    private void drawTopLine(Canvas canvas, float ratio) {
        int n2;
        void var1_1;
        MaterialMenuDrawable materialMenuDrawable = this_;
        var1_1.save();
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        int n3 = materialMenuDrawable.width;
        float f6 = (float)n3 / 2.0f + this_.dip3 / 2.0f;
        float f7 = materialMenuDrawable.topPadding;
        float f8 = this_.dip2;
        float f9 = f7 + f8;
        float f10 = this_.sidePadding;
        float f11 = f7 + f8;
        float f12 = (float)n3 - f10;
        f8 = f7 + f8;
        int n4 = 255;
        switch (3.$SwitchMap$com$instabug$library$ui$custom$MaterialMenuDrawable$AnimationState[this_.animationState.ordinal()]) {
            default: {
                n2 = n4;
                break;
            }
            case 6: {
                float f13;
                MaterialMenuDrawable materialMenuDrawable2 = this_;
                f2 = 44.0f;
                f5 = 90.0f;
                f3 = materialMenuDrawable2.sidePadding + this_.dip4;
                f4 = this_.dip3;
                float f14 = materialMenuDrawable2.topPadding + f4;
                f13 = 1.0f - f13;
                float f15 = f4;
                f12 += f15 - f15 * f13;
                f10 += f4;
                n2 = (int)(f13 * 255.0f);
                f4 = f14;
                break;
            }
            case 5: {
                float f13;
                n2 = (int)((1.0f - f13) * 255.0f);
                break;
            }
            case 4: {
                float f13;
                MaterialMenuDrawable materialMenuDrawable3 = this_;
                n2 = (int)((1.0f - f13) * 255.0f);
                f2 = 225.0f;
                f3 = (float)materialMenuDrawable3.width / 2.0f;
                float f16 = (float)materialMenuDrawable3.height / 2.0f;
                f12 -= materialMenuDrawable3.resolveStrokeModifier(1.0f);
                f10 += this_.dip3;
                f4 = f16;
                break;
            }
            case 3: {
                float f13;
                void v5 = f13;
                MaterialMenuDrawable materialMenuDrawable4 = this_;
                void v7 = f13;
                f2 = v7 * -181.0f + 225.0f;
                f5 = v7 * 90.0f;
                int n5 = materialMenuDrawable4.width;
                f3 = (float)n5 / 2.0f + (this_.sidePadding + this_.dip4 - (float)n5 / 2.0f) * f13;
                int n6 = materialMenuDrawable4.height;
                f13 = (float)n6 / 2.0f + (this_.topPadding + this_.dip3 - (float)n6 / 2.0f) * f13;
                f12 -= this_.resolveStrokeModifier((float)v5);
                f10 += this_.dip3;
                f4 = f13;
                n2 = n4;
                break;
            }
            case 2: {
                float f13;
                float f17 = f10;
                MaterialMenuDrawable materialMenuDrawable5 = this_;
                void v10 = f13;
                f2 = v10 * 44.0f;
                f5 = v10 * 90.0f;
                f3 = materialMenuDrawable5.sidePadding + this_.dip4;
                f4 = materialMenuDrawable5.topPadding;
                f10 = materialMenuDrawable5.dip3;
                float f18 = f13;
                f13 = f4 + f10;
                f10 = f17 + f10 * f18;
                f4 = f13;
                n2 = n4;
                break;
            }
            case 1: {
                float f13;
                f2 = this_.isMorphingForward() ? f13 * 225.0f : (1.0f - f13) * 135.0f + 225.0f;
                MaterialMenuDrawable materialMenuDrawable6 = this_;
                f3 = (float)materialMenuDrawable6.width / 2.0f;
                f4 = (float)materialMenuDrawable6.height / 2.0f;
                f12 -= this_.resolveStrokeModifier(f13);
                f10 += this_.dip3 * f13;
                n2 = n4;
            }
        }
        MaterialMenuDrawable materialMenuDrawable7 = this_;
        this_.iconPaint.setAlpha(n2);
        var1_1.rotate(f2, f3, f4);
        var1_1.rotate(f5, f6, f9);
        MaterialMenuDrawable this_ = this_.iconPaint;
        var1_1.drawLine(f10, f11, f12, f8, (Paint)this_);
        materialMenuDrawable7.iconPaint.setAlpha(255);
    }

    /*
     * WARNING - void declaration
     */
    private void drawBottomLine(Canvas canvas, float ratio) {
        float f2;
        void var1_1;
        MaterialMenuDrawable materialMenuDrawable = this_;
        void v1 = var1_1;
        v1.restore();
        v1.save();
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        int n2 = materialMenuDrawable.width;
        float f7 = (float)n2 / 2.0f + this_.dip3 / 2.0f;
        int n3 = materialMenuDrawable.height;
        float f8 = this_.topPadding;
        float f9 = this_.dip2;
        float f10 = (float)n3 - f8 - f9;
        float f11 = materialMenuDrawable.sidePadding;
        float f12 = (float)n3 - f8 - f9;
        float f13 = (float)n2 - f11;
        f8 = (float)n3 - f8 - f9;
        switch (3.$SwitchMap$com$instabug$library$ui$custom$MaterialMenuDrawable$AnimationState[this_.animationState.ordinal()]) {
            default: {
                float f14 = f4;
                f2 = f6;
                f4 = f5;
                f5 = f14;
                break;
            }
            case 6: {
                float f15 = f13;
                MaterialMenuDrawable materialMenuDrawable2 = this_;
                f3 = 1.0f - f2;
                f6 = f3 * -90.0f;
                f4 = f2 * 89.0f + -44.0f;
                f5 = materialMenuDrawable2.sidePadding;
                f13 = this_.dip4;
                f9 = this_.dip3;
                f5 = f5 + f13 + ((float)this_.width / 2.0f + f9 - f5 - f13) * f2;
                int n4 = materialMenuDrawable2.height;
                float f16 = this_.topPadding;
                f2 = (float)n4 - f16 - f9 + (f16 + (float)n4 / 2.0f - (float)n4) * f2;
                f11 += materialMenuDrawable2.dip8 - (f13 + this_.dip1) * f3;
                f13 = f15 - this_.resolveStrokeModifier(f3);
                float f17 = f4;
                float f18 = f2;
                f2 = f6;
                f4 = f18;
                f3 = f17;
                break;
            }
            case 5: {
                MaterialMenuDrawable materialMenuDrawable3 = this_;
                f4 = f2 * 45.0f;
                f3 = this_.dip3;
                f5 = (float)materialMenuDrawable3.width / 2.0f + f3 * f2;
                f3 = (float)materialMenuDrawable3.height / 2.0f - f3 * f2;
                f11 += materialMenuDrawable3.dip8 * f2;
                f13 -= this_.resolveStrokeModifier(f2);
                float f19 = f4;
                f2 = f6;
                f4 = f3;
                f3 = f19;
                break;
            }
            case 4: {
                MaterialMenuDrawable materialMenuDrawable4 = this_;
                f4 = f2 * -90.0f + 135.0f;
                f3 = this_.dip3;
                f5 = (float)materialMenuDrawable4.width / 2.0f + f3 * f2;
                f3 = (float)materialMenuDrawable4.height / 2.0f - f3 * f2;
                f13 -= materialMenuDrawable4.resolveStrokeModifier(1.0f);
                f11 += this_.dip3 + (this_.dip4 + this_.dip1) * f2;
                float f20 = f4;
                f2 = f6;
                f4 = f3;
                f3 = f20;
                break;
            }
            case 3: {
                MaterialMenuDrawable materialMenuDrawable5 = this_;
                float f21 = f2;
                f4 = f21 * 181.0f + 135.0f;
                f6 = f21 * -90.0f;
                int n5 = materialMenuDrawable5.width;
                f5 = (float)n5 / 2.0f + (this_.sidePadding + this_.dip4 - (float)n5 / 2.0f) * f2;
                n5 = materialMenuDrawable5.height;
                f3 = (float)n5 / 2.0f + ((float)n5 / 2.0f - this_.topPadding - this_.dip3) * f2;
                f13 -= this_.resolveStrokeModifier(f2);
                f11 += this_.dip3;
                float f22 = f4;
                f2 = f6;
                f4 = f3;
                f3 = f22;
                break;
            }
            case 2: {
                f3 = this_.isMorphingForward() ? f2 * -90.0f : f2 * 90.0f;
                MaterialMenuDrawable materialMenuDrawable6 = this_;
                f4 = f2 * -44.0f;
                f5 = materialMenuDrawable6.sidePadding + this_.dip4;
                f6 = (float)materialMenuDrawable6.height - this_.topPadding;
                f9 = materialMenuDrawable6.dip3;
                float f23 = f2;
                f2 = f6 - f9;
                f11 += f9 * f23;
                float f24 = f4;
                float f25 = f2;
                f2 = f3;
                f4 = f25;
                f3 = f24;
                break;
            }
            case 1: {
                f3 = this_.isMorphingForward() ? f2 * 135.0f : (1.0f - f2) * 225.0f + 135.0f;
                MaterialMenuDrawable materialMenuDrawable7 = this_;
                int n6 = materialMenuDrawable7.width;
                f5 = (float)n6 / 2.0f;
                f4 = (float)this_.height / 2.0f;
                f13 = (float)n6 - this_.sidePadding - this_.resolveStrokeModifier(f2);
                f11 = materialMenuDrawable7.sidePadding + this_.dip3 * f2;
                f2 = f6;
            }
        }
        void v20 = var1_1;
        v20.rotate(f3, f5, f4);
        v20.rotate(f2, f7, f10);
        MaterialMenuDrawable this_ = this_.iconPaint;
        var1_1.drawLine(f11, f12, f13, f8, (Paint)this_);
    }

    private boolean isMorphingForward() {
        return this.transformationValue <= 1.0f;
    }

    /*
     * WARNING - void declaration
     */
    private float resolveStrokeModifier(float ratio) {
        void var1_2;
        int n2 = 3.$SwitchMap$com$instabug$library$ui$custom$MaterialMenuDrawable$Stroke[this.stroke.ordinal()];
        if (n2 != 1) {
            if (n2 != 2) {
                if (n2 != 3) {
                    return 0.0f;
                }
                AnimationState animationState = this.animationState;
                if (animationState != AnimationState.ARROW_X && animationState != AnimationState.X_CHECK) {
                    return (float)(var1_2 * this.dip4);
                }
                return this.dip4 - (this.dip3 + this.dip1) * var1_2;
            }
            AnimationState animationState = this.animationState;
            if (animationState != AnimationState.ARROW_X && animationState != AnimationState.X_CHECK) {
                return (float)(var1_2 * (this.dip3 + this.diph));
            }
            float f2 = this.dip3;
            float f3 = this.diph;
            return f2 + f3 - (f2 + f3) * var1_2;
        }
        AnimationState animationState = this.animationState;
        if (animationState != AnimationState.ARROW_X && animationState != AnimationState.X_CHECK) {
            return (float)(var1_2 * this.dip3);
        }
        float f4 = this.dip3;
        return f4 - f4 * var1_2;
    }

    /*
     * WARNING - void declaration
     */
    private void initAnimations(int transformDuration) {
        void var1_1;
        MaterialMenuDrawable materialMenuDrawable = this;
        this.transformation = ObjectAnimator.ofFloat((Object)materialMenuDrawable, materialMenuDrawable.transformationProperty, (float[])new float[]{0.0f});
        this.transformation.setInterpolator((TimeInterpolator)new DecelerateInterpolator(3.0f));
        materialMenuDrawable.transformation.setDuration((long)var1_1);
        materialMenuDrawable.transformation.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(this){
            final /* synthetic */ MaterialMenuDrawable this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            public void onAnimationEnd(Animator animation) {
                2 v0 = this;
                MaterialMenuDrawable.access$202(v0.this$0, false);
                MaterialMenuDrawable materialMenuDrawable = v0.this$0;
                materialMenuDrawable.setIconState(materialMenuDrawable.animatingIconState);
            }
        });
    }

    private boolean resolveTransformation() {
        boolean bl = this.currentIconState == IconState.BURGER;
        boolean bl2 = this.currentIconState == IconState.ARROW;
        boolean bl3 = this.currentIconState == IconState.X;
        boolean bl4 = this.currentIconState == IconState.CHECK;
        boolean bl5 = this.animatingIconState == IconState.BURGER;
        boolean bl6 = this.animatingIconState == IconState.ARROW;
        boolean bl7 = this.animatingIconState == IconState.X;
        boolean bl8 = this.animatingIconState == IconState.CHECK;
        if (bl && bl6 || bl2 && bl5) {
            this.animationState = AnimationState.BURGER_ARROW;
            return bl;
        }
        if (bl2 && bl7 || bl3 && bl6) {
            this.animationState = AnimationState.ARROW_X;
            return bl2;
        }
        if (bl && bl7 || bl3 && bl5) {
            this.animationState = AnimationState.BURGER_X;
            return bl;
        }
        if (bl2 && bl8 || bl4 && bl6) {
            this.animationState = AnimationState.ARROW_CHECK;
            return bl2;
        }
        if (bl && bl8 || bl4 && bl5) {
            this.animationState = AnimationState.BURGER_CHECK;
            return bl;
        }
        if (bl3 && bl8 || bl4 && bl7) {
            this.animationState = AnimationState.X_CHECK;
            return bl3;
        }
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.currentIconState;
        objectArray[1] = this.animatingIconState;
        throw new IllegalStateException(String.format("Animating from %s to %s is not supported", objectArray2));
    }

    /*
     * WARNING - void declaration
     */
    static float dpToPx(Resources resources, float dp) {
        void var1_1;
        Resources resources2 = resources.getDisplayMetrics();
        return TypedValue.applyDimension((int)1, (float)var1_1, (DisplayMetrics)resources2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$202(MaterialMenuDrawable x0, boolean x1) {
        void var1_1;
        var0.transformationRunning = var1_1;
        return x1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void draw(Canvas canvas) {
        v0 = this;
        var2_2 = v0.lock;
        synchronized (var2_2) {
            if (v0.visible) ** GOTO lbl10
            return;
lbl10:
            // 1 sources

            v2 = this.transformationValue;
            if (v2 <= 1.0f) {
                var3_3 = this.transformationValue;
            } else {
                var3_3 = 2.0f - this.transformationValue;
            }
            if (!this.rtlEnabled) ** GOTO lbl31
            v3 = var1_1;
            v4 = this;
            v5 = var1_1;
            v6 = v5;
            v5.save();
            v6.scale(-1.0f, 1.0f, 0.0f, 0.0f);
            v7 = -v4.getIntrinsicWidth();
            v3.translate(v7, 0.0f);
lbl31:
            // 2 sources

            v8 = this;
            this.drawTopLine((Canvas)var1_1, var3_3);
            this.drawMiddleLine((Canvas)var1_1, var3_3);
            v8.drawBottomLine((Canvas)var1_1, var3_3);
            if (!v8.rtlEnabled) ** GOTO lbl38
            var1_1.restore();
lbl38:
            // 2 sources

            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setAlpha(int alpha) {
        void var1_1;
        this.iconPaint.setAlpha((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public void setColorFilter(@Nullable ColorFilter cf) {
        void var1_1;
        this.iconPaint.setColorFilter((ColorFilter)var1_1);
    }

    public int getOpacity() {
        return -2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setColor(int color2) {
        void var1_1;
        MaterialMenuDrawable materialMenuDrawable = this;
        materialMenuDrawable.iconPaint.setColor((int)var1_1);
        materialMenuDrawable.circlePaint.setColor((int)var1_1);
        materialMenuDrawable.invalidateSelf();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @RequiresApi(api=11)
    public void setTransformationDuration(int duration) {
        void var1_1;
        this.transformation.setDuration((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setInterpolator(Interpolator interpolator) {
        void var1_1;
        this.transformation.setInterpolator((TimeInterpolator)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setAnimationListener(Animator.AnimatorListener listener) {
        void var1_1;
        Animator.AnimatorListener animatorListener = this.animatorListener;
        if (animatorListener != null) {
            this.transformation.removeListener(animatorListener);
        }
        if (var1_1 != null) {
            this.transformation.addListener((Animator.AnimatorListener)var1_1);
        }
        this.animatorListener = var1_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setIconState(@Nullable IconState iconState) {
        MaterialMenuDrawable materialMenuDrawable = this;
        Object object = materialMenuDrawable.lock;
        synchronized (object) {
            void var1_1;
            if (materialMenuDrawable.transformationRunning) {
                this.transformation.cancel();
                this.transformationRunning = false;
            }
            if (var1_1 != null && this.currentIconState != var1_1) {
                switch (3.$SwitchMap$com$instabug$library$ui$custom$MaterialMenuDrawable$IconState[var1_1.ordinal()]) {
                    default: {
                        break;
                    }
                    case 4: {
                        MaterialMenuDrawable materialMenuDrawable2 = this;
                        materialMenuDrawable2.animationState = AnimationState.BURGER_CHECK;
                        materialMenuDrawable2.transformationValue = 1.0f;
                        break;
                    }
                    case 3: {
                        MaterialMenuDrawable materialMenuDrawable3 = this;
                        materialMenuDrawable3.animationState = AnimationState.BURGER_X;
                        materialMenuDrawable3.transformationValue = 1.0f;
                        break;
                    }
                    case 2: {
                        MaterialMenuDrawable materialMenuDrawable4 = this;
                        materialMenuDrawable4.animationState = AnimationState.BURGER_ARROW;
                        materialMenuDrawable4.transformationValue = 1.0f;
                        break;
                    }
                    case 1: {
                        MaterialMenuDrawable materialMenuDrawable5 = this;
                        materialMenuDrawable5.animationState = AnimationState.BURGER_ARROW;
                        materialMenuDrawable5.transformationValue = 0.0f;
                    }
                }
                this.currentIconState = var1_1;
                this.invalidateSelf();
                return;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void animateIconState(IconState state) {
        MaterialMenuDrawable materialMenuDrawable = this;
        Object object = materialMenuDrawable.lock;
        synchronized (object) {
            void var1_1;
            if (materialMenuDrawable.transformationRunning) {
                this.transformation.end();
            }
            this.animatingIconState = var1_1;
            this.start();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IconState setTransformationOffset(AnimationState animationState, float offset) {
        void var2_2;
        void cfr_temp_0;
        int n2;
        if (!(offset < 0.0f) && (n2 = (cfr_temp_0 = var2_2 - 2.0f) == 0 ? 0 : (cfr_temp_0 > 0 ? 1 : -1)) <= 0) {
            Object object = objectArray2.lock;
            synchronized (object) {
                IconState iconState;
                objectArray2.animationState = iconState;
                n2 = var2_2 < 1.0f || !n2;
                IconState iconState2 = n2 != 0 ? ((AnimationState)((Object)iconState)).getFirstState() : ((AnimationState)((Object)iconState)).getSecondState();
                objectArray2.currentIconState = iconState2;
                iconState = n2 != 0 ? ((AnimationState)((Object)iconState)).getSecondState() : ((AnimationState)((Object)iconState)).getFirstState();
                objectArray2.animatingIconState = iconState;
                objectArray2.setTransformationValue(Float.valueOf((float)var2_2));
                return objectArray2.currentIconState;
            }
        }
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = Float.valueOf(0.0f);
        objectArray[1] = Float.valueOf(2.0f);
        throw new IllegalArgumentException(String.format("Value must be between %s and %s", objectArray2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setVisible(boolean visible) {
        void var1_1;
        this.visible = var1_1;
        this.invalidateSelf();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setRTLEnabled(boolean rtlEnabled) {
        void var1_1;
        this.rtlEnabled = var1_1;
        this.invalidateSelf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IconState getIconState() {
        MaterialMenuDrawable materialMenuDrawable = this_;
        Object this_ = materialMenuDrawable.lock;
        synchronized (this_) {
            return materialMenuDrawable.currentIconState;
        }
    }

    public boolean isDrawableVisible() {
        return this.visible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Float getTransformationValue() {
        MaterialMenuDrawable materialMenuDrawable = this_;
        Object this_ = materialMenuDrawable.lock;
        synchronized (this_) {
            return Float.valueOf(materialMenuDrawable.transformationValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setTransformationValue(Float value) {
        Object object = this.lock;
        synchronized (object) {
            void var1_1;
            this.transformationValue = var1_1.floatValue();
            this.invalidateSelf();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        MaterialMenuDrawable materialMenuDrawable = this;
        Object object = materialMenuDrawable.lock;
        synchronized (object) {
            if (materialMenuDrawable.transformationRunning) {
                return;
            }
            if (this.animatingIconState != null && this.animatingIconState != this.currentIconState) {
                this.transformationRunning = true;
                boolean bl = this.resolveTransformation();
                ObjectAnimator objectAnimator = this.transformation;
                float[] fArray = new float[2];
                int n2 = 0;
                float f2 = bl ? 0.0f : 1.0f;
                fArray[n2] = f2;
                int n3 = 1;
                float f3 = bl ? 1.0f : 2.0f;
                fArray[n3] = f3;
                objectAnimator.setFloatValues(fArray);
                this.transformation.start();
            }
            this.invalidateSelf();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() {
        MaterialMenuDrawable materialMenuDrawable = this;
        Object object = materialMenuDrawable.lock;
        synchronized (object) {
            if (materialMenuDrawable.isRunning() && this.transformation.isRunning()) {
                this.transformation.end();
            } else {
                this.transformationRunning = false;
                this.invalidateSelf();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        MaterialMenuDrawable materialMenuDrawable = this_;
        Object this_ = materialMenuDrawable.lock;
        synchronized (this_) {
            return materialMenuDrawable.transformationRunning;
        }
    }

    public int getIntrinsicWidth() {
        return this.width;
    }

    public int getIntrinsicHeight() {
        return this.height;
    }

    public Drawable.ConstantState getConstantState() {
        MaterialMenuDrawable materialMenuDrawable = this;
        MaterialMenuState.access$402(materialMenuDrawable.materialMenuState, this.getChangingConfigurations());
        return materialMenuDrawable.materialMenuState;
    }

    public Drawable mutate() {
        MaterialMenuState materialMenuState;
        MaterialMenuState materialMenuState2 = materialMenuState;
        materialMenuState = new MaterialMenuState();
        this.materialMenuState = materialMenuState2;
        return this;
    }

    private final class MaterialMenuState
    extends Drawable.ConstantState {
        private int changingConfigurations;

        private MaterialMenuState() {
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ int access$402(MaterialMenuState x0, int x1) {
            void var1_1;
            var0.changingConfigurations = var1_1;
            return x1;
        }

        public Drawable newDrawable() {
            MaterialMenuDrawable materialMenuDrawable;
            MaterialMenuDrawable materialMenuDrawable2 = materialMenuDrawable;
            MaterialMenuState materialMenuState = this;
            Enum enum_ = materialMenuState.MaterialMenuDrawable.this.stroke;
            long l2 = materialMenuState.MaterialMenuDrawable.this.transformation.getDuration();
            int n2 = materialMenuState.MaterialMenuDrawable.this.width;
            int n3 = materialMenuState.MaterialMenuDrawable.this.height;
            float f2 = materialMenuState.MaterialMenuDrawable.this.iconWidth;
            float f3 = materialMenuState.MaterialMenuDrawable.this.circleRadius;
            float f4 = materialMenuState.MaterialMenuDrawable.this.strokeWidth;
            float f5 = materialMenuState.MaterialMenuDrawable.this.dip1;
            materialMenuDrawable = new MaterialMenuDrawable(MaterialMenuDrawable.this.circlePaint.getColor(), (Stroke)enum_, l2, n2, n3, f2, f3, f4, f5);
            enum_ = MaterialMenuDrawable.this.animatingIconState != null ? MaterialMenuDrawable.this.animatingIconState : MaterialMenuDrawable.this.currentIconState;
            MaterialMenuDrawable materialMenuDrawable3 = materialMenuDrawable2;
            materialMenuDrawable2.setIconState((IconState)enum_);
            materialMenuDrawable2.setVisible(MaterialMenuDrawable.this.visible);
            materialMenuDrawable3.setRTLEnabled(MaterialMenuDrawable.this.rtlEnabled);
            return materialMenuDrawable3;
        }

        public int getChangingConfigurations() {
            return this.changingConfigurations;
        }
    }

    public static final class Stroke
    extends Enum<Stroke> {
        public static final /* enum */ Stroke REGULAR;
        public static final /* enum */ Stroke THIN;
        public static final /* enum */ Stroke EXTRA_THIN;
        private static final /* synthetic */ Stroke[] $VALUES;
        private final int strokeWidth;

        public static Stroke[] values() {
            return (Stroke[])$VALUES.clone();
        }

        public static Stroke valueOf(String name) {
            String string2;
            return Enum.valueOf(Stroke.class, string2);
        }

        /*
         * WARNING - void declaration
         */
        private Stroke(int strokeWidth) {
            void var3_3;
            this.strokeWidth = var3_3;
        }

        protected static Stroke valueOf(int strokeWidth) {
            if (strokeWidth != 1) {
                int n2;
                if (n2 != 2) {
                    if (n2 != 3) {
                        return THIN;
                    }
                    return REGULAR;
                }
                return THIN;
            }
            return EXTRA_THIN;
        }

        static {
            Stroke stroke;
            REGULAR = new Stroke(3);
            THIN = new Stroke(2);
            Stroke stroke2 = stroke;
            EXTRA_THIN = new Stroke(1);
            $VALUES = new Stroke[]{REGULAR, THIN, stroke2};
        }
    }

    public static final class AnimationState
    extends Enum<AnimationState> {
        public static final /* enum */ AnimationState BURGER_ARROW;
        public static final /* enum */ AnimationState BURGER_X;
        public static final /* enum */ AnimationState ARROW_X;
        public static final /* enum */ AnimationState ARROW_CHECK;
        public static final /* enum */ AnimationState BURGER_CHECK;
        public static final /* enum */ AnimationState X_CHECK;
        private static final /* synthetic */ AnimationState[] $VALUES;

        public static AnimationState[] values() {
            return (AnimationState[])$VALUES.clone();
        }

        public static AnimationState valueOf(String name) {
            String string2;
            return Enum.valueOf(AnimationState.class, string2);
        }

        static {
            AnimationState animationState;
            BURGER_ARROW = new AnimationState();
            BURGER_X = new AnimationState();
            ARROW_X = new AnimationState();
            ARROW_CHECK = new AnimationState();
            BURGER_CHECK = new AnimationState();
            AnimationState animationState2 = animationState;
            X_CHECK = new AnimationState();
            $VALUES = new AnimationState[]{BURGER_ARROW, BURGER_X, ARROW_X, ARROW_CHECK, BURGER_CHECK, animationState2};
        }

        @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
        public IconState getFirstState() {
            switch (3.$SwitchMap$com$instabug$library$ui$custom$MaterialMenuDrawable$AnimationState[this.ordinal()]) {
                default: {
                    return null;
                }
                case 6: {
                    return IconState.X;
                }
                case 5: {
                    return IconState.BURGER;
                }
                case 4: {
                    return IconState.ARROW;
                }
                case 3: {
                    return IconState.ARROW;
                }
                case 2: {
                    return IconState.BURGER;
                }
                case 1: 
            }
            return IconState.BURGER;
        }

        @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
        public IconState getSecondState() {
            switch (3.$SwitchMap$com$instabug$library$ui$custom$MaterialMenuDrawable$AnimationState[this.ordinal()]) {
                default: {
                    return null;
                }
                case 6: {
                    return IconState.CHECK;
                }
                case 5: {
                    return IconState.CHECK;
                }
                case 4: {
                    return IconState.CHECK;
                }
                case 3: {
                    return IconState.X;
                }
                case 2: {
                    return IconState.X;
                }
                case 1: 
            }
            return IconState.ARROW;
        }
    }

    public static final class IconState
    extends Enum<IconState> {
        public static final /* enum */ IconState BURGER;
        public static final /* enum */ IconState ARROW;
        public static final /* enum */ IconState X;
        public static final /* enum */ IconState CHECK;
        private static final /* synthetic */ IconState[] $VALUES;

        public static IconState[] values() {
            return (IconState[])$VALUES.clone();
        }

        public static IconState valueOf(String name) {
            String string2;
            return Enum.valueOf(IconState.class, string2);
        }

        static {
            IconState iconState;
            BURGER = new IconState();
            ARROW = new IconState();
            X = new IconState();
            IconState iconState2 = iconState;
            CHECK = new IconState();
            $VALUES = new IconState[]{BURGER, ARROW, X, iconState2};
        }
    }
}

