/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.model;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.Uri;
import android.os.Process;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.library.Feature;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.d;
import com.instabug.library.internal.storage.cache.Cacheable;
import com.instabug.library.internal.storage.cache.db.userAttribute.UserAttributesDbHelper;
import com.instabug.library.logging.InstabugLog;
import com.instabug.library.logging.InstabugUserEventLogger;
import com.instabug.library.model.a;
import com.instabug.library.model.j;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.e;
import com.instabug.library.user.UserEvent;
import com.instabug.library.user.b;
import com.instabug.library.util.DeviceStateProvider;
import com.instabug.library.util.InstabugDateFormatter;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.memory.MemoryGuard;
import com.instabug.library.util.memory.MemoryUtils;
import com.instabug.library.visualusersteps.VisualUserStep;
import com.instabug.library.visualusersteps.h;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class State
implements Cacheable,
Serializable {
    public static final String KEY_APP_PACKAGE_NAME = "bundle_id";
    public static final String KEY_APP_VERSION = "app_version";
    private static final String KEY_BATTERY_LEVEL = "battery_level";
    private static final String KEY_BATTERY_STATUS = "battery_state";
    public static final String KEY_CARRIER = "carrier";
    public static final String KEY_CONSOLE_LOG = "console_log";
    public static final String KEY_CURRENT_VIEW = "current_view";
    public static final String KEY_DENSITY = "density";
    public static final String KEY_DEVICE = "device";
    public static final String KEY_DEVICE_ROOTED = "device_rooted";
    public static final String KEY_DURATION = "duration";
    public static final String KEY_EMAIL = "email";
    public static final String KEY_NAME = "name";
    public static final String KEY_PUSH_TOKEN = "push_token";
    public static final String KEY_INSTABUG_LOG = "instabug_log";
    public static final String KEY_LOCALE = "locale";
    private static final String KEY_MEMORY_FREE = "memory_free";
    private static final String KEY_MEMORY_TOTAL = "memory_total";
    private static final String KEY_MEMORY_USED = "memory_used";
    public static final String KEY_ORIENTATION = "orientation";
    public static final String KEY_OS = "os";
    public static final String KEY_REPORTED_AT = "reported_at";
    public static final String KEY_SCREEN_SIZE = "screen_size";
    public static final String KEY_SDK_VERSION = "sdk_version";
    public static final String KEY_STORAGE_FREE = "storage_free";
    public static final String KEY_STORAGE_TOTAL = "storage_total";
    public static final String KEY_STORAGE_USED = "storage_used";
    public static final String KEY_TAGS = "tags";
    public static final String KEY_USER_DATA = "user_data";
    public static final String KEY_USER_STEPS = "user_steps";
    public static final String KEY_WIFI_SSID = "wifi_ssid";
    public static final String KEY_WIFI_STATE = "wifi_state";
    public static final String KEY_USER_ATTRIBUTES = "user_attributes";
    public static final String KEY_NETWORK_LOGS = "network_log";
    public static final String KEY_USER_EVENTS = "user_events";
    public static final String KEY_VISUAL_USER_STEPS = "user_repro_steps";
    public static final String KEY_SESSIONS_PROFILER = "sessions_profiler";
    private static final String KEY_APP_STATUS = "app_status";
    @VisibleForTesting
    static final String VALUE_APP_STATUS_FOREGROUND = "foreground";
    @VisibleForTesting
    static final String VALUE_APP_STATUS_BACKGROUND = "background";
    private static final String TAG = "State";
    private long duration;
    private boolean isDeviceRooted;
    private int batteryLevel;
    private boolean wifiState;
    private long usedMemory;
    private long freeMemory;
    private long totalMemory;
    private long usedStorage;
    public long freeStorage;
    private long totalStorage;
    @Nullable
    private String sdkVersion;
    @Nullable
    private String locale;
    @Nullable
    private String device;
    @Nullable
    private String OS;
    @Nullable
    private String carrier;
    @Nullable
    private String appPackageName;
    @Nullable
    private String appVersion;
    @Nullable
    private String batteryState;
    @Nullable
    private String wifiSSID;
    @Nullable
    private String screenDensity;
    @Nullable
    private String screenSize;
    @Nullable
    private String ScreenOrientation;
    @Nullable
    private String currentView;
    @Nullable
    private String instabugLog;
    @Nullable
    private ArrayList<a> consoleLog;
    @Nullable
    private ArrayList<j> userSteps;
    @Nullable
    private ArrayList<VisualUserStep> visualUserSteps;
    @Nullable
    private com.instabug.library.n.b.a.e sessionProfilerTimeline;
    @Nullable
    private String userEmail;
    @Nullable
    private String userName;
    @Nullable
    private String pushToken;
    @Nullable
    private String userData;
    private long reportedAt;
    @Nullable
    private String tags;
    @Nullable
    private String networkLogs;
    @Nullable
    private String userAttributes;
    @Nullable
    private String userEvents;
    @Nullable
    private Uri uri;
    @Nullable
    private String appStatus;
    @Nullable
    private String customUserAttribute;

    public static State getState(Context context) {
        Context context2;
        return new Builder(context2).build(true);
    }

    /*
     * WARNING - void declaration
     */
    private State setSdkVersion(String sdkVersion) {
        void var1_1;
        this.sdkVersion = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private State setIsDeviceRooted(boolean isDeviceRooted) {
        void var1_1;
        this.isDeviceRooted = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private State setWifiState(boolean wifiState) {
        void var1_1;
        this.wifiState = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private State setWifiSSID(String wifiSSID) {
        void var1_1;
        this.wifiSSID = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private State setUsedMemory(long usedMemory) {
        void var1_1;
        this.usedMemory = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private State setUsedStorage(long usedStorage) {
        void var1_1;
        this.usedStorage = var1_1;
        return this;
    }

    private long getFreeStorage() {
        return this.freeStorage;
    }

    /*
     * WARNING - void declaration
     */
    private State setFreeStorage(long freeStorage) {
        void var1_1;
        this.freeStorage = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private State setTotalStorage(long totalStorage) {
        void var1_1;
        this.totalStorage = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private State setAppStatus(String appStatus) {
        void var1_1;
        this.appStatus = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private State setConsoleLog(ArrayList<a> consoleLogs) {
        void var1_1;
        this.consoleLog = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private State setUserSteps(ArrayList<j> userSteps) {
        void var1_1;
        this.userSteps = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private State setReportedAt(long reportedAt) {
        void var1_1;
        this.reportedAt = var1_1;
        return this;
    }

    private static String getTagsAsString(List<String> tags) {
        List<String> list;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        if (tags != null && list.size() > 0) {
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuilder2.append(list.get(i2));
                if (i2 == n2 - 1) continue;
                stringBuilder2.append(", ");
            }
        }
        return stringBuilder2.toString();
    }

    /*
     * WARNING - void declaration
     */
    private State setNetworkLogs(String networkLogs) {
        void var1_1;
        this.networkLogs = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private void setVisualUserSteps(@Nullable ArrayList<VisualUserStep> visualUserSteps) {
        void var1_1;
        this.visualUserSteps = var1_1;
    }

    @Nullable
    private String getSessionProfilerTimeline() {
        Serializable this_ = ((State)this_).sessionProfilerTimeline;
        return this_ == null ? null : ((com.instabug.library.n.b.a.e)this_).b().toString();
    }

    /*
     * WARNING - void declaration
     */
    private State setSessionProfilerTimeline(com.instabug.library.n.b.a.e sessionProfilerTimeline) {
        void var1_1;
        this.sessionProfilerTimeline = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ State access$300(State x0, String x1) {
        void var1_1;
        return x0.setSdkVersion((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ State access$400(State x0, boolean x1) {
        void var1_1;
        return x0.setIsDeviceRooted((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ State access$500(State x0, String x1) {
        void var1_1;
        return x0.setAppStatus((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ State access$600(State x0, boolean x1) {
        void var1_1;
        return x0.setWifiState((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ State access$700(State x0, String x1) {
        void var1_1;
        return x0.setWifiSSID((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ State access$800(State x0, long x1) {
        void var1_1;
        return x0.setUsedMemory((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ State access$900(State x0, long x1) {
        void var1_1;
        return x0.setFreeStorage((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ State access$1000(State x0, long x1) {
        void var1_1;
        return x0.setUsedStorage((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ State access$1100(State x0, long x1) {
        void var1_1;
        return x0.setTotalStorage((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ State access$1200(State x0, ArrayList x1) {
        void var1_1;
        return x0.setConsoleLog((ArrayList<a>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ State access$1300(State x0, ArrayList x1) {
        void var1_1;
        return x0.setUserSteps((ArrayList<j>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ State access$1400(State x0, long x1) {
        void var1_1;
        return x0.setReportedAt((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ State access$1500(State x0, String x1) {
        void var1_1;
        return x0.setNetworkLogs((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ State access$1600(State x0, com.instabug.library.n.b.a.e x1) {
        void var1_1;
        return x0.setSessionProfilerTimeline((com.instabug.library.n.b.a.e)var1_1);
    }

    @Nullable
    public String getCustomUserAttribute() {
        return this.customUserAttribute;
    }

    /*
     * WARNING - void declaration
     */
    public void setCustomUserAttribute(@Nullable String customUserAttribute) {
        void var1_1;
        this.customUserAttribute = var1_1;
    }

    @Nullable
    public String getSdkVersion() {
        return this.sdkVersion;
    }

    @Nullable
    public String getLocale() {
        return this.locale;
    }

    /*
     * WARNING - void declaration
     */
    public State setLocale(String locale) {
        void var1_1;
        this.locale = var1_1;
        return this;
    }

    public long getDuration() {
        return this.duration;
    }

    /*
     * WARNING - void declaration
     */
    public State setDuration(long duration) {
        void var1_1;
        this.duration = var1_1;
        return this;
    }

    @Nullable
    public String getDevice() {
        return this.device;
    }

    /*
     * WARNING - void declaration
     */
    public State setDevice(String device) {
        void var1_1;
        this.device = var1_1;
        return this;
    }

    public boolean isDeviceRooted() {
        return this.isDeviceRooted;
    }

    @Nullable
    public String getOS() {
        return this.OS;
    }

    /*
     * WARNING - void declaration
     */
    public State setOS(String OS) {
        void var1_1;
        this.OS = var1_1;
        return this;
    }

    @Nullable
    public String getCarrier() {
        return this.carrier;
    }

    /*
     * WARNING - void declaration
     */
    public State setCarrier(String carrier) {
        void var1_1;
        this.carrier = var1_1;
        return this;
    }

    @Nullable
    public String getAppPackageName() {
        return this.appPackageName;
    }

    /*
     * WARNING - void declaration
     */
    public State setAppPackageName(String appPackageName) {
        void var1_1;
        this.appPackageName = var1_1;
        return this;
    }

    @Nullable
    public String getAppVersion() {
        return this.appVersion;
    }

    /*
     * WARNING - void declaration
     */
    public State setAppVersion(String appVersion) {
        void var1_1;
        this.appVersion = var1_1;
        return this;
    }

    public int getBatteryLevel() {
        return this.batteryLevel;
    }

    @Nullable
    public Uri getUri() {
        return this.uri;
    }

    /*
     * WARNING - void declaration
     */
    public void setUri(@Nullable Uri uri) {
        void var1_1;
        this.uri = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public State setBatteryLevel(int batteryLevel) {
        void var1_1;
        this.batteryLevel = var1_1;
        return this;
    }

    @Nullable
    public String getBatteryState() {
        return this.batteryState;
    }

    /*
     * WARNING - void declaration
     */
    public State setBatteryState(String batteryState) {
        void var1_1;
        this.batteryState = var1_1;
        return this;
    }

    public boolean isWifiEnable() {
        return this.wifiState;
    }

    @Nullable
    public String getWifiSSID() {
        return this.wifiSSID;
    }

    public long getUsedMemory() {
        return this.usedMemory;
    }

    public long getFreeMemory() {
        return this.freeMemory;
    }

    /*
     * WARNING - void declaration
     */
    public State setFreeMemory(long freeMemory) {
        void var1_1;
        this.freeMemory = var1_1;
        return this;
    }

    public long getTotalMemory() {
        return this.totalMemory;
    }

    /*
     * WARNING - void declaration
     */
    public State setTotalMemory(long totalMemory) {
        void var1_1;
        this.totalMemory = var1_1;
        return this;
    }

    public long getUsedStorage() {
        return this.usedStorage;
    }

    public long getTotalStorage() {
        return this.totalStorage;
    }

    @Nullable
    public String getScreenDensity() {
        return this.screenDensity;
    }

    /*
     * WARNING - void declaration
     */
    public State setScreenDensity(String screenDensity) {
        void var1_1;
        this.screenDensity = var1_1;
        return this;
    }

    @Nullable
    public String getScreenSize() {
        return this.screenSize;
    }

    /*
     * WARNING - void declaration
     */
    public State setScreenSize(String screenSize) {
        void var1_1;
        this.screenSize = var1_1;
        return this;
    }

    @Nullable
    public String getScreenOrientation() {
        return this.ScreenOrientation;
    }

    /*
     * WARNING - void declaration
     */
    public State setScreenOrientation(String screenOrientation) {
        void var1_1;
        this.ScreenOrientation = var1_1;
        return this;
    }

    @Nullable
    public String getCurrentView() {
        return this.currentView;
    }

    /*
     * WARNING - void declaration
     */
    public State setCurrentView(String currentView) {
        void var1_1;
        this.currentView = var1_1;
        return this;
    }

    @Nullable
    String getAppStatus() {
        return this.appStatus;
    }

    @Nullable
    public String getInstabugLog() {
        return this.instabugLog;
    }

    /*
     * WARNING - void declaration
     */
    public void setInstabugLog(@Nullable String instabugLog) {
        void var1_1;
        this.instabugLog = var1_1;
    }

    public void updateConsoleLog() {
        this.setConsoleLog(Builder.getConsoleLog());
    }

    /*
     * WARNING - void declaration
     */
    public void updateConsoleLog(ArrayList<a> logs) {
        void var1_1;
        this.setConsoleLog(Builder.getConsoleLog((ArrayList)var1_1));
    }

    public JSONArray getConsoleLog() {
        return a.a(this.consoleLog);
    }

    public JSONArray getUserSteps() {
        return j.a(this.userSteps);
    }

    @Nullable
    public String getUserEmail() {
        return this.userEmail;
    }

    /*
     * WARNING - void declaration
     */
    public State setUserEmail(String userEmail) {
        void var1_1;
        this.userEmail = var1_1;
        return this;
    }

    @Nullable
    public String getUserName() {
        return this.userName;
    }

    /*
     * WARNING - void declaration
     */
    public State setUserName(@Nullable String userName) {
        void var1_1;
        this.userName = var1_1;
        return this;
    }

    @Nullable
    public String getPushToken() {
        return this.pushToken;
    }

    /*
     * WARNING - void declaration
     */
    public State setPushToken(@Nullable String pushToken) {
        void var1_1;
        this.pushToken = var1_1;
        return this;
    }

    @Nullable
    public String getUserData() {
        return this.userData;
    }

    /*
     * WARNING - void declaration
     */
    public State setUserData(String userData) {
        void var1_1;
        this.userData = var1_1;
        return this;
    }

    public long getReportedAt() {
        return this.reportedAt;
    }

    @Nullable
    public String getTags() {
        return this.tags;
    }

    /*
     * WARNING - void declaration
     */
    public State setTags(String tags) {
        void var1_1;
        this.tags = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public State setTags(List<String> tags) {
        void var1_1;
        this.tags = State.getTagsAsString((List<String>)var1_1);
        return this;
    }

    @Nullable
    public String getUserAttributes() {
        return this.userAttributes;
    }

    /*
     * WARNING - void declaration
     */
    public State setUserAttributes(String userAttributes) {
        void var1_1;
        this.userAttributes = var1_1;
        return this;
    }

    @Nullable
    public String getNetworkLogs() {
        return this.networkLogs;
    }

    @Nullable
    public String getUserEvents() {
        return this.userEvents;
    }

    /*
     * WARNING - void declaration
     */
    public State setUserEvents(String userEvents) {
        void var1_1;
        this.userEvents = var1_1;
        return this;
    }

    public String getVisualUserSteps() {
        return VisualUserStep.toJsonString(this.visualUserSteps);
    }

    public ArrayList<StateItem> getStateItems() {
        ArrayList<StateItem> arrayList = new ArrayList<StateItem>();
        arrayList.add(new StateItem().setKey(KEY_APP_PACKAGE_NAME).setValue(this.getAppPackageName()));
        arrayList.add(new StateItem().setKey(KEY_APP_VERSION).setValue(this.getAppVersion()));
        arrayList.add(new StateItem().setKey(KEY_BATTERY_LEVEL).setValue(this.getBatteryLevel()));
        arrayList.add(new StateItem().setKey(KEY_BATTERY_STATUS).setValue(this.getBatteryState()));
        arrayList.add(new StateItem().setKey(KEY_CARRIER).setValue(this.getCarrier()));
        arrayList.add(new StateItem().setKey(KEY_CURRENT_VIEW).setValue(this.getCurrentView()));
        arrayList.add(new StateItem().setKey(KEY_DENSITY).setValue(this.getScreenDensity()));
        arrayList.add(new StateItem().setKey(KEY_DEVICE).setValue(this.getDevice()));
        arrayList.add(new StateItem().setKey(KEY_DEVICE_ROOTED).setValue(this.isDeviceRooted()));
        arrayList.add(new StateItem().setKey(KEY_DURATION).setValue(this.getDuration()));
        arrayList.add(new StateItem().setKey(KEY_EMAIL).setValue(this.getUserEmail()));
        arrayList.add(new StateItem().setKey(KEY_NAME).setValue(this.getUserName()));
        arrayList.add(new StateItem().setKey(KEY_PUSH_TOKEN).setValue(this.getPushToken()));
        arrayList.add(new StateItem().setKey(KEY_LOCALE).setValue(this.getLocale()));
        arrayList.add(new StateItem().setKey(KEY_MEMORY_FREE).setValue(this.getFreeMemory()));
        arrayList.add(new StateItem().setKey(KEY_MEMORY_TOTAL).setValue(this.getTotalMemory()));
        arrayList.add(new StateItem().setKey(KEY_MEMORY_USED).setValue(this.getUsedMemory()));
        arrayList.add(new StateItem().setKey(KEY_ORIENTATION).setValue(this.getScreenOrientation()));
        arrayList.add(new StateItem().setKey(KEY_OS).setValue(this.getOS()));
        arrayList.add(new StateItem().setKey(KEY_REPORTED_AT).setValue(this.getReportedAt()));
        arrayList.add(new StateItem().setKey(KEY_SCREEN_SIZE).setValue(this.getScreenSize()));
        arrayList.add(new StateItem().setKey(KEY_SDK_VERSION).setValue(this.getSdkVersion()));
        arrayList.add(new StateItem().setKey(KEY_STORAGE_FREE).setValue(this.getFreeStorage()));
        arrayList.add(new StateItem().setKey(KEY_STORAGE_TOTAL).setValue(this.getTotalStorage()));
        arrayList.add(new StateItem().setKey(KEY_STORAGE_USED).setValue(this.getUsedStorage()));
        arrayList.add(new StateItem().setKey(KEY_TAGS).setValue(this.getTags()));
        arrayList.add(new StateItem().setKey(KEY_WIFI_SSID).setValue(this.getWifiSSID()));
        arrayList.add(new StateItem().setKey(KEY_WIFI_STATE).setValue(this.isWifiEnable()));
        arrayList.add(new StateItem().setKey(KEY_USER_ATTRIBUTES).setValue(this.getUserAttributes()));
        arrayList.add(new StateItem().setKey(KEY_APP_STATUS).setValue(this.getAppStatus()));
        return arrayList;
    }

    @Override
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public String toJson() throws JSONException {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        jSONObject = new JSONObject();
        ArrayList<StateItem> arrayList = ((State)this_).getStateItems();
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            String string = arrayList.get(i2).getKey();
            jSONObject2.put(string, arrayList.get(i2).getValue());
        }
        Serializable this_ = ((State)this_).getLogsItems();
        for (int i3 = 0; i3 < ((ArrayList)this_).size(); ++i3) {
            String string = ((StateItem)((ArrayList)this_).get(i3)).getKey();
            jSONObject2.put(string, ((StateItem)((ArrayList)this_).get(i3)).getValue());
        }
        return jSONObject2.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fromJson(String stateAsJson) throws JSONException {
        void var1_1;
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        if (new JSONObject((String)var1_1).has(KEY_APP_PACKAGE_NAME)) {
            this.setAppPackageName(jSONObject2.getString(KEY_APP_PACKAGE_NAME));
        }
        if (jSONObject2.has(KEY_APP_VERSION)) {
            this.setAppVersion(jSONObject2.getString(KEY_APP_VERSION));
        }
        if (jSONObject2.has(KEY_BATTERY_LEVEL)) {
            this.setBatteryLevel(jSONObject2.getInt(KEY_BATTERY_LEVEL));
        }
        if (jSONObject2.has(KEY_BATTERY_STATUS)) {
            this.setBatteryState(jSONObject2.getString(KEY_BATTERY_STATUS));
        }
        if (jSONObject2.has(KEY_CARRIER)) {
            this.setCarrier(jSONObject2.getString(KEY_CARRIER));
        }
        if (jSONObject2.has(KEY_CONSOLE_LOG)) {
            this.setConsoleLog(a.a(new JSONArray(jSONObject2.getString(KEY_CONSOLE_LOG))));
        }
        if (jSONObject2.has(KEY_CURRENT_VIEW)) {
            this.setCurrentView(jSONObject2.getString(KEY_CURRENT_VIEW));
        }
        if (jSONObject2.has(KEY_DENSITY)) {
            this.setScreenDensity(jSONObject2.getString(KEY_DENSITY));
        }
        if (jSONObject2.has(KEY_DEVICE)) {
            this.setDevice(jSONObject2.getString(KEY_DEVICE));
        }
        if (jSONObject2.has(KEY_DEVICE_ROOTED)) {
            this.setIsDeviceRooted(jSONObject2.getBoolean(KEY_DEVICE_ROOTED));
        }
        if (jSONObject2.has(KEY_DURATION)) {
            this.setDuration(jSONObject2.getLong(KEY_DURATION));
        }
        if (jSONObject2.has(KEY_EMAIL)) {
            this.setUserEmail(jSONObject2.getString(KEY_EMAIL));
        }
        if (jSONObject2.has(KEY_NAME)) {
            this.setUserName(jSONObject2.getString(KEY_NAME));
        }
        if (jSONObject2.has(KEY_PUSH_TOKEN)) {
            this.setPushToken(jSONObject2.getString(KEY_PUSH_TOKEN));
        }
        if (jSONObject2.has(KEY_INSTABUG_LOG)) {
            this.setInstabugLog(jSONObject2.getString(KEY_INSTABUG_LOG));
        }
        if (jSONObject2.has(KEY_LOCALE)) {
            this.setLocale(jSONObject2.getString(KEY_LOCALE));
        }
        if (jSONObject2.has(KEY_MEMORY_FREE)) {
            this.setFreeMemory(jSONObject2.getLong(KEY_MEMORY_FREE));
        }
        if (jSONObject2.has(KEY_MEMORY_TOTAL)) {
            this.setTotalMemory(jSONObject2.getLong(KEY_MEMORY_TOTAL));
        }
        if (jSONObject2.has(KEY_MEMORY_USED)) {
            this.setUsedMemory(jSONObject2.getLong(KEY_MEMORY_USED));
        }
        if (jSONObject2.has(KEY_ORIENTATION)) {
            this.setScreenOrientation(jSONObject2.getString(KEY_ORIENTATION));
        }
        if (jSONObject2.has(KEY_OS)) {
            this.setOS(jSONObject2.getString(KEY_OS));
        }
        if (jSONObject2.has(KEY_APP_STATUS)) {
            this.setAppStatus(jSONObject2.getString(KEY_APP_STATUS));
        }
        if (jSONObject2.has(KEY_REPORTED_AT)) {
            this.setReportedAt(jSONObject2.getLong(KEY_REPORTED_AT));
        }
        if (jSONObject2.has(KEY_SCREEN_SIZE)) {
            this.setScreenSize(jSONObject2.getString(KEY_SCREEN_SIZE));
        }
        if (jSONObject2.has(KEY_SDK_VERSION)) {
            this.setSdkVersion(jSONObject2.getString(KEY_SDK_VERSION));
        }
        if (jSONObject2.has(KEY_STORAGE_FREE)) {
            this.setFreeStorage(jSONObject2.getLong(KEY_STORAGE_FREE));
        }
        if (jSONObject2.has(KEY_STORAGE_TOTAL)) {
            this.setTotalStorage(jSONObject2.getLong(KEY_STORAGE_TOTAL));
        }
        if (jSONObject2.has(KEY_STORAGE_USED)) {
            this.setUsedStorage(jSONObject2.getLong(KEY_STORAGE_USED));
        }
        if (jSONObject2.has(KEY_TAGS)) {
            this.setTags(jSONObject2.getString(KEY_TAGS));
        }
        if (jSONObject2.has(KEY_USER_DATA)) {
            this.setUserData(jSONObject2.getString(KEY_USER_DATA));
        }
        if (jSONObject2.has(KEY_USER_STEPS)) {
            this.setUserSteps(j.a(new JSONArray(jSONObject2.getString(KEY_USER_STEPS))));
        }
        if (jSONObject2.has(KEY_WIFI_SSID)) {
            this.setWifiSSID(jSONObject2.getString(KEY_WIFI_SSID));
        }
        if (jSONObject2.has(KEY_WIFI_STATE)) {
            this.setWifiState(jSONObject2.getBoolean(KEY_WIFI_STATE));
        }
        if (jSONObject2.has(KEY_USER_ATTRIBUTES)) {
            this.setUserAttributes(jSONObject2.getString(KEY_USER_ATTRIBUTES));
        }
        if (jSONObject2.has(KEY_NETWORK_LOGS)) {
            this.setNetworkLogs(jSONObject2.getString(KEY_NETWORK_LOGS));
        }
        if (jSONObject2.has(KEY_USER_EVENTS)) {
            this.setUserEvents(jSONObject2.getString(KEY_USER_EVENTS));
        }
        if (jSONObject2.has(KEY_VISUAL_USER_STEPS)) {
            this.setVisualUserSteps(VisualUserStep.fromJson(new JSONArray(jSONObject2.getString(KEY_VISUAL_USER_STEPS))));
        }
        if (jSONObject2.has(KEY_SESSIONS_PROFILER)) {
            this.setSessionProfilerTimeline(com.instabug.library.n.b.a.e.a(new JSONObject(jSONObject2.getString(KEY_SESSIONS_PROFILER))));
        }
    }

    public ArrayList<StateItem> getLogsItems() {
        ArrayList<StateItem> arrayList;
        ArrayList<StateItem> arrayList2 = arrayList;
        new ArrayList<StateItem>().add(new StateItem().setKey(KEY_CONSOLE_LOG).setValue(this.getConsoleLog().toString()));
        arrayList2.add(new StateItem().setKey(KEY_INSTABUG_LOG).setValue(this.getInstabugLog()));
        arrayList2.add(new StateItem().setKey(KEY_USER_DATA).setValue(this.getUserData()));
        arrayList2.add(new StateItem().setKey(KEY_NETWORK_LOGS).setValue(this.getNetworkLogs()));
        arrayList2.add(new StateItem().setKey(KEY_USER_EVENTS).setValue(this.getUserEvents()));
        if (d.d().a((Object)Feature.TRACK_USER_STEPS) == Feature.State.ENABLED) {
            arrayList2.add(new StateItem().setKey(KEY_USER_STEPS).setValue(this.getUserSteps().toString()));
        }
        if (d.d().a((Object)Feature.REPRO_STEPS) == Feature.State.ENABLED) {
            arrayList2.add(new StateItem().setKey(KEY_VISUAL_USER_STEPS).setValue(this.getVisualUserSteps()));
        }
        if (d.d().a((Object)Feature.SESSION_PROFILER) == Feature.State.ENABLED && this.sessionProfilerTimeline != null) {
            arrayList2.add(new StateItem().setKey(KEY_SESSIONS_PROFILER).setValue(this.getSessionProfilerTimeline()));
        }
        return arrayList2;
    }

    @NonNull
    public String toString() {
        try {
            return this_.toJson();
        }
        catch (JSONException jSONException) {
            Object this_ = jSONException;
            jSONException.printStackTrace();
            InstabugSDKLogger.e(TAG, "Something went wrong while getting state.toString()" + this_.getMessage(), (Throwable)this_);
            return "error";
        }
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public boolean equals(Object state) {
        if (state instanceof State) {
            State state2;
            return String.valueOf((state2 = (State)state2).getAppVersion()).equals(String.valueOf(this.getAppVersion())) && state2.getBatteryLevel() == this.getBatteryLevel() && String.valueOf(state2.getBatteryState()).equals(String.valueOf(this.getBatteryState())) && String.valueOf(state2.getCarrier()).equals(String.valueOf(this.getCarrier())) && String.valueOf(state2.getAppStatus()).equals(String.valueOf(this.getAppStatus())) && String.valueOf(state2.getConsoleLog()).equals(String.valueOf(this.getConsoleLog())) && String.valueOf(state2.getCurrentView()).equals(String.valueOf(this.getCurrentView())) && state2.getDuration() == this.getDuration() && String.valueOf(state2.getDevice()).equals(String.valueOf(this.getDevice())) && state2.getFreeMemory() == this.getFreeMemory() && state2.getFreeStorage() == this.getFreeStorage() && String.valueOf(state2.getLocale()).equals(String.valueOf(this.getLocale())) && String.valueOf(state2.getOS()).equals(String.valueOf(this.getOS())) && state2.getReportedAt() == this.getReportedAt() && String.valueOf(state2.getScreenDensity()).equals(String.valueOf(this.getScreenDensity())) && String.valueOf(state2.getScreenOrientation()).equals(String.valueOf(this.getScreenOrientation())) && String.valueOf(state2.getScreenSize()).equals(String.valueOf(this.getScreenSize())) && String.valueOf(state2.getSdkVersion()).equals(String.valueOf(this.getSdkVersion())) && state2.getTotalMemory() == this.getTotalMemory() && state2.getTotalStorage() == this.getTotalStorage() && String.valueOf(state2.getTags()).equals(String.valueOf(this.getTags())) && state2.getUsedMemory() == this.getUsedMemory() && state2.getUsedStorage() == this.getUsedStorage() && String.valueOf(state2.getUserData()).equals(String.valueOf(this.getUserData())) && String.valueOf(state2.getUserEmail()).equals(String.valueOf(this.getUserEmail())) && String.valueOf(state2.getUserName()).equals(String.valueOf(this.getUserName())) && String.valueOf(state2.getPushToken()).equals(String.valueOf(this.getPushToken())) && String.valueOf(state2.getUserSteps()).equals(String.valueOf(this.getUserSteps())) && String.valueOf(state2.getWifiSSID()).equals(String.valueOf(this.getWifiSSID())) && state2.isDeviceRooted() == this.isDeviceRooted() && state2.isWifiEnable() == this.isWifiEnable() && String.valueOf(state2.getInstabugLog()).equals(String.valueOf(this.getInstabugLog())) && String.valueOf(state2.getUserAttributes()).equals(String.valueOf(this.getUserAttributes())) && String.valueOf(state2.getNetworkLogs()).equals(String.valueOf(this.getNetworkLogs())) && String.valueOf(state2.getUserEvents()).equals(String.valueOf(this.getUserEvents())) && String.valueOf(state2.getVisualUserSteps()).equals(String.valueOf(this.getVisualUserSteps())) && String.valueOf(state2.getSessionProfilerTimeline()).equals(String.valueOf(this.getSessionProfilerTimeline()));
        }
        return false;
    }

    public int hashCode() {
        return String.valueOf(this.getReportedAt()).hashCode();
    }

    public void updateVisualUserSteps() {
        this.setVisualUserSteps(Builder.getVisualUserSteps());
    }

    public static class Builder
    implements Serializable {
        private Context context;

        /*
         * WARNING - void declaration
         */
        public Builder(Context context) {
            void var1_1;
            this.context = var1_1;
        }

        private static ArrayList<a> getConsoleLog(ArrayList<a> consoleLogs) {
            ArrayList<a> arrayList;
            ArrayList<a> arrayList2 = Builder.getConsoleLog();
            arrayList2.addAll(arrayList);
            return arrayList2;
        }

        /*
         * Unable to fully structure code
         */
        private static ArrayList<a> getConsoleLog() {
            var0 = v0;
            v0 = new ArrayList<a>();
            if (d.d().a((Object)Feature.CONSOLE_LOGS) == Feature.State.ENABLED) {
                block17: {
                    var1_1 = 700;
                    var2_4 = Runtime.getRuntime().exec("logcat -v time -d " + Process.myPid());
                    var3_5 = v1;
                    v1 = new BufferedReader(new InputStreamReader(var2_4.getInputStream(), Charset.forName("UTF-8")));
                    var2_4 = v2;
                    v2 = new ArrayList<E>();
                    ** while ((var4_7 = var3_5.readLine()) != null)
lbl-1000:
                    // 1 sources

                    {
                        var2_4.add(var4_7);
                        continue;
                    }
lbl19:
                    // 2 sources

                    v3 = var2_4;
                    v4 = v3;
                    var3_5.close();
                    v3.trimToSize();
                    var3_6 = 0;
                    if (v4.size() <= var1_1) break block17;
                    var3_6 = var2_4.size() - var1_1;
                }
                while (true) {
                    block18: {
                        if (var3_6 >= var2_4.size()) break;
                        if (((String)var2_4.get(var3_6)).length() <= 18) break block18;
                        v5 = var0;
                        var1_2 = v6;
                        var1_2();
                        var1_2.a(((String)var2_4.get(var3_6)).substring(18));
                        v6.a(a.b(((String)var2_4.get(var3_6)).substring(0, 18)));
                        v5.add(v6);
                    }
                    ++var3_6;
                }
                try {
                    var2_4.clear();
                    return var0;
                }
                catch (IOException var1_3) {
                    InstabugSDKLogger.e("State", "Could not read logcat log", var1_3);
                    return var0;
                }
            }
            return var0;
        }

        @Nullable
        private String getInstabugLog() {
            block4: {
                if (!MemoryUtils.isLowMemory(this.context)) {
                    try {
                        if (d.d().a((Object)Feature.INSTABUG_LOGS) != Feature.State.ENABLED) break block4;
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        InstabugSDKLogger.e(State.TAG, "Got error while parsing user events logs", outOfMemoryError);
                        break block4;
                    }
                    return InstabugLog.getLogs();
                }
                InstabugSDKLogger.w(State.TAG, "Running low on memory. Excluding UserEvents serialization from state builder.");
            }
            return null;
        }

        private ArrayList<j> getUserSteps() {
            return e.c().b();
        }

        private static ArrayList<VisualUserStep> getVisualUserSteps() {
            return h.d().a();
        }

        private com.instabug.library.n.b.a.e getSessionProfilerTimeline() {
            return com.instabug.library.n.a.d().a();
        }

        private String getUserEmail() {
            return b.i();
        }

        private String getUserName() {
            return b.j();
        }

        private String getPushNotificationToken() {
            return InstabugCore.getPushNotificationToken();
        }

        private String getUserData() {
            return SettingsManager.getInstance().getUserData();
        }

        private long getReportedAt() {
            return InstabugDateFormatter.getCurrentUTCTimeStampInSeconds();
        }

        private String getTags() {
            return SettingsManager.getInstance().getTagsAsString();
        }

        /*
         * WARNING - void declaration
         */
        private String getUserEvents() {
            if (!MemoryUtils.isLowMemory(this.context)) {
                void var0_3;
                try {
                    return UserEvent.toJson(InstabugUserEventLogger.getInstance().getUserEvents()).toString();
                }
                catch (OutOfMemoryError outOfMemoryError) {
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                InstabugSDKLogger.e(State.TAG, "Got error while parsing user events logs", (Throwable)var0_3);
            } else {
                InstabugSDKLogger.w(State.TAG, "Running low on memory. Excluding UserEvents serialization from state builder.");
            }
            return "[]";
        }

        /*
         * WARNING - void declaration
         */
        @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
        public State build(boolean withInstabugLogs) {
            void var1_1;
            State state = State.access$400(State.access$300(new State(), DeviceStateProvider.getSdkVersion()).setLocale(DeviceStateProvider.getLocale(this.context)).setDuration(DeviceStateProvider.getActiveSessionDuration()).setDevice(DeviceStateProvider.getDevice()), DeviceStateProvider.isDeviceRooted()).setOS(DeviceStateProvider.getOS()).setCarrier(DeviceStateProvider.getCarrier(this.context));
            String string = InstabugCore.getStartedActivitiesCount() > 0 ? State.VALUE_APP_STATUS_FOREGROUND : State.VALUE_APP_STATUS_BACKGROUND;
            State state2 = State.access$1600(State.access$1500(State.access$1400(State.access$1300(State.access$1200(State.access$1100(State.access$1000(State.access$900(State.access$800(State.access$700(State.access$600(State.access$500(state, string).setAppVersion(DeviceStateProvider.getAppVersion(this.context)).setAppPackageName(DeviceStateProvider.getAppPackageName(this.context)).setBatteryLevel(DeviceStateProvider.getBatteryLevel(this.context)).setBatteryState(DeviceStateProvider.getBatteryState(this.context)), DeviceStateProvider.getWifiState(this.context)), DeviceStateProvider.getWifiSSID(this.context)).setFreeMemory(DeviceStateProvider.getFreeMemory(this.context)), DeviceStateProvider.getUsedMemory(this.context)).setTotalMemory(DeviceStateProvider.getTotalMemory(this.context)), DeviceStateProvider.getFreeStorage()), DeviceStateProvider.getUsedStorage()), DeviceStateProvider.getTotalStorage()).setScreenDensity(DeviceStateProvider.getScreenDensity(this.context)).setScreenSize(DeviceStateProvider.getScreenSize(this.context)).setScreenOrientation(DeviceStateProvider.getScreenOrientation(this.context)).setCurrentView(DeviceStateProvider.getCurrentView()), Builder.getConsoleLog()), this.getUserSteps()).setUserEmail(this.getUserEmail()).setUserName(this.getUserName()).setPushToken(this.getPushNotificationToken()).setUserData(this.getUserData()), this.getReportedAt()).setTags(this.getTags()).setUserAttributes(UserAttributesDbHelper.getSDKUserAttributes()), this.getNetworkLogs()).setUserEvents(this.getUserEvents()), this.getSessionProfilerTimeline());
            if (var1_1 != false && this.getInstabugLog() != null) {
                state2.setInstabugLog(this.getInstabugLog());
            }
            return state2;
        }

        public State buildInternalState() {
            State state = State.access$400(State.access$300(new State(), DeviceStateProvider.getSdkVersion()).setLocale(DeviceStateProvider.getLocale(this.context)).setDuration(DeviceStateProvider.getActiveSessionDuration()).setDevice(DeviceStateProvider.getDevice()), DeviceStateProvider.isDeviceRooted()).setOS(DeviceStateProvider.getOS()).setCarrier(DeviceStateProvider.getCarrier(this.context));
            String string = InstabugCore.getStartedActivitiesCount() > 0 ? State.VALUE_APP_STATUS_FOREGROUND : State.VALUE_APP_STATUS_BACKGROUND;
            return State.access$1400(State.access$1100(State.access$1000(State.access$900(State.access$800(State.access$700(State.access$600(State.access$500(state, string).setAppVersion(DeviceStateProvider.getAppVersion(this.context)).setAppPackageName(DeviceStateProvider.getAppPackageName(this.context)).setBatteryLevel(DeviceStateProvider.getBatteryLevel(this.context)).setBatteryState(DeviceStateProvider.getBatteryState(this.context)), DeviceStateProvider.getWifiState(this.context)), DeviceStateProvider.getWifiSSID(this.context)).setFreeMemory(DeviceStateProvider.getFreeMemory(this.context)), DeviceStateProvider.getUsedMemory(this.context)).setTotalMemory(DeviceStateProvider.getTotalMemory(this.context)), DeviceStateProvider.getFreeStorage()), DeviceStateProvider.getUsedStorage()), DeviceStateProvider.getTotalStorage()).setScreenDensity(DeviceStateProvider.getScreenDensity(this.context)).setScreenSize(DeviceStateProvider.getScreenSize(this.context)).setScreenOrientation(DeviceStateProvider.getScreenOrientation(this.context)).setCurrentView(DeviceStateProvider.getCurrentView()), this.getReportedAt());
        }

        public String formatSessionDuration(long d2) {
            StringBuilder stringBuilder;
            long l2 = d2;
            Serializable serializable = stringBuilder;
            stringBuilder = new StringBuilder();
            int n2 = (int)l2 % 60;
            long l3 = l2 / 60L;
            int n3 = (int)l3 % 60;
            int n4 = (int)(l3 / 60L) % 60;
            if (n4 <= 9) {
                ((StringBuilder)serializable).append("0");
            }
            Serializable serializable2 = serializable;
            ((StringBuilder)serializable2).append(n4);
            ((StringBuilder)serializable2).append(":");
            if (n3 <= 9) {
                ((StringBuilder)serializable).append("0");
            }
            Serializable serializable3 = serializable;
            ((StringBuilder)serializable3).append(n3);
            ((StringBuilder)serializable3).append(":");
            if (n2 <= 9) {
                ((StringBuilder)serializable).append("0");
            }
            Serializable serializable4 = serializable;
            ((StringBuilder)serializable4).append(n2);
            return ((StringBuilder)serializable4).toString();
        }

        @Nullable
        public String getNetworkLogs() {
            return com.instabug.library.logging.b.a(MemoryGuard.from(this.context));
        }
    }

    public static class StateItem<V>
    implements Serializable {
        @Nullable
        String key;
        @Nullable
        V value;

        @Nullable
        public String getKey() {
            return this.key;
        }

        /*
         * WARNING - void declaration
         */
        public StateItem<V> setKey(@Nullable String key) {
            void var1_1;
            this.key = var1_1;
            return this;
        }

        @Nullable
        public V getValue() {
            return this.value;
        }

        /*
         * WARNING - void declaration
         */
        public StateItem<V> setValue(@Nullable V value) {
            void var1_1;
            this.value = var1_1;
            return this;
        }

        @NonNull
        @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
        public String toString() {
            return "key: " + this.getKey() + ", value: " + this.getValue();
        }
    }

    @Keep
    public static final class Action
    extends Enum<Action> {
        public static final /* enum */ Action FINISHED;
        public static final /* enum */ Action ERROR;
        private static final /* synthetic */ Action[] $VALUES;

        public static Action[] values() {
            return (Action[])$VALUES.clone();
        }

        public static Action valueOf(String name) {
            String string;
            return Enum.valueOf(Action.class, string);
        }

        static {
            Action action;
            FINISHED = new Action();
            Action action2 = action;
            ERROR = new Action();
            $VALUES = new Action[]{FINISHED, action2};
        }
    }
}

