/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.network;

import android.content.Context;
import android.content.Intent;
import androidx.annotation.VisibleForTesting;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.internal.storage.AttachmentsUtility;
import com.instabug.library.internal.storage.cache.AttachmentsDbHelper;
import com.instabug.library.model.Attachment;
import com.instabug.library.model.State;
import com.instabug.library.network.NetworkManager;
import com.instabug.library.network.Request;
import com.instabug.library.network.RequestResponse;
import com.instabug.library.util.InstabugSDKLogger;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.observers.DisposableObserver;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class b {
    private static b c;
    private NetworkManager a;
    @VisibleForTesting
    Request b;

    public static b a() {
        if (c == null) {
            c = new b();
        }
        return c;
    }

    private b() {
        NetworkManager networkManager;
        b b2 = networkManager;
        networkManager = new NetworkManager();
        v1.a = b2;
    }

    public void a(Context context, com.instabug.bug.model.a a2, Request.Callbacks<String, Throwable> callbacks) throws JSONException {
        b b2 = this;
        InstabugSDKLogger.d((Object)"BugsService", (String)("Reporting a bug with message: " + a2.g()));
        a2 = b2.b(context, a2);
        b2.b = a2;
        b2.a.doRequest((Request)a2).subscribe(this.a(context, callbacks));
    }

    @VisibleForTesting
    Observer<RequestResponse> a(final Context context, final Request.Callbacks<String, Throwable> callbacks) {
        return new DisposableObserver<RequestResponse>(this){

            public void onStart() {
                InstabugSDKLogger.d((Object)"BugsService", (String)"reportingBugRequest started");
            }

            public void onComplete() {
                InstabugSDKLogger.d((Object)"BugsService", (String)"reportingBugRequest completed");
            }

            public void onError(Throwable throwable) {
                InstabugSDKLogger.e((Object)"BugsService", (String)("reportingBugRequest got error: " + throwable.getMessage()), (Throwable)throwable);
                callbacks.onFailed((Object)throwable);
            }

            public void a(RequestResponse requestResponse) {
                InstabugSDKLogger.d((Object)"BugsService", (String)("reportingBugRequest onNext, Response code: " + requestResponse.getResponseCode() + "Response body: " + requestResponse.getResponseBody()));
                try {
                    calendar.callbacks.onSucceeded((Object)new JSONObject((String)requestResponse.getResponseBody()).getString("id"));
                }
                catch (JSONException jSONException) {
                    InstabugSDKLogger.e((Object)"BugsService", (String)("reportingBugRequest onNext got error: " + jSONException.getMessage()), (Throwable)jSONException);
                }
                if (requestResponse.getResponseCode() == 200) {
                    Intent intent;
                    a a2 = calendar;
                    Calendar calendar = Calendar.getInstance(Locale.ENGLISH);
                    InstabugSDKLogger.d((Object)"BugsService", (String)("Updating last_contacted_at to " + calendar.getTime()));
                    com.instabug.bug.settings.a.r().a(calendar.getTime().getTime());
                    InstabugCore.setLastContactedAt((long)calendar.getTime().getTime());
                    RequestResponse requestResponse2 = requestResponse = intent;
                    requestResponse2();
                    requestResponse2.setAction("User last contact at changed");
                    long l2 = calendar.getTime().getTime();
                    intent.putExtra("last_contacted_at", l2);
                    LocalBroadcastManager.getInstance((Context)a2.context).sendBroadcast((Intent)requestResponse);
                }
            }
        };
    }

    @VisibleForTesting
    Request b(Context context, com.instabug.bug.model.a a2) throws JSONException {
        b b2 = b3;
        b b3 = b2.a.buildRequest(context, Request.Endpoint.REPORT_BUG, Request.RequestMethod.Post);
        b2.b = b3;
        b2.a((Request)b3, a2);
        b2.b.addRequestBodyParameter("title", (Object)a2.g());
        b2.b.addRequestBodyParameter("attachments_count", (Object)a2.a().size());
        b2.b.addRequestBodyParameter("categories", (Object)a2.d());
        return b2.b;
    }

    @VisibleForTesting
    void a(Request request, com.instabug.bug.model.a a2) throws JSONException {
        ArrayList arrayList = a2.getState().getStateItems();
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            InstabugSDKLogger.d((Object)"BugsService", (String)("Bug State Key: " + ((State.StateItem)arrayList.get(i2)).getKey() + ", Bug State value: " + ((State.StateItem)arrayList.get(i2)).getValue()));
            request.addRequestBodyParameter(((State.StateItem)a2.getState().getStateItems().get(i2)).getKey(), ((State.StateItem)a2.getState().getStateItems().get(i2)).getValue());
        }
    }

    public void b(Context context, final com.instabug.bug.model.a a2, final Request.Callbacks<Boolean, com.instabug.bug.model.a> callbacks) throws JSONException {
        InstabugSDKLogger.d((Object)"BugsService", (String)"Uploading Bug attachments");
        Observable.merge(this.c(context, a2), (int)1).subscribe((Observer)new DisposableObserver<RequestResponse>(this){

            public void onStart() {
                InstabugSDKLogger.d((Object)"BugsService", (String)"uploadingBugAttachmentRequest started");
            }

            public void onComplete() {
                InstabugSDKLogger.d((Object)"BugsService", (String)"uploadingBugAttachmentRequest completed");
                if (a2.a().size() == 0) {
                    callbacks.onSucceeded((Object)true);
                }
            }

            public void onError(Throwable throwable) {
                b b2 = this;
                InstabugSDKLogger.e((Object)"BugsService", (String)("uploadingBugAttachmentRequest got error: " + throwable.getMessage()), (Throwable)throwable);
                AttachmentsUtility.encryptAttachmentsAndUpdateDb(b2.a2.a());
                b2.callbacks.onFailed((Object)a2);
            }

            public void a(RequestResponse requestResponse) {
                InstabugSDKLogger.d((Object)"BugsService", (String)("uploadingBugAttachmentRequest onNext, Response code: " + requestResponse.getResponseCode() + ", Response body: " + requestResponse.getResponseBody()));
                if (new File(a2.a().get(0).getLocalPath()).delete()) {
                    InstabugSDKLogger.d((Object)"BugsService", (String)"uploadingBugAttachmentRequest onNext, attachment file deleted successfully");
                }
                if ((requestResponse = a2.a().remove(0)).getId() != -1L) {
                    AttachmentsDbHelper.delete((long)requestResponse.getId());
                } else {
                    AttachmentsDbHelper.delete((String)requestResponse.getName(), (String)a2.getId());
                }
            }
        });
    }

    @VisibleForTesting
    ArrayList<Observable<RequestResponse>> c(Context context, com.instabug.bug.model.a a2) throws JSONException {
        ArrayList<Observable<RequestResponse>> arrayList;
        ArrayList<Observable<RequestResponse>> arrayList2 = arrayList;
        arrayList = new ArrayList<Observable<RequestResponse>>(a2.a().size());
        for (int i2 = 0; i2 < a2.a().size(); ++i2) {
            File file;
            Object object = a2.a().get(i2);
            boolean bl = AttachmentsUtility.decryptAttachmentAndUpdateDb((Attachment)object);
            if (object.getLocalPath() == null) continue;
            Object object2 = file;
            file = new File(object.getLocalPath());
            if (bl && ((File)object2).exists() && ((File)object2).length() > 0L) {
                Request.Endpoint endpoint = Request.Endpoint.ADD_BUG_ATTACHMENT;
                object2 = NetworkManager.RequestType.MULTI_PART;
                Request.Endpoint endpoint2 = endpoint = this.a.buildRequest(context, endpoint, Request.RequestMethod.Post, (NetworkManager.RequestType)object2);
                endpoint2.setEndpoint(endpoint2.getEndpoint().replaceAll(":bug_token", a2.h()));
                endpoint.addParameter("metadata[file_type]", (Object)object.getType());
                if (object.getType() == Attachment.Type.AUDIO) {
                    endpoint.addParameter("metadata[duration]", (Object)object.getDuration());
                }
                object.setAttachmentState(Attachment.AttachmentState.SYNCED);
                Attachment attachment = object;
                object = attachment.getName();
                object2 = attachment.getLocalPath();
                String string2 = attachment.getFileType();
                endpoint.setFileToUpload(new Request.FileToUpload("file", (String)object, (String)object2, string2));
                arrayList2.add((Observable<RequestResponse>)this.a.doRequest((Request)endpoint));
                continue;
            }
            if (!bl) {
                InstabugSDKLogger.e((Object)"BugsService", (String)("Skipping attachment file of type " + object.getType() + " because it was not decrypted successfully"));
                continue;
            }
            if (((File)object2).exists() && ((File)object2).length() > 0L) continue;
            InstabugSDKLogger.e((Object)"BugsService", (String)("Skipping attachment file of type " + object.getType() + " because it's either not found or empty file"));
        }
        return arrayList2;
    }

    public void c(Context context, final com.instabug.bug.model.a a2, final Request.Callbacks<Boolean, com.instabug.bug.model.a> callbacks) {
        b b2 = this;
        b b3 = b2;
        context = b2.a(context, a2);
        try {
            b3.a.doRequest((Request)context).subscribe((Observer)new DisposableObserver<RequestResponse>(this){

                public void onStart() {
                    InstabugSDKLogger.d((Object)"BugsService", (String)"uploading bug logs started");
                }

                public void a(RequestResponse requestResponse) {
                    InstabugSDKLogger.addVerboseLog((Object)"BugsService", (String)("uploading bug logs onNext, Response code: " + requestResponse.getResponseCode() + "Response body: " + requestResponse.getResponseBody()));
                }

                public void onComplete() {
                    InstabugSDKLogger.d((Object)"BugsService", (String)"uploading bug logs completed");
                    callbacks.onSucceeded((Object)true);
                }

                public void onError(Throwable throwable) {
                    InstabugSDKLogger.e((Object)"BugsService", (String)"uploading bug logs got error", (Throwable)throwable);
                    callbacks.onFailed((Object)a2);
                }
            });
        }
        catch (JSONException jSONException) {
            InstabugSDKLogger.e((Object)"BugsService", (String)"uploading bug logs got Json error ", (Throwable)jSONException);
            callbacks.onFailed((Object)a2);
        }
    }

    @VisibleForTesting
    Request a(Context object, com.instabug.bug.model.a a2) throws JSONException {
        b b2 = b2.a.buildRequest((Context)object, Request.Endpoint.BUG_LOGS, Request.RequestMethod.Post);
        b2.setEndpoint(b2.getEndpoint().replaceAll(":bug_token", a2.h()));
        for (State.StateItem stateItem : a2.getState().getLogsItems()) {
            String string2 = stateItem.getKey();
            b2.addRequestBodyParameter(string2, stateItem.getValue());
        }
        if (a2.j() != null) {
            b2.addRequestBodyParameter("view_hierarchy", a2.j());
        }
        return b2;
    }
}

