/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.model;

import android.support.annotation.DrawableRes;
import com.instabug.bug.model.c;
import com.instabug.bug.settings.a;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ReportCategory {
    private static final String KEY_LABEL = "name";
    private static final String KEY_SUBS = "subs";
    private static final String KEY_SLUG = "slug";
    private static final String CATEGORY_REPORT_A_PROBLEM = "report-a-problem";
    private static final String CATEGORY_SUGGEST_AN_IMPROVEMENT = "suggest-an-improvement";
    private String label;
    private int icon;
    private List<ReportCategory> subs;

    private ReportCategory() {
    }

    public static ReportCategory getInstance() {
        return new ReportCategory();
    }

    public ReportCategory withLabel(String label) {
        this.label = label;
        return this;
    }

    public ReportCategory withIcon(@DrawableRes int icon) {
        this.icon = icon;
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public int getIcon() {
        return this.icon;
    }

    public void setIcon(@DrawableRes int icon) {
        this.icon = icon;
    }

    public List<ReportCategory> getSubs() {
        return this.subs;
    }

    private void setSubs(List<ReportCategory> subs) {
        this.subs = subs;
    }

    private static ReportCategory fromJsonObject(JSONObject jsonObject) throws JSONException {
        ReportCategory reportCategory = new ReportCategory();
        if (jsonObject.has(KEY_LABEL)) {
            reportCategory.setLabel(jsonObject.getString(KEY_LABEL));
        }
        ArrayList<ReportCategory> arrayList = new ArrayList<ReportCategory>();
        if (jsonObject.has(KEY_SUBS)) {
            JSONArray jSONArray = jsonObject.getJSONArray(KEY_SUBS);
            for (int i = 0; i < jSONArray.length(); ++i) {
                arrayList.add(ReportCategory.fromJsonObject(jSONArray.getJSONObject(i)));
            }
        }
        reportCategory.setSubs(arrayList);
        return reportCategory;
    }

    public static List<ReportCategory> getSubReportCategories(c reportType) {
        List<ReportCategory> list = ReportCategory.getRemoteSubReportCategories(reportType);
        return list != null ? list : a.a().b();
    }

    private static List<ReportCategory> getRemoteSubReportCategories(c reportType) {
        String string2 = a.a().c();
        if (string2 != null) {
            try {
                List<ReportCategory> list;
                JSONArray jSONArray = new JSONArray(string2);
                if (reportType == c.BUG) {
                    List<ReportCategory> list2 = ReportCategory.getSubCategories(jSONArray, CATEGORY_REPORT_A_PROBLEM);
                    if (list2 != null && list2.size() > 0) {
                        return list2;
                    }
                } else if (reportType == c.FEEDBACK && (list = ReportCategory.getSubCategories(jSONArray, CATEGORY_SUGGEST_AN_IMPROVEMENT)) != null && list.size() > 0) {
                    return list;
                }
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        return null;
    }

    private static List<ReportCategory> getSubCategories(JSONArray jsonArray, String slug) throws JSONException {
        for (int i = 0; i < jsonArray.length(); ++i) {
            String string2 = jsonArray.getJSONObject(i).getString(KEY_SLUG);
            if (!slug.equals(string2)) continue;
            return ReportCategory.fromJsonObject(jsonArray.getJSONObject(i)).getSubs();
        }
        return null;
    }

    public static boolean hasSubCategories(c reportType) {
        List<ReportCategory> list = ReportCategory.getRemoteSubReportCategories(c.BUG);
        List<ReportCategory> list2 = ReportCategory.getRemoteSubReportCategories(c.FEEDBACK);
        boolean bl = false;
        if (list != null && !list.isEmpty()) {
            if (reportType == c.BUG) {
                return true;
            }
            bl = true;
        }
        if (list2 != null && !list2.isEmpty()) {
            if (reportType == c.FEEDBACK) {
                return true;
            }
            bl = true;
        }
        List<ReportCategory> list3 = a.a().b();
        return !bl && list3 != null && list3.size() > 0;
    }
}

