/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug;

import com.instabug.bug.OnSdkDismissedCallback;
import com.instabug.bug.cache.BugsCacheManager;
import com.instabug.bug.extendedbugreport.ExtendedBugReport;
import com.instabug.bug.model.Bug;
import com.instabug.bug.model.ReportCategory;
import com.instabug.bug.settings.AttachmentsTypesParams;
import com.instabug.bug.settings.a;
import com.instabug.bug.settings.b;
import com.instabug.library.OnSdkDismissedCallback;
import com.instabug.library.analytics.AnalyticsObserver;
import com.instabug.library.analytics.model.Api;
import com.instabug.library.bugreporting.model.Bug;
import com.instabug.library.extendedbugreport.ExtendedBugReport;
import com.instabug.library.model.BugCategory;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.ArrayList;
import java.util.List;

public class InstabugBugReporting {
    public static void setReportCategories(List<ReportCategory> list) {
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("reportCategories").setType(ReportCategory.class)});
        a.a().a(list);
    }

    private static void setLegacyReportCategories(List<com.instabug.library.bugreporting.model.ReportCategory> list) {
        ArrayList<ReportCategory> arrayList = new ArrayList<ReportCategory>();
        for (com.instabug.library.bugreporting.model.ReportCategory reportCategory : list) {
            ReportCategory reportCategory2 = ReportCategory.getInstance().withIcon(reportCategory.getIcon()).withLabel(reportCategory.getLabel());
            arrayList.add(reportCategory2);
        }
        InstabugBugReporting.setReportCategories(arrayList);
    }

    private static void setLegacyBugCategories(List<BugCategory> list) {
        ArrayList<ReportCategory> arrayList = new ArrayList<ReportCategory>();
        for (BugCategory bugCategory : list) {
            ReportCategory reportCategory = ReportCategory.getInstance().withIcon(bugCategory.getIcon()).withLabel(bugCategory.getLabel());
            arrayList.add(reportCategory);
        }
        InstabugBugReporting.setReportCategories(arrayList);
    }

    private void updateBugCacheManager() {
        List<Bug> list = BugsCacheManager.getBugs();
        for (Bug bug : list) {
            if (bug.f() != Bug.BugState.WAITING_VIDEO) continue;
            InstabugSDKLogger.v((Object)this, (String)"found the video bug");
            bug.a(Bug.BugState.READY_TO_BE_SENT);
            BugsCacheManager.addBug(bug);
            break;
        }
    }

    private static void setLegacyOnSdkDismissedCallback(final com.instabug.library.OnSdkDismissedCallback onSdkDismissedCallback) throws IllegalStateException {
        OnSdkDismissedCallback onSdkDismissedCallback2 = new OnSdkDismissedCallback(){

            @Override
            public void onSdkDismissed(OnSdkDismissedCallback.DismissType dismissType, com.instabug.bug.model.b b2) {
                OnSdkDismissedCallback.DismissType dismissType2;
                Bug.Type type;
                switch (b2) {
                    case a: {
                        type = Bug.Type.BUG;
                        break;
                    }
                    case b: {
                        type = Bug.Type.FEEDBACK;
                        break;
                    }
                    case c: {
                        type = Bug.Type.NOT_AVAILABLE;
                        break;
                    }
                    default: {
                        type = Bug.Type.NOT_AVAILABLE;
                    }
                }
                switch (dismissType) {
                    case SUBMIT: {
                        dismissType2 = OnSdkDismissedCallback.DismissType.SUBMIT;
                        break;
                    }
                    case CANCEL: {
                        dismissType2 = OnSdkDismissedCallback.DismissType.CANCEL;
                        break;
                    }
                    case ADD_ATTACHMENT: {
                        dismissType2 = OnSdkDismissedCallback.DismissType.ADD_ATTACHMENT;
                        break;
                    }
                    default: {
                        dismissType2 = OnSdkDismissedCallback.DismissType.CANCEL;
                    }
                }
                onSdkDismissedCallback.onSdkDismissed(dismissType2, type);
            }
        };
        InstabugBugReporting.setOnSdkDismissedCallback(onSdkDismissedCallback2);
    }

    public static void setOnSdkDismissedCallback(OnSdkDismissedCallback onSdkDismissedCallback) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("onSdkDismissedCallback").setType(OnSdkDismissedCallback.class)});
        a.a().a(onSdkDismissedCallback);
    }

    public static void setAttachmentTypesEnabled(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("initialScreenshot").setType(Boolean.class).setValue((Object)Boolean.toString(bl)), new Api.Parameter().setName("extraScreenshot").setType(Boolean.class).setValue((Object)Boolean.toString(bl2)), new Api.Parameter().setName("galleryImage").setType(Boolean.class).setValue((Object)Boolean.toString(bl3)), new Api.Parameter().setName("screenRecording").setType(Boolean.class).setValue((Object)Boolean.toString(bl4))});
        AttachmentsTypesParams attachmentsTypesParams = new AttachmentsTypesParams(bl, bl2, bl3, bl4);
        a.a().a(attachmentsTypesParams);
    }

    public static void setPreSendingRunnable(Runnable runnable) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("runnable").setType(Runnable.class)});
        a.a().a(runnable);
    }

    public static Runnable getPreSendingRunnable() {
        return b.b().h();
    }

    public static void setShouldSkipInitialScreenshotAnnotation(boolean bl) {
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("willSkipInitialScreenshotAnnotating").setType(Boolean.class).setValue((Object)Boolean.toString(bl))});
        a.a().b(bl);
    }

    public static void setEmailFieldRequired(boolean bl) {
        a.a().a(bl);
    }

    public static void setEmailFieldVisibility(boolean bl) {
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("emailFieldVisibility").setType(Boolean.class).setValue((Object)Boolean.toString(bl))});
        a.a().c(bl);
    }

    public static void setCommentFieldRequired(boolean bl) {
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("commentFieldRequired").setType(Boolean.class).setValue((Object)Boolean.toString(bl))});
        a.a().d(bl);
    }

    public static void setSuccessDialogEnabled(boolean bl) {
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("enabled").setType(Boolean.class).setValue((Object)Boolean.toString(bl))});
        a.a().e(bl);
    }

    public static void openNewFeedback() {
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        com.instabug.bug.a.c();
    }

    public static void openNewBugReport() {
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        com.instabug.bug.a.d();
    }

    public static void addExtraReportField(CharSequence charSequence, boolean bl) {
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("fieldHint").setType(CharSequence.class).setValue((Object)charSequence), new Api.Parameter().setName("required").setType(Boolean.TYPE).setValue((Object)bl)});
        a.a().a(charSequence, bl);
    }

    public static void clearExtraReportFields() {
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        a.a().o();
    }

    public static void setExtendedBugReportState(ExtendedBugReport.State state) {
        ExtendedBugReport.State state2;
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        switch (state) {
            case ENABLED_WITH_REQUIRED_FIELDS: {
                state2 = ExtendedBugReport.State.ENABLED_WITH_REQUIRED_FIELDS;
                break;
            }
            case ENABLED_WITH_OPTIONAL_FIELDS: {
                state2 = ExtendedBugReport.State.ENABLED_WITH_OPTIONAL_FIELDS;
                break;
            }
            default: {
                state2 = ExtendedBugReport.State.DISABLED;
            }
        }
        a.a().a(state2);
    }
}

