package com.instabug.chat.annotation.shape;

import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.PointF;

import androidx.annotation.ColorInt;

import com.instabug.chat.annotation.DirectionRectF;
import com.instabug.library.util.DrawingUtility;

/**
 * Created by Tarek360 on 11/24/16.
 */

public class OvalShape extends RectShape {

  public OvalShape(@ColorInt int color, float strokeWidth, int rotation) {
    super(color, strokeWidth, rotation);
  }

  @Override
  protected void draw(Canvas canvas, DirectionRectF bounds) {
    drawOval(canvas, bounds);
  }

  private void drawOval(Canvas canvas, DirectionRectF bounds) {
    canvas.drawPath(getPath(bounds), paint);
  }

  @Override public void drawBorder(Canvas canvas, PointF topLeftPoint, PointF topRightPoint,
                                   PointF bottomRightPoint, PointF bottomLeftPoint) {
    DrawingUtility.drawLine(canvas, topLeftPoint, topRightPoint, borderPaint);
    DrawingUtility.drawLine(canvas, topLeftPoint, bottomLeftPoint, borderPaint);
    DrawingUtility.drawLine(canvas, topRightPoint, bottomRightPoint, borderPaint);
    DrawingUtility.drawLine(canvas, bottomRightPoint, bottomLeftPoint, borderPaint);
  }

  @Override
  protected void preparePath(DirectionRectF bounds) {
    path.reset();
    if (rotation == 0 || rotation == 180) {
      path.addOval(bounds, Path.Direction.CW);
    } else {
      PointF midPoint_0_1 = DrawingUtility.getMidpoint(bounds.point0, bounds.point1);
      PointF midPoint_0_midPoint_0_1 = DrawingUtility.getMidpoint(bounds.point0, midPoint_0_1);
      PointF midPoint_1_midPoint_0_1 = DrawingUtility.getMidpoint(bounds.point1, midPoint_0_1);

      PointF midPoint_1_2 = DrawingUtility.getMidpoint(bounds.point1, bounds.point2);
      PointF midPoint_1_midPoint_1_2 = DrawingUtility.getMidpoint(bounds.point1, midPoint_1_2);
      PointF midPoint_2_midPoint_1_2 = DrawingUtility.getMidpoint(bounds.point2, midPoint_1_2);

      PointF midPoint_2_3 = DrawingUtility.getMidpoint(bounds.point2, bounds.point3);
      PointF midPoint_2_midPoint_2_3 = DrawingUtility.getMidpoint(bounds.point2, midPoint_2_3);
      PointF midPoint_3_midPoint_2_3 = DrawingUtility.getMidpoint(bounds.point3, midPoint_2_3);

      PointF midPoint_3_0 = DrawingUtility.getMidpoint(bounds.point3, bounds.point0);
      PointF midPoint_3_midPoint_3_0 = DrawingUtility.getMidpoint(bounds.point3, midPoint_3_0);
      PointF midPoint_0_midPoint_3_0 = DrawingUtility.getMidpoint(bounds.point0, midPoint_3_0);

//      path.reset();
      path.moveTo(midPoint_0_1.x, midPoint_0_1.y);
      path.cubicTo(midPoint_1_midPoint_0_1.x, midPoint_1_midPoint_0_1.y, midPoint_1_midPoint_1_2.x,
              midPoint_1_midPoint_1_2.y, midPoint_1_2.x, midPoint_1_2.y);
      path.cubicTo(midPoint_2_midPoint_1_2.x, midPoint_2_midPoint_1_2.y, midPoint_2_midPoint_2_3.x,
              midPoint_2_midPoint_2_3.y, midPoint_2_3.x, midPoint_2_3.y);
      path.cubicTo(midPoint_3_midPoint_2_3.x, midPoint_3_midPoint_2_3.y, midPoint_3_midPoint_3_0.x,
              midPoint_3_midPoint_3_0.y, midPoint_3_0.x, midPoint_3_0.y);
      path.cubicTo(midPoint_0_midPoint_3_0.x, midPoint_0_midPoint_3_0.y, midPoint_0_midPoint_0_1.x,
              midPoint_0_midPoint_0_1.y, midPoint_0_1.x, midPoint_0_1.y);
      path.close();

    }
  }
}
