package com.instabug.chat.cache;

import android.content.Context;

import com.instabug.chat.Constants;
import com.instabug.chat.model.Chat;
import com.instabug.chat.model.ReadMessage;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.internal.storage.cache.OnDiskCache;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;

public class CacheUtility {
    private static final String TAG = "CacheUtility";
    private static final String EXECUTOR_TAG = "chats-cache-executor";

    public static void prepareCache(final Context context) {
        PoolProvider.getSingleThreadExecutor(EXECUTOR_TAG).execute(new Runnable() {
            @Override
            public void run() {
                try {
                    OnDiskCache<Chat> chatsOnDiskCache = new OnDiskCache(context, ChatsCacheManager
                            .CHATS_DISK_CACHE_KEY, ChatsCacheManager.CHATS_DISK_CACHE_FILE_NAME, Chat.class);
                    CacheManager.getInstance().addCache(chatsOnDiskCache);
                    OnDiskCache<ReadMessage> readQueueDiskCache = new OnDiskCache(context, ReadQueueCacheManager
                            .READ_QUEUE_DISK_CACHE_KEY, ReadQueueCacheManager
                            .READ_QUEUE_DISK_CACHE_FILE_NAME, ReadMessage.class);
                    CacheManager.getInstance().addCache(readQueueDiskCache);
                } catch (Exception ex) {
                    InstabugSDKLogger.e(Constants.LOG_TAG, "failed to prepare chat cache due to " + ex.getMessage());
                }
            }
        });
    }

    public static void cleanupChats() {
        PoolProvider.getSingleThreadExecutor(EXECUTOR_TAG).execute(new Runnable() {
            @Override
            public void run() {
                try {
                    ChatsCacheManager.cleanupChats();
                } catch (Exception ex) {
                    InstabugSDKLogger.e(Constants.LOG_TAG, "failed to clean chat cache " + ex.getMessage());
                }
            }
        });
    }

    public static void dumpCache() {
        PoolProvider.getSingleThreadExecutor(EXECUTOR_TAG).execute(new Runnable() {
            @Override
            public void run() {
                try {
                    ChatsCacheManager.saveCacheToDisk();
                    ReadQueueCacheManager.saveCacheToDisk();
                } catch (Exception ex) {
                    InstabugSDKLogger.e(Constants.LOG_TAG, "failed to dump chat cache " + ex.getMessage());
                }
            }
        });
    }
}
