package com.instabug.bug.view.visualusersteps.steppreview

import android.os.Bundle

class VisualUserStepArgs(
    val title: String,
    val screenShotUri: String,
    val screenName: String
) {
    companion object {

        private const val KEY_TITLE = "title"
        private const val KEY_SCREEN_NAME = "screen_name"
        private const val KEY_SCREENSHOT_URI = "uri"

        @JvmStatic
        fun Bundle.argsFromBundle() = VisualUserStepArgs(
            title = getString(KEY_TITLE, ""),
            screenName = getString(KEY_SCREEN_NAME, ""),
            screenShotUri = getString(KEY_SCREENSHOT_URI, "")
        )


    }

    fun toBundle() = Bundle().apply {
        putString(KEY_TITLE, title)
        putString(KEY_SCREEN_NAME, screenName)
        putString(KEY_SCREENSHOT_URI, screenShotUri)
    }
}
