/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.chat.ui.chat;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.instabug.chat.ChatPlugin;
import com.instabug.chat.cache.ChatsCacheManager;
import com.instabug.chat.cache.ReadQueueCacheManager;
import com.instabug.chat.eventbus.ChatTriggeringEventBus;
import com.instabug.chat.eventbus.TriggeredChat;
import com.instabug.chat.model.Attachment;
import com.instabug.chat.model.Chat;
import com.instabug.chat.model.FlatMessage;
import com.instabug.chat.model.Message;
import com.instabug.chat.model.ReadMessage;
import com.instabug.chat.network.InstabugMessageUploaderJob;
import com.instabug.chat.notification.NotificationManager;
import com.instabug.chat.screenrecording.ExternalScreenRecordHelper;
import com.instabug.chat.screenshot.ScreenshotHelper;
import com.instabug.chat.settings.ChatSettings;
import com.instabug.chat.synchronization.NewMessagesHandler;
import com.instabug.chat.synchronization.OnNewMessagesReceivedListener;
import com.instabug.chat.synchronization.SynchronizationManager;
import com.instabug.chat.ui.chat.ChatContract$Presenter;
import com.instabug.chat.ui.chat.ChatContract$View;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.ui.BaseContract;
import com.instabug.library.core.ui.BasePresenter;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.internal.InstabugMediaProjectionIntent;
import com.instabug.library.internal.storage.AttachmentsUtility;
import com.instabug.library.internal.storage.cache.CacheChangedListener;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.internal.storage.cache.InMemoryCache;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.user.UserManagerWrapper;
import com.instabug.library.util.FileUtils;
import com.instabug.library.util.InstabugDateFormatter;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.VideoManipulationUtils;
import io.reactivexport.android.schedulers.AndroidSchedulers;
import io.reactivexport.disposables.Disposable;
import io.reactivexport.functions.Consumer;
import io.reactivexport.subjects.PublishSubject;
import java.io.File;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

@SuppressLint(value={"ERADICATE_FIELD_NOT_INITIALIZED"})
class ChatPresenter
extends BasePresenter<ChatContract$View>
implements ChatContract$Presenter,
CacheChangedListener<Chat>,
OnNewMessagesReceivedListener {
    private PublishSubject<String> chatCacheUpdatePublishSubject;
    private Disposable chatCacheUpdateDisposable;
    private Disposable chatTriggeringDisposable;
    private Chat chat;

    ChatPresenter(ChatContract$View chatContract$View) {
        super((BaseContract.View)chatContract$View);
    }

    private Attachment createOfflineAttachment() {
        Attachment attachment = new Attachment();
        attachment.setState("offline");
        return attachment;
    }

    private boolean isMediaProjectionEnabled() {
        return SettingsManager.getInstance().isScreenshotByMediaProjectionEnabled();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequiresApi(api=19)
    private void handleGalleryFileAbove21(ChatContract$View object, Intent object2) {
        Exception exception2;
        block11: {
            block10: {
                if (object.getViewContext() == null) return;
                if (((Fragment)object.getViewContext()).getContext() == null) return;
                Object object3 = AttachmentsUtility.getFileNameAndSize((Context)((Fragment)object.getViewContext()).getContext(), (Uri)object2.getData());
                if (object3 == null) return;
                String string2 = null;
                String string3 = "0";
                Object object4 = object3.first;
                String string4 = (String)object4;
                if (object4 != null) {
                    string2 = FileUtils.getExtension((String)string4);
                }
                if ((object3 = object3.second) != null) {
                    string3 = (String)object3;
                }
                if (string2 == null) {
                    InstabugSDKLogger.e((String)"IBG-BR", (String)"Selected file extension is null");
                    return;
                }
                if (FileUtils.isImageExtension((String)string2)) {
                    ((ChatPresenter)onNewMessagesReceivedListener).listen();
                    object = AttachmentsUtility.getFileFromContentProvider((Context)((Fragment)object.getViewContext()).getContext(), (Uri)object2.getData(), (String)string4);
                    if (object == null) return;
                    ChatPresenter chatPresenter = onNewMessagesReceivedListener;
                    chatPresenter.handleSentAttachment(chatPresenter.createImageAttachment(Uri.fromFile((File)object), "image_gallery"));
                    return;
                }
                if (!FileUtils.isVideoExtension((String)string2)) return;
                try {
                    if (Long.parseLong(string3) / 1024L / 1024L > 50L) {
                        object.showMediaFileSizeAlert();
                        InstabugSDKLogger.e((String)"IBG-BR", (String)"Selected video size exceeded the limit");
                        OnNewMessagesReceivedListener onNewMessagesReceivedListener = (ChatPlugin)InstabugCore.getXPlugin(ChatPlugin.class);
                        if (onNewMessagesReceivedListener == null) return;
                        onNewMessagesReceivedListener.setState(1);
                        return;
                    }
                    object2 = AttachmentsUtility.getFileFromContentProvider((Context)((Fragment)object.getViewContext()).getContext(), (Uri)object2.getData(), (String)string4);
                    if (object2 == null) break block10;
                    if (VideoManipulationUtils.extractVideoDuration((String)((File)object2).getPath()) > 60000L) {
                        object.showVideoLengthAlert();
                        InstabugSDKLogger.e((String)"IBG-BR", (String)"Selected video length exceeded the limit");
                        if (!((File)object2).delete()) return;
                        InstabugSDKLogger.v((String)"IBG-BR", (String)"file deleted");
                        return;
                    }
                }
                catch (Exception exception2) {
                    break block11;
                }
                OnNewMessagesReceivedListener onNewMessagesReceivedListener = onNewMessagesReceivedListener;
                ((ChatPresenter)onNewMessagesReceivedListener).listen();
                ((ChatPresenter)onNewMessagesReceivedListener).handleSentAttachment(((ChatPresenter)onNewMessagesReceivedListener).createVideoAttachment(Uri.fromFile((File)object2)));
                return;
            }
            InstabugSDKLogger.e((String)"IBG-BR", (String)"Selected video file was null");
            return;
        }
        InstabugSDKLogger.e((String)"IBG-BR", (String)"Error while selecting video from gallery", (Throwable)exception2);
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    private void handleGalleryFileBelow21(ChatContract$View chatContract$View, @NonNull Intent object) {
        if (chatContract$View.getViewContext() != null && ((Fragment)chatContract$View.getViewContext()).getActivity() != null) {
            String string2 = AttachmentsUtility.getGalleryImagePath((Activity)((Fragment)chatContract$View.getViewContext()).getActivity(), (Uri)object.getData());
            if (string2 == null && object.getData() != null) {
                string2 = object.getData().getPath();
            }
            object = FileUtils.getExtension((String)string2);
            Uri uri = AttachmentsUtility.getNewFileAttachmentUri((Context)((Fragment)chatContract$View.getViewContext()).getContext(), (Uri)Uri.fromFile((File)new File(string2)));
            if (uri == null) {
                return;
            }
            if (FileUtils.isImageExtension((String)object)) {
                ChatPresenter chatPresenter = this;
                this.listen();
                chatPresenter.handleSentAttachment(chatPresenter.createImageAttachment(uri, "image_gallery"));
            } else if (FileUtils.isVideoExtension((String)object)) {
                if (new File(string2).length() / 1024L / 1024L > 50L) {
                    chatContract$View.showMediaFileSizeAlert();
                } else if (VideoManipulationUtils.extractVideoDuration((String)string2) > 60000L) {
                    chatContract$View.showVideoLengthAlert();
                } else {
                    ChatPresenter chatPresenter = this;
                    this.listen();
                    chatPresenter.handleSentAttachment(chatPresenter.createVideoAttachment(uri));
                }
            }
            return;
        }
    }

    private void displayProperLeftTopIcon() {
        Object object = ((BasePresenter)object).view;
        if (object != null && (object = (ChatContract$View)((Reference)object).get()) != null) {
            if (ChatsCacheManager.getValidChats().size() > 0) {
                object.makeLeftTopButtonBackButton();
            } else {
                object.makeLeftTopButtonCloseButton();
            }
        }
    }

    private void handleAttachmentButtonVisibility() {
        Object object = ((BasePresenter)object).view;
        if (object != null && (object = (ChatContract$View)((Reference)object).get()) != null) {
            if (ChatSettings.isAttachmentsTypesEnabled()) {
                object.showAttachmentButton();
            } else {
                object.hideAttachmentButton();
            }
        }
    }

    private void handleChatCacheUpdate(String string2) {
        if (string2.equals(this.chat.getId())) {
            this.chatCacheUpdatePublishSubject.onNext((Object)string2);
        }
    }

    private void subscribeToChatsCacheUpdates() {
        this.chatCacheUpdatePublishSubject = PublishSubject.create();
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        this.chatCacheUpdateDisposable = this.chatCacheUpdatePublishSubject.debounce(300L, timeUnit).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<String>(){

            public void accept(String string2) {
                ChatPresenter.this.updateChatFromCache(string2);
            }
        });
    }

    private void subscribeToChatTriggeringEvents() {
        ChatPresenter chatPresenter = this;
        if (!chatPresenter.isSubscribed(chatPresenter.chatTriggeringDisposable)) {
            this.chatTriggeringDisposable = ChatTriggeringEventBus.getInstance().subscribe((Consumer)new Consumer<TriggeredChat>(){

                public void accept(TriggeredChat triggeredChat) {
                    if (ChatPresenter.this.chat.getId().equals(triggeredChat.getOldChatId())) {
                        ChatPresenter.this.chat.setId(triggeredChat.getNewChatId());
                    }
                }
            });
        }
    }

    private void unSubscribeFromChatTriggeringEvents() {
        ChatPresenter chatPresenter = this;
        if (chatPresenter.isSubscribed(chatPresenter.chatTriggeringDisposable)) {
            this.chatTriggeringDisposable.dispose();
        }
    }

    private void unSubscribeToChatsCacheUpdates() {
        ChatPresenter chatPresenter = this;
        if (chatPresenter.isSubscribed(chatPresenter.chatCacheUpdateDisposable)) {
            this.chatCacheUpdateDisposable.dispose();
        }
    }

    private boolean isSubscribed(Disposable disposable) {
        return disposable != null && !disposable.isDisposed();
    }

    private void updateChatFromCache(String object) {
        this.chat = object = this.getChatFromCache((String)object);
        if (object != null) {
            this.updateUI((Chat)object);
        }
    }

    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    private Chat getChatFromCache(String string2) {
        Object object;
        if (ChatsCacheManager.getCache() != null && ChatsCacheManager.getChat(string2) != null) {
            object = ChatsCacheManager.getChat(string2);
        } else {
            Chat chat;
            object = chat;
            chat = new Chat();
        }
        return object;
    }

    private void reversHangingChat() {
        if (this.chat.getChatState() == Chat.ChatState.WAITING_ATTACHMENT_MESSAGE) {
            this.chat.setChatState(Chat.ChatState.READY_TO_BE_SENT);
        }
    }

    private void addToReadQueue(List<Message> list) {
        for (int i = list.size() - 1; i >= 0; --i) {
            ReadMessage readMessage;
            if (list.get(i).isInbound() || list.get(i).isRead()) continue;
            ReadMessage readMessage2 = readMessage;
            readMessage2();
            readMessage2.setChatNumber(list.get(i).getChatId());
            readMessage.setMessageId(list.get(i).getId());
            readMessage.setReadAt(InstabugDateFormatter.getCurrentUTCTimeStampInSeconds());
            ReadQueueCacheManager.getInstance().add(readMessage2);
            break;
        }
    }

    private void updateUI(Chat chat) {
        ((ChatPresenter)object).addToReadQueue(chat.getMessages());
        Collections.sort(chat.getMessages(), new Message.Comparator());
        Object object = ((BasePresenter)object).view;
        if (object != null && (object = (ChatContract$View)((Reference)object).get()) != null) {
            Object object2 = object;
            object2.updateChatMessages(chat.getMessages());
            object2.notifyUIForUpdates();
        }
    }

    private void subscribeToChatsCache(CacheChangedListener<Chat> cacheChangedListener) {
        try {
            CacheManager.getInstance().subscribe("chats_memory_cache", cacheChangedListener);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            InstabugSDKLogger.e((String)"ChatPresenter", (String)"Couldn't subscribe to cache", (Throwable)illegalArgumentException);
            IBGDiagnostics.reportNonFatal((Throwable)illegalArgumentException, (String)"Couldn't subscribe to cache");
        }
    }

    @Override
    public void init(String string2) {
        ChatPresenter chatPresenter = this;
        chatPresenter.chat = chatPresenter.getChatFromCache(string2);
        chatPresenter.displayProperLeftTopIcon();
        chatPresenter.handleAttachmentButtonVisibility();
        chatPresenter.updateUI(chatPresenter.chat);
        chatPresenter.readChat(chatPresenter.chat);
        if (SynchronizationManager.getInstance() != null) {
            SynchronizationManager.getInstance().sync(false);
        }
    }

    @Override
    public void listen() {
        ChatPresenter chatPresenter = this;
        chatPresenter.reversHangingChat();
        chatPresenter.subscribeToChatsCacheUpdates();
        chatPresenter.subscribeToChatsCache(chatPresenter);
        NewMessagesHandler.getInstance().addOnNewMessagesReceivedListener(this);
        chatPresenter.subscribeToChatTriggeringEvents();
    }

    @Override
    public void sleep() {
        ChatPresenter chatPresenter = this;
        CacheManager.getInstance().unSubscribe("chats_memory_cache", (CacheChangedListener)this);
        NewMessagesHandler.getInstance().removeOnNewMessagesReceivedListener(this);
        chatPresenter.unSubscribeFromChatTriggeringEvents();
        chatPresenter.unSubscribeToChatsCacheUpdates();
    }

    @Override
    public List<FlatMessage> flattenMessages(List<Message> object) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        object = object.iterator();
        while (object.hasNext()) {
            Message message = (Message)object.next();
            if (message.getAttachments() != null && message.getAttachments().size() > 0) {
                for (Attachment attachment : message.getAttachments()) {
                    FlatMessage flatMessage = new FlatMessage().setBody(message.getBody()).setSenderAvatarUrl(message.getSenderAvatarUrl()).setMessagedAt(message.getMessagedAt()).setUrl(attachment.getUrl()).setPath(attachment.getLocalPath()).setInbound(message.isInbound());
                    if (attachment.getType() != null) {
                        String string2 = attachment.getType();
                        string2.hashCode();
                        int n = -1;
                        switch (string2.hashCode()) {
                            default: {
                                break;
                            }
                            case 1830389646: {
                                if (!string2.equals("video_gallery")) break;
                                n = 6;
                                break;
                            }
                            case 1710800780: {
                                if (!string2.equals("extra_video")) break;
                                n = 5;
                                break;
                            }
                            case 1698911340: {
                                if (!string2.equals("extra_image")) break;
                                n = 4;
                                break;
                            }
                            case 112202875: {
                                if (!string2.equals("video")) break;
                                n = 3;
                                break;
                            }
                            case 100313435: {
                                if (!string2.equals("image")) break;
                                n = 2;
                                break;
                            }
                            case 93166550: {
                                if (!string2.equals("audio")) break;
                                n = 1;
                                break;
                            }
                            case -831439762: {
                                if (!string2.equals("image_gallery")) break;
                                n = 0;
                            }
                        }
                        switch (n) {
                            default: {
                                break;
                            }
                            case 3: 
                            case 5: 
                            case 6: {
                                flatMessage.setType(FlatMessage.Type.VIDEO);
                                break;
                            }
                            case 1: {
                                FlatMessage flatMessage2 = flatMessage;
                                flatMessage2.setType(FlatMessage.Type.AUDIO);
                                flatMessage2.setMode(FlatMessage.Mode.NONE);
                                break;
                            }
                            case 0: 
                            case 2: 
                            case 4: {
                                flatMessage.setType(FlatMessage.Type.IMAGE);
                            }
                        }
                    }
                    arrayList2.add(flatMessage);
                }
            }
            if (!TextUtils.isEmpty((CharSequence)message.getBody())) {
                FlatMessage flatMessage;
                FlatMessage flatMessage3 = flatMessage;
                new FlatMessage().setBody(message.getBody()).setSenderAvatarUrl(message.getSenderAvatarUrl()).setMessagedAt(message.getMessagedAt()).setInbound(message.isInbound()).setType(FlatMessage.Type.MESSAGE);
                if (message.getActions() != null && message.getActions().size() > 0) {
                    flatMessage3.setMessageActions(message.getActions());
                }
                arrayList2.add(flatMessage3);
                continue;
            }
            if (message.isInbound() || message.getActions() == null || message.getActions().size() <= 0) continue;
            FlatMessage flatMessage = new FlatMessage();
            flatMessage.setBody(message.getBody()).setSenderAvatarUrl(message.getSenderAvatarUrl()).setMessagedAt(message.getMessagedAt()).setInbound(message.isInbound()).setType(FlatMessage.Type.MESSAGE);
            flatMessage.setMessageActions(message.getActions());
            arrayList2.add(flatMessage);
        }
        return arrayList2;
    }

    @Override
    public void sendMessage(Message object) {
        ChatPresenter chatPresenter = this;
        chatPresenter.chat.getMessages().add((Message)object);
        if (chatPresenter.chat.getState() == null) {
            ((ChatPresenter)this).chat.setChatState(Chat.ChatState.SENT);
        }
        if ((object = ChatsCacheManager.getCache()) != null) {
            InMemoryCache<String, Chat> inMemoryCache = object;
            ChatPresenter chatPresenter2 = this;
            object = chatPresenter2.chat.getId();
            inMemoryCache.put(object, (Object)chatPresenter2.chat);
            ChatsCacheManager.saveCacheToDisk();
        }
        if ((this = ((BasePresenter)this).view) != null && (this = (ChatContract$View)((Reference)this).get()) != null && ((Fragment)this.getViewContext()).getContext() != null) {
            InstabugMessageUploaderJob.getInstance().start();
        }
    }

    @Override
    public void handleSentAttachment(Attachment attachment) {
        if (attachment.getType() != null && attachment.getLocalPath() != null) {
            Object object = attachment.getType();
            int n = -1;
            switch (((String)object).hashCode()) {
                default: {
                    break;
                }
                case 1830389646: {
                    if (!((String)object).equals("video_gallery")) break;
                    n = 3;
                    break;
                }
                case 1710800780: {
                    if (!((String)object).equals("extra_video")) break;
                    n = 4;
                    break;
                }
                case 1698911340: {
                    if (!((String)object).equals("extra_image")) break;
                    n = 1;
                    break;
                }
                case 93166550: {
                    if (!((String)object).equals("audio")) break;
                    n = 2;
                    break;
                }
                case -831439762: {
                    if (!((String)object).equals("image_gallery")) break;
                    n = 0;
                }
            }
            if (n != 0 && n != 1) {
                ChatPresenter chatPresenter = chatPresenter;
                chatPresenter.sendMessage(chatPresenter.createAttachmentMessage(chatPresenter.chat.getId(), attachment));
            } else {
                object = chatPresenter.view;
                if (object != null) {
                    object = (ChatContract$View)((Reference)object).get();
                    if (ChatSettings.shouldSkipImageAttachmentAnnotation()) {
                        ChatPresenter chatPresenter = chatPresenter;
                        chatPresenter.sendMessage(chatPresenter.createAttachmentMessage(chatPresenter.chat.getId(), attachment));
                    } else if (object != null) {
                        ChatPresenter chatPresenter = Uri.fromFile((File)new File(attachment.getLocalPath()));
                        object.annotateAttachmentImage((Uri)chatPresenter, attachment.getType());
                    }
                }
            }
        }
    }

    @Override
    public Message createMessage(String string2, String string3) {
        Message message = new Message(UserManagerWrapper.getUserName(), UserManagerWrapper.getUserEmail(), InstabugCore.getPushNotificationToken());
        message.setChatId(string2).setBody(string3).setMessagedAt(InstabugDateFormatter.getCurrentUTCTimeStampInSeconds()).setReadAt(InstabugDateFormatter.getCurrentUTCTimeStampInSeconds()).setDirection(Message.Direction.INBOUND).setSenderName(InstabugCore.getIdentifiedUsername()).setMessageState(Message.MessageState.READY_TO_BE_SENT);
        return message;
    }

    @Override
    public Message createAttachmentMessage(String string2, Attachment attachment) {
        Message message = this.createMessage(string2, "");
        message.addAttachment(attachment);
        return message;
    }

    @Override
    public Attachment createImageAttachment(Uri uri, String string2) {
        Attachment attachment = this.createOfflineAttachment();
        attachment.setType(string2).setLocalPath(uri.getPath()).setName(uri.getLastPathSegment());
        return attachment;
    }

    public Attachment createVideoAttachment(Uri uri) {
        Attachment attachment = this.createOfflineAttachment();
        attachment.setType("video_gallery").setLocalPath(uri.getPath());
        attachment.setVideoEncoded(true);
        return attachment;
    }

    @Override
    public Chat getChat() {
        return this.chat;
    }

    public void readChat(Chat chat) {
        chat.markRead();
        if (ChatsCacheManager.getCache() != null) {
            ChatsCacheManager.getCache().put((Object)chat.getId(), (Object)chat);
        }
    }

    @Override
    public void attachScreenshot() {
        if (((ChatPresenter)((Object)chatContract$View)).isMediaProjectionEnabled()) {
            ChatContract$View chatContract$View = (ChatContract$View)((BasePresenter)chatContract$View).view.get();
            if (chatContract$View != null) {
                chatContract$View.requestMediaProjectionPermission();
            }
        } else {
            ((ChatPresenter)((Object)chatContract$View)).startScreenshotHelper();
        }
    }

    public void startScreenshotHelper() {
        SettingsManager.getInstance().setProcessingForeground(false);
        ChatPlugin chatPlugin = (ChatPlugin)InstabugCore.getXPlugin(ChatPlugin.class);
        if (chatPlugin != null && chatPlugin.getAppContext() != null && ((ChatPresenter)object).chat != null) {
            ChatPresenter chatPresenter = object;
            InstabugSDKLogger.v((String)"IBG-BR", (String)"taking extra screenshot");
            chatPlugin.setState(2);
            chatPresenter.chat.setChatState(Chat.ChatState.WAITING_ATTACHMENT_MESSAGE);
            ScreenshotHelper.getInstance().startScreenshotCapturing(chatPlugin.getAppContext(), ((ChatPresenter)object).chat.getId());
            Object object = chatPresenter.view;
            if (object != null && (object = (ChatContract$View)((Reference)object).get()) != null) {
                object.finishActivity();
            }
        }
    }

    @Override
    public void startImageFromGalleryPicker() {
        ChatPlugin chatPlugin = (ChatPlugin)InstabugCore.getXPlugin(ChatPlugin.class);
        if (chatPlugin != null && chatPlugin.getAppContext() != null && ((ChatPresenter)((Object)chatContract$View)).chat != null) {
            ChatPresenter chatPresenter = chatContract$View;
            InstabugSDKLogger.v((String)"IBG-BR", (String)"picking image from gallery");
            chatPlugin.setState(2);
            chatPresenter.chat.setChatState(Chat.ChatState.WAITING_ATTACHMENT_MESSAGE);
            ChatContract$View chatContract$View = (ChatContract$View)chatPresenter.view.get();
            if (chatContract$View != null) {
                chatContract$View.pickImageFromGallery();
            }
        }
    }

    @Override
    public void cleanOfflineChats() {
        InMemoryCache<String, Chat> inMemoryCache = this.chat;
        if (inMemoryCache != null && inMemoryCache.getMessages().size() == 0 && this.chat.getChatState() != Chat.ChatState.WAITING_ATTACHMENT_MESSAGE && (inMemoryCache = ChatsCacheManager.getCache()) != null) {
            inMemoryCache.delete((Object)this.chat.getId());
        }
    }

    @Override
    public void openVideoRecorder(Intent object) {
        Object object2 = this.view;
        if (object2 != null) {
            ChatPlugin chatPlugin;
            object2 = (ChatContract$View)((Reference)object2).get();
            ExternalScreenRecordHelper.getInstance().start(this.chat.getId());
            this.chat.setChatState(Chat.ChatState.WAITING_ATTACHMENT_MESSAGE);
            if (object2 != null) {
                object2.finishActivity();
            }
            if ((chatPlugin = (ChatPlugin)InstabugCore.getXPlugin(ChatPlugin.class)) != null) {
                chatPlugin.setState(2);
            }
        }
    }

    @Override
    public void onActivityResult(int n, int n2, Intent intent) {
        ChatContract$View chatContract$View = (ChatContract$View)((BasePresenter)this).view.get();
        if (chatContract$View != null) {
            FragmentActivity fragmentActivity = ((Fragment)chatContract$View.getViewContext()).getActivity();
            if (n != 161) {
                if (n != 2030) {
                    if (n == 3890 && n2 == -1 && intent != null) {
                        InstabugMediaProjectionIntent.setMediaProjectionIntent((Intent)intent);
                        ((ChatPresenter)this).openVideoRecorder(intent);
                    }
                } else if (intent != null && intent.getBooleanExtra("isPermissionGranted", false)) {
                    ((ChatPresenter)this).startScreenshotHelper();
                }
            } else {
                if (n2 == -1 && intent != null && intent.getData() != null && fragmentActivity != null) {
                    if (Build.VERSION.SDK_INT >= 21) {
                        super.handleGalleryFileAbove21(chatContract$View, intent);
                    } else {
                        super.handleGalleryFileBelow21(chatContract$View, intent);
                    }
                }
                if ((this = (ChatPlugin)InstabugCore.getXPlugin(ChatPlugin.class)) != null) {
                    this.setState(1);
                }
            }
        }
    }

    @Override
    public List<Message> onNewMessagesReceived(@NonNull List<Message> list) {
        Object object = this.view;
        if (object != null && (object = (ChatContract$View)((Reference)object).get()) != null && ((Fragment)object.getViewContext()).getActivity() != null) {
            for (Message message : list) {
                if (message.getChatId() == null || !message.getChatId().equals(this.chat.getId())) continue;
                ChatPresenter chatPresenter = this;
                list.remove(message);
                NotificationManager.getInstance().playNotificationSound((Context)((Fragment)object.getViewContext()).getActivity());
                chatPresenter.readChat(chatPresenter.chat);
            }
            return list;
        }
        return list;
    }

    public void onCachedItemRemoved(Chat chat) {
        this.handleChatCacheUpdate(chat.getId());
    }

    public void onCachedItemAdded(Chat chat) {
        this.handleChatCacheUpdate(chat.getId());
    }

    public void onCachedItemUpdated(Chat chat, Chat chat2) {
        this.handleChatCacheUpdate(chat2.getId());
    }

    public void onCacheInvalidated() {
        InstabugSDKLogger.d((String)"IBG-BR", (String)("Chats cache was invalidated, Time: " + System.currentTimeMillis()));
    }
}

