/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.chat.annotation.shape;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import androidx.annotation.Nullable;
import com.instabug.chat.annotation.ControlButton;
import com.instabug.chat.annotation.DirectionRectF;
import com.instabug.chat.annotation.shape.CroppedRectShape;
import com.instabug.chat.annotation.utility.BitmapUtility;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.DrawingUtility;

public class BlurredRectShape
extends CroppedRectShape {
    private final Context context;

    public BlurredRectShape(@Nullable Bitmap bitmap, Context context) {
        super(-65536);
        this.context = context;
        if (bitmap != null) {
            this.background = BitmapUtility.blur(bitmap, 18, context);
            this.setRecognized(true);
        }
    }

    public void setBackground(@Nullable Bitmap bitmap) {
        if (bitmap != null) {
            this.background = BitmapUtility.blur(bitmap, 18, this.context);
        }
    }

    @Override
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public void drawCroppedRect(Canvas canvas, Bitmap bitmap, float f, float f2) {
        canvas.drawBitmap(bitmap, f, f2, null);
    }

    @Override
    public void adjustBounds(DirectionRectF directionRectF, DirectionRectF directionRectF2, boolean bl) {
        directionRectF2.set(directionRectF);
    }

    @Override
    public void drawControlButtons(Canvas canvas, DirectionRectF directionRectF, ControlButton[] controlButtonArray) {
        PointF[] pointFArray = directionRectF.getCornersPoints();
        for (int i = 0; i < controlButtonArray.length; ++i) {
            controlButtonArray[i].setCenterPoint(pointFArray[i]);
            controlButtonArray[i].setColor(SettingsManager.getInstance().getPrimaryColor());
            controlButtonArray[i].draw(canvas);
        }
    }

    @Override
    public void drawBorder(Canvas canvas, PointF pointF, PointF pointF2, PointF pointF3, PointF pointF4) {
        BlurredRectShape blurredRectShape = blurredRectShape4;
        BlurredRectShape blurredRectShape2 = blurredRectShape4;
        BlurredRectShape blurredRectShape3 = blurredRectShape4;
        BlurredRectShape blurredRectShape4 = blurredRectShape4.borderPaint;
        DrawingUtility.drawLine((Canvas)canvas, (PointF)pointF, (PointF)pointF2, (Paint)blurredRectShape4);
        blurredRectShape4 = blurredRectShape3.borderPaint;
        DrawingUtility.drawLine((Canvas)canvas, (PointF)pointF, (PointF)pointF4, (Paint)blurredRectShape4);
        blurredRectShape4 = blurredRectShape2.borderPaint;
        DrawingUtility.drawLine((Canvas)canvas, (PointF)pointF2, (PointF)pointF3, (Paint)blurredRectShape4);
        blurredRectShape4 = blurredRectShape.borderPaint;
        DrawingUtility.drawLine((Canvas)canvas, (PointF)pointF3, (PointF)pointF4, (Paint)blurredRectShape4);
    }

    @Override
    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    public Path getPath(DirectionRectF directionRectF) {
        return null;
    }
}

