/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.chat.annotation.shape;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.Region;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import com.instabug.chat.annotation.ControlButton;
import com.instabug.chat.annotation.DirectionRectF;
import com.instabug.chat.annotation.shape.Shape;
import com.instabug.library.util.DrawingUtility;

public class ArrowShape
extends Shape {
    private final Paint paint;
    private PointF tailPoint;
    private PointF headPoint;
    private float recognitionAngle;
    @Nullable
    private String type;

    public ArrowShape(PointF pointF, PointF pointF2, @ColorInt int n, float f) {
        Paint paint;
        PointF pointF3 = pointF;
        super(n, f);
        PointF pointF4 = pointF = paint;
        PointF pointF5 = pointF;
        super(1);
        this.paint = pointF5;
        pointF4.setColor(n);
        pointF4.setStyle(Paint.Style.STROKE);
        paint.setStrokeWidth(f);
        this.tailPoint = pointF3;
        this.headPoint = pointF2;
    }

    private void reBound(DirectionRectF directionRectF) {
        float f;
        float f2;
        float f3;
        float f4;
        PointF pointF = arrowShape.tailPoint;
        float f5 = pointF.x;
        ArrowShape arrowShape = arrowShape.headPoint;
        float f6 = ((PointF)arrowShape).x;
        if (f4 < f3) {
            DirectionRectF directionRectF2 = directionRectF;
            directionRectF.left = f5;
            directionRectF2.right = f6;
            directionRectF2.firstX = DirectionRectF.X.LEFT;
            directionRectF2.secondX = DirectionRectF.X.RIGHT;
        } else {
            DirectionRectF directionRectF3 = directionRectF;
            directionRectF.right = f5;
            directionRectF3.left = f6;
            directionRectF3.firstX = DirectionRectF.X.RIGHT;
            directionRectF3.secondX = DirectionRectF.X.LEFT;
        }
        float f7 = pointF.y;
        float f8 = ((PointF)arrowShape).y;
        if (f2 < f) {
            DirectionRectF directionRectF4 = directionRectF;
            directionRectF.top = f7;
            directionRectF4.bottom = f8;
            directionRectF4.firstY = DirectionRectF.Y.TOP;
            directionRectF4.secondY = DirectionRectF.Y.BOTTOM;
        } else {
            DirectionRectF directionRectF5 = directionRectF;
            directionRectF.bottom = f7;
            directionRectF5.top = f8;
            directionRectF5.firstY = DirectionRectF.Y.BOTTOM;
            directionRectF5.secondY = DirectionRectF.Y.TOP;
        }
    }

    public void setType(@Nullable String string2) {
        this.type = string2;
    }

    @Override
    public void draw(Canvas canvas, DirectionRectF directionRectF, DirectionRectF object) {
        object = directionRectF.firstX;
        DirectionRectF.X x = DirectionRectF.X.RIGHT;
        if (object == x) {
            arrowShape2.tailPoint.x = directionRectF.right;
        } else if (object == DirectionRectF.X.LEFT) {
            arrowShape2.tailPoint.x = directionRectF.left;
        }
        object = directionRectF.firstY;
        DirectionRectF.Y y = DirectionRectF.Y.TOP;
        if (object == y) {
            arrowShape2.tailPoint.y = directionRectF.top;
        } else if (object == DirectionRectF.Y.BOTTOM) {
            arrowShape2.tailPoint.y = directionRectF.bottom;
        }
        object = directionRectF.secondX;
        if (object == x) {
            arrowShape2.headPoint.x = directionRectF.right;
        } else if (object == DirectionRectF.X.LEFT) {
            arrowShape2.headPoint.x = directionRectF.left;
        }
        object = directionRectF.secondY;
        if (object == y) {
            arrowShape2.headPoint.y = directionRectF.top;
        } else if (object == DirectionRectF.Y.BOTTOM) {
            arrowShape2.headPoint.y = directionRectF.bottom;
        }
        ArrowShape arrowShape = arrowShape2;
        ArrowShape arrowShape2 = arrowShape.getPath(directionRectF);
        canvas.drawPath((Path)arrowShape2, arrowShape.paint);
    }

    @Override
    public boolean isTouched(PointF pointF, DirectionRectF directionRectF) {
        Path path;
        Path path2;
        RectF rectF;
        ArrowShape arrowShape = this;
        arrowShape.reBound(directionRectF);
        directionRectF = arrowShape.headPoint;
        float f = ((PointF)directionRectF).y;
        PointF pointF2 = this.tailPoint;
        f = pointF2.x;
        float f2 = DrawingUtility.getRotationDegrees((float)((PointF)directionRectF).x, (float)f, (float)f, (float)pointF2.y);
        float f3 = f2 + 90.0f;
        PointF pointF3 = this.tailPoint;
        pointF3 = DrawingUtility.pointOnCircle((float)60.0f, (float)f3, (PointF)pointF3);
        float f4 = f2 + 270.0f;
        PointF pointF4 = arrowShape.tailPoint;
        pointF4 = DrawingUtility.pointOnCircle((float)60.0f, (float)f4, (PointF)pointF4);
        PointF pointF5 = arrowShape.headPoint;
        PointF pointF6 = DrawingUtility.pointOnCircle((float)60.0f, (float)f4, (PointF)pointF5);
        pointF5 = arrowShape.headPoint;
        PointF pointF7 = DrawingUtility.pointOnCircle((float)60.0f, (float)f3, (PointF)pointF5);
        Region region = new Region();
        pointF5 = rectF;
        rectF = new RectF();
        Path path3 = path2 = path;
        PointF pointF8 = pointF7;
        PointF pointF9 = pointF6;
        PointF pointF10 = pointF4;
        PointF pointF11 = pointF3;
        path2();
        float f5 = pointF11.x;
        path2.moveTo(f5, pointF11.y);
        f5 = pointF10.x;
        path2.lineTo(f5, pointF10.y);
        f5 = pointF9.x;
        path2.lineTo(f5, pointF9.y);
        f5 = pointF8.x;
        path3.lineTo(f5, pointF8.y);
        path3.close();
        path.computeBounds((RectF)pointF5, true);
        PointF pointF12 = pointF5;
        int n = (int)pointF12.top;
        int n2 = (int)pointF12.right;
        int n3 = (int)pointF12.bottom;
        region.setPath(path, new Region((int)pointF5.left, n, n2, n3));
        return region.contains((int)pointF.x, (int)pointF.y);
    }

    @Override
    public void adjustBounds(DirectionRectF directionRectF, DirectionRectF directionRectF2, boolean bl) {
        directionRectF2.set(directionRectF);
    }

    public void adjustTailPoint(float f, float f2, DirectionRectF directionRectF) {
        this.tailPoint.set(f, f2);
        this.reBound(directionRectF);
    }

    public void adjustHeadPoint(float f, float f2, DirectionRectF directionRectF) {
        this.headPoint.set(f, f2);
        this.reBound(directionRectF);
    }

    @Override
    public void drawControlButtons(Canvas canvas, DirectionRectF directionRectF, ControlButton[] controlButtonArray) {
        int n = this.paint.getColor();
        controlButtonArray[0].setCenterPoint(this.tailPoint);
        controlButtonArray[1].setCenterPoint(this.headPoint);
        for (int i = 0; i < 2; ++i) {
            controlButtonArray[i].setColor(n);
            controlButtonArray[i].draw(canvas);
        }
    }

    @Override
    public void drawBorder(Canvas canvas, PointF pointF, PointF pointF2, PointF pointF3, PointF pointF4) {
    }

    @Override
    public void translateBy(DirectionRectF directionRectF, DirectionRectF directionRectF2, int n, int n2) {
        float f = n;
        directionRectF.left = directionRectF2.left + f;
        float f2 = n2;
        directionRectF.top = directionRectF2.top + f2;
        directionRectF.right = directionRectF2.right + f;
        directionRectF.bottom = directionRectF2.bottom + f2;
    }

    @Override
    public Path getPath(DirectionRectF directionRectF) {
        Path path;
        directionRectF = path;
        ArrowShape arrowShape = this;
        directionRectF();
        PointF pointF = arrowShape.headPoint;
        float f = pointF.y;
        PointF pointF2 = this.tailPoint;
        f = pointF2.x;
        float f2 = DrawingUtility.getRotationDegrees((float)pointF.x, (float)f, (float)f, (float)pointF2.y);
        f = f2 + 225.0f;
        PointF pointF3 = this.headPoint;
        PointF pointF4 = DrawingUtility.pointOnCircle((float)60.0f, (float)f, (PointF)pointF3);
        float f3 = f2 + 135.0f;
        PointF pointF5 = arrowShape.headPoint;
        PointF pointF6 = DrawingUtility.pointOnCircle((float)60.0f, (float)f3, (PointF)pointF5);
        PointF pointF7 = arrowShape.tailPoint;
        float f4 = pointF7.x;
        directionRectF.moveTo(f4, pointF7.y);
        PointF pointF8 = this.headPoint;
        path.lineTo(pointF8.x + 1.0f, pointF8.y + 1.0f);
        if ("arrow".equals(this.type)) {
            PointF pointF9 = pointF6;
            PointF pointF10 = pointF4;
            float f5 = pointF10.x;
            directionRectF.moveTo(f5, pointF10.y);
            PointF pointF11 = this.headPoint;
            f5 = pointF11.x;
            directionRectF.lineTo(f5, pointF11.y);
            f5 = pointF9.x;
            directionRectF.lineTo(f5, pointF9.y);
        }
        return directionRectF;
    }

    public void updateTailAndHead(DirectionRectF directionRectF) {
        PointF pointF;
        PointF pointF2;
        DirectionRectF directionRectF2 = directionRectF;
        float f = Math.max(directionRectF2.width(), directionRectF.height());
        float f2 = directionRectF2.centerX() - (f /= 2.0f);
        f = directionRectF2.centerX() + f;
        PointF pointF3 = pointF2;
        pointF2 = new PointF(f2, directionRectF.centerY());
        PointF pointF4 = pointF;
        pointF = new PointF(f, directionRectF.centerY());
        f = directionRectF.centerY();
        this.tailPoint = DrawingUtility.rotatePoint((float)directionRectF2.centerX(), (float)f, (float)this.recognitionAngle, (PointF)pointF3);
        float f3 = directionRectF.centerY();
        this.headPoint = DrawingUtility.rotatePoint((float)directionRectF.centerX(), (float)f3, (float)this.recognitionAngle, (PointF)pointF4);
    }

    public void setRecognitionAngle(int n) {
        this.recognitionAngle = n;
    }
}

