/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.view.visualusersteps.visitedscreens;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import androidx.annotation.Nullable;
import com.instabug.bug.di.ServiceLocator;
import com.instabug.bug.model.VisitedScreen;
import com.instabug.bug.view.visualusersteps.visitedscreens.VisualUserStepsListContract$View;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.ui.BaseContract;
import com.instabug.library.core.ui.BasePresenter;
import com.instabug.library.internal.storage.ProcessedBytes;
import com.instabug.library.internal.storage.operation.DeleteUriDiskOperation;
import com.instabug.library.internal.storage.operation.DiskOperation;
import com.instabug.library.internal.storage.operation.DiskOperationCallback;
import com.instabug.library.util.DiskUtils;
import com.instabug.library.util.FileUtils;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.visualusersteps.VisualUserStep;
import com.instabug.library.visualusersteps.VisualUserStepsHelper;
import io.reactivexport.Observable;
import io.reactivexport.android.schedulers.AndroidSchedulers;
import io.reactivexport.disposables.Disposable;
import io.reactivexport.schedulers.Schedulers;
import java.io.File;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

public class VisualUserStepsListPresenter
extends BasePresenter<VisualUserStepsListContract$View>
implements BaseContract.Presenter {
    private ArrayList<VisitedScreen> uniqueVisitedScreens;
    @Nullable
    private Disposable visitedScreenDisposable;

    public VisualUserStepsListPresenter(VisualUserStepsListContract$View visualUserStepsListContract$View) {
        super((BaseContract.View)visualUserStepsListContract$View);
        ArrayList arrayList;
        Object object = arrayList;
        arrayList = new ArrayList();
        v1.uniqueVisitedScreens = object;
    }

    private Observable<ArrayList<VisitedScreen>> visitedScreensObservable() {
        return Observable.fromCallable(this::fetchThumbnails);
    }

    @Nullable
    private String getPathOfScreenshotId(ArrayList<File> object, String object2) {
        String string2 = object2;
        Object object3 = string2.substring(0, FileUtils.getIndexOfExtension((String)string2));
        object = ((ArrayList)object).iterator();
        while (object.hasNext()) {
            object2 = (File)object.next();
            if (!((File)object2).getPath().contains((CharSequence)object3)) continue;
            return ((File)object2).getPath();
        }
        return null;
    }

    private /* synthetic */ void lambda$getVisualUserSteps$0(VisualUserStepsListContract$View visualUserStepsListContract$View, ArrayList arrayList) {
        VisualUserStepsListContract$View visualUserStepsListContract$View2 = visualUserStepsListContract$View;
        this.uniqueVisitedScreens = arrayList;
        visualUserStepsListContract$View2.dismissPreparingDialog();
        visualUserStepsListContract$View2.populateVisualUserSteps(arrayList);
    }

    public void getVisualUserSteps() {
        Object object = this.view;
        if (object != null) {
            if ((object = (VisualUserStepsListContract$View)((Reference)object).get()) != null && !this.uniqueVisitedScreens.isEmpty()) {
                object.populateVisualUserSteps(this.uniqueVisitedScreens);
                return;
            }
            if (object != null) {
                object.showPreparingDialog();
                TimeUnit timeUnit = TimeUnit.SECONDS;
                this.visitedScreenDisposable = this.visitedScreensObservable().subscribeOn(Schedulers.io()).delay(1L, timeUnit).observeOn(AndroidSchedulers.mainThread()).subscribe(arg_0 -> this.lambda$getVisualUserSteps$0((VisualUserStepsListContract$View)object, arg_0));
            }
        }
    }

    public ArrayList<VisitedScreen> fetchThumbnails() {
        ArrayList<VisitedScreen> arrayList;
        ArrayList<VisitedScreen> arrayList2 = arrayList;
        arrayList = new ArrayList<VisitedScreen>();
        int n = 1;
        Object object = VisualUserStepsHelper.fetchSteps();
        Serializable serializable = (File)ServiceLocator.getReproScreenshotsCacheDir().getCurrentSpanDirectory();
        if (serializable != null) {
            serializable = DiskUtils.listFilesInDirectory((File)serializable);
        } else {
            ArrayList arrayList3;
            serializable = arrayList3;
            arrayList3 = new ArrayList();
        }
        object = ((ArrayList)object).iterator();
        while (object.hasNext()) {
            VisitedScreen visitedScreen;
            BitmapFactory.Options options;
            ProcessedBytes processedBytes;
            String string2;
            VisualUserStep visualUserStep = (VisualUserStep)object.next();
            if (visualUserStep.getScreenshotId() == null || (string2 = this.getPathOfScreenshotId((ArrayList<File>)serializable, visualUserStep.getScreenshotId())) == null) continue;
            boolean bl = new File(string2).exists();
            if (!bl && visualUserStep.getScreenshotId() != null) {
                ++n;
            }
            if (visualUserStep.getScreenId() == null || visualUserStep.getScreenshotId() == null || !bl || !(processedBytes = InstabugCore.decryptOnTheFly((String)string2)).isProcessSuccessful()) continue;
            byte[] byArray = processedBytes.getFileBytes();
            processedBytes = options;
            new BitmapFactory.Options().inSampleSize = 2;
            processedBytes = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length, (BitmapFactory.Options)processedBytes);
            VisitedScreen visitedScreen2 = visitedScreen;
            String string3 = string2;
            VisualUserStep visualUserStep2 = visualUserStep;
            int n2 = n + 1;
            string2 = visualUserStep2.getScreenName();
            String string4 = visualUserStep2.getScreenshotId();
            String string5 = FileUtils.getPathWithDecryptedFlag((String)string3);
            visitedScreen = new VisitedScreen(n, string2, string4, string5, (Bitmap)processedBytes);
            arrayList2.add(visitedScreen2);
            n = n2;
        }
        return arrayList2;
    }

    public void deleteVisualUserStep(Context object, int n, VisitedScreen visitedScreen) {
        InstabugSDKLogger.v((String)"IBG-BR", (String)("Deleting visual user step, Screen name: " + visitedScreen));
        if (n >= 0 && this.uniqueVisitedScreens.size() > n) {
            VisualUserStepsHelper.removeScreenshotId((String)visitedScreen.getScreenshotId());
            this.uniqueVisitedScreens.remove(n);
            com.instabug.library.internal.storage.DiskUtils.with((Context)object).deleteOperation((DiskOperation)new DeleteUriDiskOperation(Uri.parse((String)visitedScreen.getScreenshotUri()))).executeAsync((DiskOperationCallback)new DiskOperationCallback<Boolean>(){

                public void onSuccess(Boolean bl) {
                    InstabugSDKLogger.v((String)"IBG-BR", (String)"Deleting visual user steps operation succeeded");
                }

                public void onFailure(Throwable throwable) {
                    InstabugSDKLogger.e((String)"IBG-BR", (String)("Deleting visual user steps operation failed due to: " + throwable.getMessage()));
                }
            });
            object = this.view;
            if (object != null && (object = (VisualUserStepsListContract$View)((Reference)object).get()) != null) {
                object.populateVisualUserSteps(this.uniqueVisitedScreens);
            }
        }
    }

    public void release() {
        Disposable disposable = this.visitedScreenDisposable;
        if (disposable != null && disposable.isDisposed()) {
            this.visitedScreenDisposable.dispose();
        }
        VisualUserStepsHelper.encryptExistingSteps();
    }
}

