/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.view.floatingactionbutton;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.Shape;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import com.instabug.bug.view.floatingactionbutton.FloatingActionButton;
import com.instabug.library.R;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.view.IconViewUtils;
import java.util.Locale;

public class MuteFloatingActionButton
extends FloatingActionButton {
    private boolean enable;

    public MuteFloatingActionButton(Context context) {
        this(context, null);
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public MuteFloatingActionButton(Context context, @Nullable AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    @Override
    void init(Context context, @Nullable AttributeSet attributeSet) {
        MuteFloatingActionButton muteFloatingActionButton = this;
        super.init(context, attributeSet);
        muteFloatingActionButton.setSize(1);
        muteFloatingActionButton.setId(R.id.instabug_video_mute_button);
        muteFloatingActionButton.setNextFocusForwardId(R.id.instabug_video_stop_button);
        muteFloatingActionButton.setText(IconViewUtils.getIconUnicode((int)1));
        muteFloatingActionButton.setGravity(17);
        muteFloatingActionButton.disable();
    }

    @Override
    public int getButtonContentDescription() {
        return this.enable ? R.string.ibg_screen_recording_unmute_btn_content_description : R.string.ibg_screen_recording_mute_btn_content_description;
    }

    @Override
    Drawable getIconDrawable() {
        Shape shape;
        MuteFloatingActionButton muteFloatingActionButton = this;
        final float f = muteFloatingActionButton.getDimension(R.dimen.instabug_fab_icon_size_mini);
        final float f2 = this.getDimension(R.dimen.instabug_fab_size_mini);
        final float f3 = f / 2.0f;
        final float f4 = muteFloatingActionButton.getDimension(R.dimen.instabug_fab_circle_icon_stroke);
        Shape shape2 = shape;
        shape = new Shape(){

            public void draw(Canvas canvas, Paint paint) {
                if (MuteFloatingActionButton.this.enable) {
                    Paint paint2 = paint;
                    paint2.setColor(-65536);
                    paint2.setStyle(Paint.Style.FILL_AND_STROKE);
                    paint.setStrokeWidth(f4);
                    float f5 = f3;
                    canvas.drawCircle(f5, f5, f2 / 2.0f, paint);
                } else {
                    1 v2 = this;
                    Paint paint3 = paint;
                    paint.setColor(-16777216);
                    paint3.setStrokeWidth(f4);
                    paint3.setStyle(Paint.Style.STROKE);
                    float f6 = f3;
                    canvas.drawCircle(f6, f6, f2 / 2.0f, paint);
                    paint.setColor(-16777216);
                    paint.setStrokeWidth(f4);
                    float f22 = v2.f4;
                    float f32 = v2.f;
                    float f42 = f32 + f22;
                    canvas.drawLine(0.0f, f22, f32, f42, paint);
                }
            }
        };
        ShapeDrawable shapeDrawable = new ShapeDrawable(shape2);
        shapeDrawable.getPaint().setAntiAlias(true);
        return shapeDrawable;
    }

    public boolean toggle() {
        if (this.enable) {
            this.disable();
        } else {
            this.enable();
        }
        return this.enable;
    }

    public void enable() {
        MuteFloatingActionButton muteFloatingActionButton = this;
        muteFloatingActionButton.enable = true;
        muteFloatingActionButton.updateBackground();
        muteFloatingActionButton.setTextColor(-1);
        int n = R.string.ibg_screen_recording_mute_btn_content_description;
        muteFloatingActionButton.setContentDescription(LocaleUtils.getLocaleStringResource((Locale)InstabugCore.getLocale((Context)muteFloatingActionButton.getContext()), (int)n, (Context)this.getContext()));
    }

    public void disable() {
        MuteFloatingActionButton muteFloatingActionButton = this;
        muteFloatingActionButton.enable = false;
        muteFloatingActionButton.updateBackground();
        muteFloatingActionButton.setTextColor(-16777216);
        int n = R.string.ibg_screen_recording_unmute_btn_content_description;
        muteFloatingActionButton.setContentDescription(LocaleUtils.getLocaleStringResource((Locale)InstabugCore.getLocale((Context)muteFloatingActionButton.getContext()), (int)n, (Context)this.getContext()));
    }
}

