/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.utils;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.instabug.library.util.InstabugSDKLogger;

public abstract class PermissionsUtils {
    public static String mediaStoragePermission() {
        if (Build.VERSION.SDK_INT == 33) {
            return "android.permission.READ_MEDIA_IMAGES";
        }
        return "android.permission.READ_EXTERNAL_STORAGE";
    }

    public static boolean isMediaStoragePermissionGranted(@Nullable Context context) {
        if (Build.VERSION.SDK_INT >= 16) {
            if (context == null) {
                return false;
            }
            return PermissionsUtils.isPermissionGranted(context, PermissionsUtils.mediaStoragePermission());
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isPermissionGranted(@NonNull Context context, @NonNull String charSequence) {
        block3: {
            String string2;
            String string3;
            boolean bl;
            try {
                if (Build.VERSION.SDK_INT < 23) break block3;
                bl = ContextCompat.checkSelfPermission((Context)context, (String)charSequence) == 0;
                string3 = "IBG-Core";
                charSequence = new StringBuilder().append(String.format("Permission %1$s ", charSequence)).append("state is ");
                string2 = bl ? "" : "NOT ";
            }
            catch (Exception exception) {
                return true;
            }
            InstabugSDKLogger.v((String)string3, (String)((StringBuilder)charSequence).append(string2).append("granted").toString());
            return bl;
        }
        boolean bl = context.checkCallingOrSelfPermission((String)charSequence) == 0;
        String string4 = "IBG-Core";
        charSequence = new StringBuilder().append(String.format("Permission %1$s ", charSequence)).append("state is ");
        String string5 = bl ? "" : "NOT ";
        InstabugSDKLogger.v((String)string4, (String)((StringBuilder)charSequence).append(string5).append("granted").toString());
        return bl;
    }

    public static void requestPermission(@NonNull Activity objectArray, @NonNull String string2, int n, @Nullable Runnable runnable, @Nullable Runnable runnable2) {
        if (!PermissionsUtils.isPermissionGranted((Context)objectArray, string2)) {
            if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)objectArray, (String)string2)) {
                PermissionsUtils.runIfValid(runnable);
            }
            Object[] objectArray2 = objectArray;
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = string2;
            InstabugSDKLogger.d((String)"IBG-Core", (String)(String.format("Permission %1$s ", objectArray) + "not granted, requesting it"));
            ActivityCompat.requestPermissions((Activity)objectArray2, (String[])new String[]{string2}, (int)n);
        } else {
            Object[] objectArray4 = new Object[1];
            objectArray = objectArray4;
            objectArray4[0] = string2;
            InstabugSDKLogger.d((String)"IBG-Core", (String)(String.format("Permission %1$s ", objectArray) + "already granted, running after permission granted runnable"));
            PermissionsUtils.runIfValid(runnable2);
        }
    }

    private static void runIfValid(@Nullable Runnable runnable) {
        if (runnable != null) {
            runnable.run();
        }
    }
}

