/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.settings;

import android.content.Context;
import android.text.Spanned;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.bug.extendedbugreport.ExtendedBugReport;
import com.instabug.bug.model.ExtraReportField;
import com.instabug.bug.model.ReportCategory;
import com.instabug.bug.settings.AttachmentsTypesParams;
import com.instabug.bug.settings.PerSessionSettings;
import com.instabug.bug.settings.PersistableSettings;
import com.instabug.library.Feature;
import com.instabug.library.OnSdkDismissCallback;
import com.instabug.library.internal.video.customencoding.VideoEncoderConfig;
import java.util.ArrayList;
import java.util.List;

public class BugSettings {
    @Nullable
    private static BugSettings settingsManager;

    private BugSettings() {
    }

    public static void init(Context context) {
        settingsManager = new BugSettings();
        PersistableSettings.init(context);
    }

    public static BugSettings getInstance() {
        if (settingsManager == null) {
            settingsManager = new BugSettings();
        }
        return settingsManager;
    }

    public static void setVideoEncoderConfig(@NonNull VideoEncoderConfig videoEncoderConfig) {
        PerSessionSettings.getInstance().setVideoEncoderConfig(videoEncoderConfig);
    }

    @Nullable
    public static VideoEncoderConfig getVideoEncoderConfig() {
        return PerSessionSettings.getInstance().getVideoEncoderConfig();
    }

    @Nullable
    public List<ReportCategory> getReportCategories() {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings == null) {
            return null;
        }
        return perSessionSettings.getReportCategories();
    }

    @Nullable
    public String getRemoteReportCategories() {
        PersistableSettings persistableSettings = PersistableSettings.getInstance();
        if (persistableSettings == null) {
            return null;
        }
        return persistableSettings.getRemoteReportCategories();
    }

    public void setRemoteReportCategories(@Nullable String string2) {
        PersistableSettings persistableSettings = PersistableSettings.getInstance();
        if (persistableSettings != null) {
            persistableSettings.setRemoteReportCategories(string2);
        }
    }

    public AttachmentsTypesParams getAttachmentsTypesParams() {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings == null) {
            return new AttachmentsTypesParams();
        }
        return perSessionSettings.getAttachmentsTypesParams();
    }

    public void setAttachmentsTypesParams(AttachmentsTypesParams attachmentsTypesParams) {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings != null) {
            perSessionSettings.setAttachmentsTypesParams(attachmentsTypesParams);
        }
    }

    public boolean isAddAttachmentsButtonEnable() {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings == null) {
            return true;
        }
        return perSessionSettings.getAttachmentsTypesParams().isAllowTakeExtraScreenshot() || perSessionSettings.getAttachmentsTypesParams().isAllowAttachImageFromGallery() || perSessionSettings.getAttachmentsTypesParams().isAllowScreenRecording();
    }

    public boolean isEmailFieldRequired() {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings == null) {
            return true;
        }
        return perSessionSettings.isEmailFieldRequired();
    }

    public void setEmailFieldRequired(boolean bl) {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings != null) {
            perSessionSettings.setEmailFieldRequired(bl);
        }
    }

    public boolean isEmailFieldVisible() {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings == null) {
            return true;
        }
        return perSessionSettings.isEmailFieldVisible();
    }

    @Nullable
    public OnSdkDismissCallback getOnSdkDismissCallback() {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings == null) {
            return null;
        }
        return perSessionSettings.getOnSdkDismissCallback();
    }

    public void setOnSdkDismissCallback(OnSdkDismissCallback onSdkDismissCallback) {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings != null) {
            perSessionSettings.setOnSdkDismissCallback(onSdkDismissCallback);
        }
    }

    public void setEmailFieldVisibility(boolean bl) {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings != null) {
            perSessionSettings.setEmailFieldVisibility(bl);
        }
    }

    public boolean isCommentFieldRequired() {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings == null) {
            return false;
        }
        return perSessionSettings.isCommentFieldRequired();
    }

    public void setCommentFieldRequired(boolean bl) {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings != null) {
            perSessionSettings.setCommentFieldRequired(bl);
        }
    }

    public long getLastBugTime() {
        PersistableSettings persistableSettings = PersistableSettings.getInstance();
        if (persistableSettings == null) {
            return 0L;
        }
        return persistableSettings.getLastBugTime();
    }

    public void setLastBugTime(long l) {
        PersistableSettings persistableSettings = PersistableSettings.getInstance();
        if (persistableSettings != null) {
            persistableSettings.setLastBugTime(l);
        }
    }

    public boolean successDialogEnabled() {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings == null) {
            return true;
        }
        return perSessionSettings.successDialogEnabled();
    }

    public void setSuccessDialogEnabled(boolean bl) {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings != null) {
            perSessionSettings.setSuccessDialogEnabled(bl);
        }
    }

    @Nullable
    public Spanned getDisclaimerText() {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings == null) {
            return null;
        }
        return perSessionSettings.getDisclaimerText();
    }

    public void setDisclaimerText(@Nullable Spanned spanned) {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings != null) {
            perSessionSettings.setDisclaimerText(spanned);
        }
    }

    public List<ExtraReportField> getExtraReportFields() {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings == null) {
            return new ArrayList<ExtraReportField>();
        }
        return perSessionSettings.getExtraReportFields();
    }

    public boolean isScreenshotRequired() {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings == null) {
            return false;
        }
        return perSessionSettings.isScreenshotRequired();
    }

    public void setScreenshotRequired(boolean bl) {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings != null) {
            perSessionSettings.setScreenshotRequired(bl);
        }
    }

    public ExtendedBugReport.State getExtendedBugReportState() {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings == null) {
            return ExtendedBugReport.State.DISABLED;
        }
        return perSessionSettings.getExtendedBugReportState();
    }

    public void setExtendedBugReportState(ExtendedBugReport.State state) {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings != null) {
            perSessionSettings.setExtendedBugReportState(state);
        }
    }

    public void setExtendedBugReportHints(@Nullable String string2, @Nullable String string3, @Nullable String string4) {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings != null) {
            perSessionSettings.setExtendedBugReportHints(string2, string3, string4);
        }
    }

    @Nullable
    public String getExtendedBugReportHint1() {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings != null) {
            return perSessionSettings.getExtendedBugReportHint1();
        }
        return null;
    }

    @Nullable
    public String getExtendedBugReportHint2() {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings != null) {
            return perSessionSettings.getExtendedBugReportHint2();
        }
        return null;
    }

    @Nullable
    public String getExtendedBugReportHint3() {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings != null) {
            return perSessionSettings.getExtendedBugReportHint3();
        }
        return null;
    }

    public long getReportCategoriesLastFetchedTime() {
        PersistableSettings persistableSettings = PersistableSettings.getInstance();
        if (persistableSettings != null) {
            return persistableSettings.getReportCategoriesLastFetchedTime();
        }
        return 0L;
    }

    public void setReportCategoriesLastFetchedTime(long l) {
        PersistableSettings persistableSettings = PersistableSettings.getInstance();
        if (persistableSettings != null) {
            persistableSettings.setReportCategoriesLastFetchedTime(l);
        }
    }

    public void setBugReportingState(Feature.State state) {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings != null) {
            perSessionSettings.setBugReportingState(state);
        }
    }

    public boolean isBugReportingStateEnabled() {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings == null) {
            return false;
        }
        return perSessionSettings.isBugReportingStateEnabled();
    }

    public void setReportTypeStatus(String string2, boolean bl) {
        if (PerSessionSettings.getInstance() != null) {
            PerSessionSettings.getInstance().setReportTypeStatus(string2, bl);
        }
    }

    public boolean getReportTypeStatus(String string2) {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings == null) {
            return false;
        }
        return perSessionSettings.getReportTypeStatus(string2);
    }

    public boolean isFirstRunAfterEncryptorUpdate() {
        if (PersistableSettings.getInstance() == null) {
            return true;
        }
        return PersistableSettings.getInstance().isFirstRunAfterEncryptorUpdate();
    }

    public void setFirstRunAfterEncryptorUpdate(boolean bl) {
        if (PersistableSettings.getInstance() != null) {
            PersistableSettings.getInstance().setFirstRunAfterEncryptorUpdate(bl);
        }
    }

    public void setReportTypeCommentMinCharLimit(String string2, int n) {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings != null) {
            perSessionSettings.setReportTypeCommentMinCharLimit(string2, n);
        }
    }

    public int getReportTypeCommentMinCharLimit(String string2) {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        return perSessionSettings != null ? perSessionSettings.getReportTypeMinCommentCharLimit(string2) : 0;
    }

    public void setWelcomeMessageState(int n) {
        PerSessionSettings.getInstance().setWelcomeScreenState(n);
    }

    public int getWelcomeMessageState() {
        int n = PerSessionSettings.getInstance().getWelcomeScreenState();
        if (n != 0) {
            if (n != 1) {
                return 2;
            }
            return 1;
        }
        return 0;
    }
}

