/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.reportingpromptitems;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import androidx.annotation.Nullable;
import com.instabug.bug.BugPlugin;
import com.instabug.bug.LiveBugManager;
import com.instabug.bug.model.ReportCategory;
import com.instabug.bug.screenshot.viewhierarchy.ActivityViewInspector;
import com.instabug.bug.settings.BugSettings;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.plugin.PluginPromptOption;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import com.instabug.library.util.memory.MemoryUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseReportingPromptItem {
    @SuppressLint(value={"NULL_DEREFERENCE"})
    static void callOnSdkInvoked() {
        if (InstabugCore.getOnSdkInvokedCallback() != null) {
            InstabugCore.getOnSdkInvokedCallback().onSdkInvoked();
        }
    }

    static void createReportWithInitialScreenshot(@Nullable Uri uri) {
        BugPlugin bugPlugin = (BugPlugin)InstabugCore.getXPlugin(BugPlugin.class);
        if (bugPlugin != null && bugPlugin.getAppContext() != null) {
            LiveBugManager.getInstance().createBug(bugPlugin.getAppContext());
        }
        if (uri != null && BugSettings.getInstance().getAttachmentsTypesParams().isShouldTakesInitialScreenshot() && LiveBugManager.getInstance().getBug() != null) {
            LiveBugManager.getInstance().getBug().setInitialScreenshotPath(uri.getPath());
        }
    }

    static void startViewHierarchyInspection() {
        Activity activity = InstabugInternalTrackingDelegate.getInstance().getTargetActivity();
        if (activity == null) {
            return;
        }
        if (LiveBugManager.getInstance().getBug() != null && LiveBugManager.getInstance().getBug().isRequiredViewHierarchy() && !MemoryUtils.isLowMemory((Context)activity)) {
            ActivityViewInspector.inspectActivityView(activity);
        }
    }

    protected ArrayList<PluginPromptOption> getSubOptions(String string2) {
        return this.getSubOptions(ReportCategory.getSubReportCategories(string2), null, string2);
    }

    @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
    protected ArrayList<PluginPromptOption> getSubOptions(@Nullable List<ReportCategory> list, @Nullable PluginPromptOption pluginPromptOption, String string2) {
        int n;
        ArrayList<PluginPromptOption> arrayList;
        ArrayList<PluginPromptOption> arrayList2 = arrayList;
        arrayList = new ArrayList<PluginPromptOption>();
        for (int i = 0; i < (n = list != null ? list.size() : 0); ++i) {
            arrayList2.add(this.getSubOption(list.get(i), pluginPromptOption, string2, i));
        }
        return arrayList2;
    }

    protected PluginPromptOption getSubOption(ReportCategory reportCategory, @Nullable PluginPromptOption pluginPromptOption, String string2, int n) {
        PluginPromptOption pluginPromptOption2;
        PluginPromptOption pluginPromptOption3;
        PluginPromptOption pluginPromptOption4 = pluginPromptOption3 = pluginPromptOption2;
        pluginPromptOption3();
        pluginPromptOption3.setOrder(n);
        pluginPromptOption3.setTitle(reportCategory.getLabel());
        pluginPromptOption4.setDescription(reportCategory.getDescription());
        pluginPromptOption4.setInitialScreenshotRequired(true);
        pluginPromptOption3.setParent(pluginPromptOption);
        pluginPromptOption2.setSubOptions(this.getSubOptions(reportCategory.getSubs(), pluginPromptOption3, string2));
        return pluginPromptOption2;
    }
}

