/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.proactivereporting.ui;

import android.content.Context;
import android.net.Uri;
import androidx.annotation.WorkerThread;
import androidx.appcompat.app.AppCompatActivity;
import com.instabug.bug.BugPlugin;
import com.instabug.bug.LiveBugManager;
import com.instabug.bug.R;
import com.instabug.bug.di.ServiceLocator;
import com.instabug.bug.model.Bug;
import com.instabug.bug.proactivereporting.ui.ProactiveReportingDialogActivityContract$View;
import com.instabug.library.core.InitialScreenshotHelper;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.ui.BaseContract;
import com.instabug.library.core.ui.BasePresenter;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.internal.video.MediaProjectionHelper;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.threading.PoolProvider;
import java.lang.ref.Reference;
import java.util.concurrent.ThreadPoolExecutor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0011\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J#\u0010\f\u001a\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000fJ!\u0010\u0011\u001a\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u000fJ\u0017\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0007H\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0017H\u0003\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001b\u0010\u001e\u001a\u0004\u0018\u00010\u00172\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010 \u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b \u0010\u000fJ\u000f\u0010!\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b!\u0010\u000fJ#\u0010\"\u001a\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0016\u00a2\u0006\u0004\b\"\u0010\rR\u0019\u0010\u0004\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010#\u001a\u0004\b$\u0010%R \u0010&\u001a\u00020\u00078\u0006X\u0087D\u00a2\u0006\u0012\n\u0004\b&\u0010'\u0012\u0004\b*\u0010\u000f\u001a\u0004\b(\u0010)R \u0010+\u001a\u00020\u00078\u0006X\u0087D\u00a2\u0006\u0012\n\u0004\b+\u0010'\u0012\u0004\b-\u0010\u000f\u001a\u0004\b,\u0010)R \u0010.\u001a\u00020\u00078\u0006X\u0087D\u00a2\u0006\u0012\n\u0004\b.\u0010'\u0012\u0004\b0\u0010\u000f\u001a\u0004\b/\u0010)R\u001c\u00103\u001a\n 2*\u0004\u0018\u000101018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00104\u00a8\u00065"}, d2={"Lcom/instabug/bug/proactivereporting/ui/ProactiveReportingDialogActivityPresenter;", "Lcom/instabug/library/core/ui/BasePresenter;", "Lcom/instabug/bug/proactivereporting/ui/ProactiveReportingDialogActivityContract$View;", "", "view", "<init>", "(Lcom/instabug/bug/proactivereporting/ui/ProactiveReportingDialogActivityContract$View;)V", "", "type", "", "id", "", "handleBugReportingInvocation", "(Ljava/lang/String;Ljava/lang/Long;)V", "callOnSdkInvoked", "()V", "takeInitialScreenshotIfNeeded", "createBug", "(Ljava/lang/String;J)V", "navigateToReportingActivityAndFinishActivity", "eventName", "logSdkEvent", "(Ljava/lang/String;)V", "", "state", "setBugPluginState", "(I)V", "", "isInitialScreenshotRequired", "()Z", "getTitleResId", "(Ljava/lang/String;)Ljava/lang/Integer;", "onDialogShown", "onNegativeButtonClicked", "onPositiveButtonClicked", "Lcom/instabug/bug/proactivereporting/ui/ProactiveReportingDialogActivityContract$View;", "getView", "()Lcom/instabug/bug/proactivereporting/ui/ProactiveReportingDialogActivityContract$View;", "SDK_EVENT_DIALOG_DISMISSED", "Ljava/lang/String;", "getSDK_EVENT_DIALOG_DISMISSED", "()Ljava/lang/String;", "getSDK_EVENT_DIALOG_DISMISSED$annotations", "SDK_EVENT_DIALOG_ACCEPTED", "getSDK_EVENT_DIALOG_ACCEPTED", "getSDK_EVENT_DIALOG_ACCEPTED$annotations", "SDK_EVENT_DIALOG_OPENED", "getSDK_EVENT_DIALOG_OPENED", "getSDK_EVENT_DIALOG_OPENED$annotations", "Ljava/util/concurrent/ThreadPoolExecutor;", "kotlin.jvm.PlatformType", "executor", "Ljava/util/concurrent/ThreadPoolExecutor;", "instabug-bug_defaultUiRelease"}, xi=48)
public final class ProactiveReportingDialogActivityPresenter
extends BasePresenter<ProactiveReportingDialogActivityContract$View>
implements BaseContract.Presenter {
    @Nullable
    private final ProactiveReportingDialogActivityContract$View view;
    @NotNull
    private final String SDK_EVENT_DIALOG_DISMISSED;
    @NotNull
    private final String SDK_EVENT_DIALOG_ACCEPTED;
    @NotNull
    private final String SDK_EVENT_DIALOG_OPENED;
    private final ThreadPoolExecutor executor;

    public ProactiveReportingDialogActivityPresenter(@Nullable ProactiveReportingDialogActivityContract$View proactiveReportingDialogActivityContract$View) {
        ProactiveReportingDialogActivityPresenter proactiveReportingDialogActivityPresenter = this;
        super((BaseContract.View)proactiveReportingDialogActivityContract$View);
        proactiveReportingDialogActivityPresenter.view = proactiveReportingDialogActivityContract$View;
        proactiveReportingDialogActivityPresenter.SDK_EVENT_DIALOG_DISMISSED = "proactive_bugs_modal_ignored";
        proactiveReportingDialogActivityPresenter.SDK_EVENT_DIALOG_ACCEPTED = "proactive_bugs_modal_reported";
        proactiveReportingDialogActivityPresenter.SDK_EVENT_DIALOG_OPENED = "proactive_bugs_modal_triggers";
        proactiveReportingDialogActivityPresenter.executor = PoolProvider.getInstance().getIOExecutor();
    }

    private final void handleBugReportingInvocation(String string2, Long l) {
        this.callOnSdkInvoked();
        long l2 = l != null ? l : 0L;
        this.createBug(string2, l2);
    }

    private final void callOnSdkInvoked() {
        ProactiveReportingDialogActivityPresenter proactiveReportingDialogActivityPresenter = InstabugCore.getOnSdkInvokedCallback();
        if (proactiveReportingDialogActivityPresenter != null) {
            proactiveReportingDialogActivityPresenter.onSdkInvoked();
        }
    }

    private final void takeInitialScreenshotIfNeeded() {
        if (this.isInitialScreenshotRequired()) {
            InitialScreenshotHelper.captureScreenshot((InitialScreenshotHelper.InitialScreenshotCapturingListener)new InitialScreenshotHelper.InitialScreenshotCapturingListener(this){
                final /* synthetic */ ProactiveReportingDialogActivityPresenter this$0;
                {
                    this.this$0 = proactiveReportingDialogActivityPresenter;
                }

                public void onScreenshotCapturedSuccessfully(@Nullable Uri object) {
                    Bug bug = LiveBugManager.getInstance().getBug();
                    if (bug != null) {
                        object = object != null ? object.getPath() : null;
                        bug.setInitialScreenshotPath((String)object);
                    }
                    ProactiveReportingDialogActivityPresenter.access$navigateToReportingActivityAndFinishActivity(this.this$0);
                }

                public void onScreenshotCapturingFailed(@Nullable Throwable throwable) {
                    ProactiveReportingDialogActivityPresenter.access$navigateToReportingActivityAndFinishActivity(this.this$0);
                }
            });
        } else {
            this.navigateToReportingActivityAndFinishActivity();
        }
    }

    private final void createBug(String object, long l) {
        Object object2 = (ProactiveReportingDialogActivityContract$View)((BasePresenter)this).view.get();
        if (object2 != null && (object2 = (AppCompatActivity)object2.getViewContext()) != null) {
            LiveBugManager.getInstance().createBug((Context)object2);
            object2 = LiveBugManager.getInstance().getBug();
            if (object2 != null) {
                ((Bug)object2).addCategory("Frustrating experience");
            }
            if (object != null && (object2 = LiveBugManager.getInstance().getBug()) != null) {
                ((Bug)object2).addCategory((String)object);
            }
            if ((object = LiveBugManager.getInstance().getBug()) != null) {
                ((Bug)object).setFrustratingExperienceInternalId(l);
            }
        }
        this.takeInitialScreenshotIfNeeded();
    }

    private final void navigateToReportingActivityAndFinishActivity() {
        PoolProvider.postMainThreadTask(() -> ProactiveReportingDialogActivityPresenter.navigateToReportingActivityAndFinishActivity$lambda$4(this));
    }

    @WorkerThread
    private final void logSdkEvent(String string2) {
        IBGDiagnostics.logEvent((String)string2);
    }

    @WorkerThread
    private final void setBugPluginState(int n) {
        Object object = InstabugCore.getXPlugin(BugPlugin.class);
        object = object instanceof BugPlugin ? (BugPlugin)((Object)object) : null;
        if (object != null) {
            object.setState(n);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isInitialScreenshotRequired() {
        boolean bl;
        if (SettingsManager.getInstance().isScreenshotByMediaProjectionEnabled()) {
            void var0_4;
            ProactiveReportingDialogActivityContract$View proactiveReportingDialogActivityContract$View = (ProactiveReportingDialogActivityContract$View)((BasePresenter)this).view.get();
            if (proactiveReportingDialogActivityContract$View != null) {
                AppCompatActivity appCompatActivity = (AppCompatActivity)proactiveReportingDialogActivityContract$View.getViewContext();
            } else {
                Object var0_3 = null;
            }
            bl = var0_4 != null && SettingsManager.isInitialScreenShotAllowed() && MediaProjectionHelper.INSTANCE.isMediaProjectionServiceAvailable((Context)var0_4);
        } else {
            bl = SettingsManager.isInitialScreenShotAllowed();
        }
        return bl;
    }

    private static final void onDialogShown$lambda$0(ProactiveReportingDialogActivityPresenter proactiveReportingDialogActivityPresenter) {
        ProactiveReportingDialogActivityPresenter proactiveReportingDialogActivityPresenter2 = proactiveReportingDialogActivityPresenter;
        Intrinsics.checkNotNullParameter((Object)((Object)proactiveReportingDialogActivityPresenter2), (String)"this$0");
        proactiveReportingDialogActivityPresenter2.logSdkEvent(proactiveReportingDialogActivityPresenter2.SDK_EVENT_DIALOG_OPENED);
        ServiceLocator.getProactiveReportingConfigProvider().setLastModalTime(System.currentTimeMillis());
        proactiveReportingDialogActivityPresenter2.setBugPluginState(1);
    }

    private static final void onNegativeButtonClicked$lambda$1(ProactiveReportingDialogActivityPresenter proactiveReportingDialogActivityPresenter) {
        ProactiveReportingDialogActivityPresenter proactiveReportingDialogActivityPresenter2 = proactiveReportingDialogActivityPresenter;
        Intrinsics.checkNotNullParameter((Object)((Object)proactiveReportingDialogActivityPresenter2), (String)"this$0");
        proactiveReportingDialogActivityPresenter2.logSdkEvent(proactiveReportingDialogActivityPresenter2.SDK_EVENT_DIALOG_DISMISSED);
        proactiveReportingDialogActivityPresenter2.setBugPluginState(0);
    }

    private static final void onPositiveButtonClicked$lambda$2(ProactiveReportingDialogActivityPresenter proactiveReportingDialogActivityPresenter, String string2, Long l) {
        ProactiveReportingDialogActivityPresenter proactiveReportingDialogActivityPresenter2 = proactiveReportingDialogActivityPresenter;
        Intrinsics.checkNotNullParameter((Object)((Object)proactiveReportingDialogActivityPresenter2), (String)"this$0");
        proactiveReportingDialogActivityPresenter2.logSdkEvent(proactiveReportingDialogActivityPresenter2.SDK_EVENT_DIALOG_ACCEPTED);
        proactiveReportingDialogActivityPresenter.handleBugReportingInvocation(string2, l);
    }

    private static final void navigateToReportingActivityAndFinishActivity$lambda$4(ProactiveReportingDialogActivityPresenter object) {
        ProactiveReportingDialogActivityPresenter proactiveReportingDialogActivityPresenter = object;
        Intrinsics.checkNotNullParameter((Object)((Object)proactiveReportingDialogActivityPresenter), (String)"this$0");
        Object object2 = ((BasePresenter)proactiveReportingDialogActivityPresenter).view;
        if (object2 != null && (object2 = (ProactiveReportingDialogActivityContract$View)((Reference)object2).get()) != null) {
            object2.navigateToBugReportingActivity();
        }
        if ((object = ((BasePresenter)object).view) != null && (object = (ProactiveReportingDialogActivityContract$View)((Reference)object).get()) != null) {
            object.finishActivity();
        }
    }

    public static final /* synthetic */ void access$navigateToReportingActivityAndFinishActivity(ProactiveReportingDialogActivityPresenter proactiveReportingDialogActivityPresenter) {
        proactiveReportingDialogActivityPresenter.navigateToReportingActivityAndFinishActivity();
    }

    @Nullable
    public Integer getTitleResId(@Nullable String string2) {
        return Intrinsics.areEqual((Object)string2, (Object)"Force restarts") ? Integer.valueOf(R.string.ib_frustrating_experience_force_restart_dialog_title) : null;
    }

    public void onDialogShown() {
        this.executor.execute(() -> ProactiveReportingDialogActivityPresenter.onDialogShown$lambda$0(this));
    }

    public void onNegativeButtonClicked() {
        ProactiveReportingDialogActivityPresenter proactiveReportingDialogActivityPresenter = object;
        proactiveReportingDialogActivityPresenter.executor.execute(() -> ProactiveReportingDialogActivityPresenter.onNegativeButtonClicked$lambda$1((ProactiveReportingDialogActivityPresenter)((Object)object)));
        Object object = ((BasePresenter)proactiveReportingDialogActivityPresenter).view;
        if (object != null && (object = (ProactiveReportingDialogActivityContract$View)((Reference)object).get()) != null) {
            object.finishActivity();
        }
    }

    public void onPositiveButtonClicked(@Nullable String string2, @Nullable Long l) {
        this.executor.execute(() -> ProactiveReportingDialogActivityPresenter.onPositiveButtonClicked$lambda$2(this, string2, l));
    }
}

