/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.model;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.bug.model.ExtraReportField;
import com.instabug.bug.screenrecording.ExternalAutoScreenRecordHelper;
import com.instabug.library.Feature;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.internal.storage.cache.Cacheable;
import com.instabug.library.model.Attachment;
import com.instabug.library.model.BaseReport;
import com.instabug.library.model.State;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.StringUtility;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

@SuppressLint(value={"ERADICATE_FIELD_NOT_INITIALIZED"})
public class Bug
extends BaseReport
implements Cacheable,
Serializable {
    @Nullable
    private String id;
    @Nullable
    private String temporaryServerToken;
    private String type;
    private String message;
    private List<Attachment> attachments;
    private BugState bugState;
    @Nullable
    private String viewHierarchy;
    private boolean requiredViewHierarchy;
    @Nullable
    private ViewHierarchyInspectionState viewHierarchyInspectionState;
    @Nullable
    private transient List<ExtraReportField> extraReportFields;
    private ArrayList<String> categories;
    @Nullable
    private String initialScreenshotPath;
    @Nullable
    private String attachmentsPath;
    @Nullable
    private Map<String, String> consentResponses;
    @Nullable
    private List<String> actionableConsents;
    private String connectionError;
    private long frustratingExperienceInternalId;
    @Nullable
    private String frustratingExperienceExternalId;

    public Bug() {
        this.bugState = BugState.NOT_AVAILABLE;
        this.type = "not-available";
    }

    public Bug(@NonNull String string2, @Nullable State state, @NonNull BugState bugState) {
        ArrayList arrayList;
        CopyOnWriteArrayList copyOnWriteArrayList;
        serializable.id = string2;
        serializable.state = state;
        serializable.bugState = bugState;
        serializable.type = "not-available";
        Serializable serializable = copyOnWriteArrayList;
        copyOnWriteArrayList = new CopyOnWriteArrayList();
        v1.attachments = serializable;
        serializable = arrayList;
        arrayList = new ArrayList();
        v1.categories = serializable;
    }

    @Nullable
    public String getAttachmentsPath() {
        return this.attachmentsPath;
    }

    public void setAttachmentsPath(@Nullable String string2) {
        this.attachmentsPath = string2;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public Bug setId(@Nullable String string2) {
        this.id = string2;
        return this;
    }

    @Nullable
    public String getTemporaryServerToken() {
        return this.temporaryServerToken;
    }

    public Bug setTemporaryServerToken(@Nullable String string2) {
        this.temporaryServerToken = string2;
        return this;
    }

    public void setInitialScreenshotPath(@Nullable String string2) {
        this.initialScreenshotPath = string2;
    }

    @Nullable
    public String getInitialScreenshotPath() {
        return this.initialScreenshotPath;
    }

    public String getType() {
        return this.type;
    }

    public Bug setType(String string2) {
        this.type = string2;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public Bug setMessage(String string2) {
        this.message = string2;
        return this;
    }

    public Bug addAttachment(Uri uri, Attachment.Type type) {
        return this.addAttachment(uri, type, false);
    }

    public Bug addAttachment(@Nullable Uri object, Attachment.Type type, boolean bl) {
        Attachment attachment;
        InstabugSDKLogger.v((String)"IBG-BR", (String)"Started adding attachments to bug");
        if (object == null) {
            InstabugSDKLogger.w((String)"IBG-BR", (String)"Adding attachment with a null Uri, ignored.");
            return this;
        }
        if (type == null) {
            InstabugSDKLogger.w((String)"IBG-BR", (String)"Adding attachment with a null Attachment.Type, ignored.");
            return this;
        }
        Uri uri = object;
        object = uri.getLastPathSegment();
        String string2 = uri.getPath();
        for (Attachment attachment2 : this.attachments) {
            if (attachment2.getType() != type || !Objects.equals(object, attachment2.getName()) || !Objects.equals(string2, attachment2.getLocalPath())) continue;
            InstabugSDKLogger.w((String)"IBG-BR", (String)"Adding duplicated attachment, ignored.");
            return this;
        }
        Attachment attachment3 = attachment;
        attachment = new Attachment();
        if (object != null) {
            attachment3.setName((String)object);
        }
        if (string2 != null) {
            attachment3.setLocalPath(string2);
        }
        Attachment attachment4 = attachment3;
        attachment4.setType(type);
        if (attachment4.getLocalPath() != null && attachment3.getLocalPath().contains("attachments")) {
            attachment3.setEncrypted(true);
        }
        if (type == Attachment.Type.VISUAL_USER_STEPS) {
            attachment3.setEncrypted(bl);
            InstabugSDKLogger.i((String)"IBG-BR", (String)"Adding  visual user steps attachments to bug");
        }
        Bug bug = this;
        bug.attachments.add(attachment3);
        return bug;
    }

    public synchronized List<Attachment> getAttachments() {
        return this.attachments;
    }

    public Bug setAttachments(List<Attachment> list) {
        CopyOnWriteArrayList<Attachment> copyOnWriteArrayList;
        Bug bug = serializable;
        Serializable serializable = copyOnWriteArrayList;
        copyOnWriteArrayList = new CopyOnWriteArrayList<Attachment>(list);
        bug.attachments = serializable;
        return bug;
    }

    public Bug setState(@Nullable State state) {
        this.state = state;
        return this;
    }

    public BugState getBugState() {
        return this.bugState;
    }

    public Bug setBugState(BugState bugState) {
        this.bugState = bugState;
        return this;
    }

    @Nullable
    public String getViewHierarchy() {
        return this.viewHierarchy;
    }

    public Bug setViewHierarchy(String string2) {
        this.viewHierarchy = string2;
        return this;
    }

    public ArrayList<String> getCategories() {
        return this.categories;
    }

    public void setCategories(ArrayList<String> arrayList) {
        this.categories = arrayList;
    }

    @Nullable
    public String getConnectionError() {
        return this.connectionError;
    }

    public void setConnectionError(String string2) {
        this.connectionError = string2;
    }

    @Nullable
    public List<String> getActionableConsents() {
        return this.actionableConsents;
    }

    public void setActionableConsents(@Nullable List<String> list) {
        this.actionableConsents = list;
    }

    public long getFrustratingExperienceInternalId() {
        return this.frustratingExperienceInternalId;
    }

    public void setFrustratingExperienceInternalId(long l) {
        this.frustratingExperienceInternalId = l;
    }

    @Nullable
    public String getFrustratingExperienceExternalId() {
        return this.frustratingExperienceExternalId;
    }

    public void setFrustratingExperienceExternalId(@Nullable String string2) {
        this.frustratingExperienceExternalId = string2;
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public String toJson() {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        jSONObject2();
        long l = this.getFrustratingExperienceInternalId();
        jSONObject.put("id", (Object)this.getId()).put("temporary_server_token", (Object)this.getTemporaryServerToken()).put("type", (Object)this.getType().toString()).put("message", (Object)this.getMessage()).put("bug_state", (Object)((Object)((Object)this.getBugState())).toString()).put("attachments", (Object)Attachment.toJson(this.getAttachments())).put("view_hierarchy", (Object)this.getViewHierarchy()).put("categories_list", (Object)this.getCategoriesAsJSONArray()).put("actionable_consents", (Object)this.getActionableConsentsAsJsonArray()).put("frustrating_experience_internal_id", l).put("frustrating_experience_external_id", (Object)this.getFrustratingExperienceExternalId());
        if (this.getState() != null) {
            jSONObject2.put("state", (Object)this.getState().toJson());
        }
        if (this.getConnectionError() != null) {
            jSONObject2.put("connection_error", (Object)this.connectionError);
        }
        return jSONObject2.toString();
    }

    @SuppressLint(value={"NULL_DEREFERENCE"})
    public void fromJson(String string2) {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        jSONObject = new JSONObject(string2);
        if (jSONObject2.has("id")) {
            this.setId(jSONObject2.getString("id"));
        }
        if (jSONObject2.has("temporary_server_token")) {
            this.setTemporaryServerToken(jSONObject2.getString("temporary_server_token"));
        }
        if (jSONObject2.has("type")) {
            string2 = jSONObject2.getString("type");
            string2.hashCode();
            int n = -1;
            switch (string2.hashCode()) {
                default: {
                    break;
                }
                case 1621082316: {
                    if (!string2.equals("ask a question")) break;
                    n = 3;
                    break;
                }
                case 97908: {
                    if (!string2.equals("bug")) break;
                    n = 2;
                    break;
                }
                case -191501435: {
                    if (!string2.equals("feedback")) break;
                    n = 1;
                    break;
                }
                case -1562738717: {
                    if (!string2.equals("Frustrating experience")) break;
                    n = 0;
                }
            }
            switch (n) {
                default: {
                    string2 = "not-available";
                    break;
                }
                case 3: {
                    string2 = "ask a question";
                    break;
                }
                case 2: {
                    string2 = "bug";
                    break;
                }
                case 1: {
                    string2 = "feedback";
                    break;
                }
                case 0: {
                    string2 = "Frustrating experience";
                }
            }
            this.setType(string2);
        }
        if (jSONObject2.has("message")) {
            this.setMessage(jSONObject2.getString("message"));
        }
        if (jSONObject2.has("bug_state")) {
            this.setBugState(BugState.valueOf(jSONObject2.getString("bug_state")));
        }
        if (jSONObject2.has("state")) {
            State state = new State();
            state.fromJson(jSONObject2.getString("state"));
            this.setState(state);
        }
        if (jSONObject2.has("attachments")) {
            this.setAttachments(Attachment.fromJson((JSONArray)jSONObject2.getJSONArray("attachments")));
        }
        if (jSONObject2.has("view_hierarchy")) {
            this.setViewHierarchy(jSONObject2.getString("view_hierarchy"));
        }
        if (jSONObject2.has("categories_list")) {
            this.setCategoriesFromJSONArray(jSONObject2.getJSONArray("categories_list"));
        }
        if (jSONObject2.has("actionable_consents")) {
            this.setActionableConsentsFromJSONArray(jSONObject2.getJSONArray("actionable_consents"));
        }
        if (jSONObject2.has("connection_error")) {
            this.setConnectionError(jSONObject2.getString("connection_error"));
        }
        if (jSONObject2.has("frustrating_experience_internal_id")) {
            this.setFrustratingExperienceInternalId(jSONObject2.getLong("frustrating_experience_internal_id"));
        }
        if (jSONObject2.has("frustrating_experience_external_id")) {
            this.setFrustratingExperienceExternalId(jSONObject2.getString("frustrating_experience_external_id"));
        }
    }

    public JSONArray getCategoriesAsJSONArray() {
        JSONArray jSONArray;
        Bug bug = bug2;
        Bug bug2 = jSONArray;
        jSONArray = new JSONArray();
        ArrayList<String> arrayList = bug.categories;
        if (arrayList != null) {
            arrayList = arrayList.iterator();
            while (arrayList.hasNext()) {
                bug2.put((String)arrayList.next());
            }
        }
        return bug2;
    }

    public void setCategoriesFromJSONArray(JSONArray jSONArray) {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>();
        for (int i = 0; i < jSONArray.length(); ++i) {
            arrayList2.add(jSONArray.getString(i));
        }
        this.setCategories(arrayList2);
    }

    public JSONArray getActionableConsentsAsJsonArray() {
        JSONArray jSONArray;
        Bug bug = bug2;
        Bug bug2 = jSONArray;
        jSONArray = new JSONArray();
        List<String> list = bug.actionableConsents;
        if (list != null) {
            list = list.iterator();
            while (list.hasNext()) {
                bug2.put((String)list.next());
            }
        }
        return bug2;
    }

    public void setActionableConsentsFromJSONArray(JSONArray jSONArray) {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>();
        for (int i = 0; i < jSONArray.length(); ++i) {
            arrayList2.add(jSONArray.getString(i));
        }
        this.setActionableConsents(arrayList2);
    }

    public int getVisibleAttachmentsCount() {
        int n = 0;
        for (Attachment attachment : this.getAttachments()) {
            if (attachment.getType() != Attachment.Type.MAIN_SCREENSHOT && attachment.getType() != Attachment.Type.EXTRA_IMAGE && attachment.getType() != Attachment.Type.GALLERY_IMAGE && attachment.getType() != Attachment.Type.EXTRA_VIDEO && attachment.getType() != Attachment.Type.GALLERY_VIDEO && attachment.getType() != Attachment.Type.AUDIO) continue;
            ++n;
        }
        return n;
    }

    public boolean hasMainScreenshot() {
        Iterator<Attachment> iterator = ((Bug)((Object)iterator)).getAttachments().iterator();
        while (iterator.hasNext()) {
            if (((Attachment)iterator.next()).getType() != Attachment.Type.MAIN_SCREENSHOT) continue;
            return true;
        }
        return false;
    }

    public boolean isRequiredViewHierarchy() {
        return this.requiredViewHierarchy;
    }

    public Bug setRequiredViewHierarchy(boolean bl) {
        this.requiredViewHierarchy = bl;
        return this;
    }

    @Nullable
    public ViewHierarchyInspectionState getViewHierarchyInspectionState() {
        return this.viewHierarchyInspectionState;
    }

    public Bug setViewHierarchyInspectionState(ViewHierarchyInspectionState viewHierarchyInspectionState) {
        this.viewHierarchyInspectionState = viewHierarchyInspectionState;
        return this;
    }

    @Nullable
    public List<ExtraReportField> getExtraReportFields() {
        return this.extraReportFields;
    }

    public void setExtraReportFields(@Nullable List<ExtraReportField> list) {
        this.extraReportFields = list;
    }

    public void addCategory(String string2) {
        this.categories.add(string2);
    }

    public String getCategoriesString() {
        return StringUtility.toCommaSeparated(this.categories);
    }

    public void setUserConsentResponses(@Nullable Map<String, String> map) {
        this.consentResponses = map;
    }

    @Nullable
    public Map<String, String> getUserConsentResponses() {
        return this.consentResponses;
    }

    public String toString() {
        return "Internal Id: " + this.id + ", TemporaryServerToken:" + this.temporaryServerToken + ", Message:" + this.message + ", Type:" + this.type + ", Connection Error: " + this.connectionError;
    }

    @SuppressLint(value={"ERADICATE_INCONSISTENT_SUBCLASS_PARAMETER_ANNOTATION"})
    public boolean equals(Object object) {
        if (object != null && object instanceof Bug) {
            if (String.valueOf(((Bug)(object = (Bug)object)).getId()).equals(String.valueOf(this.getId())) && String.valueOf(((Bug)object).getMessage()).equals(String.valueOf(this.getMessage())) && String.valueOf(((Bug)object).getTemporaryServerToken()).equals(String.valueOf(this.getTemporaryServerToken())) && ((Bug)object).getBugState() == this.getBugState() && object.getState() != null && object.getState().equals((Object)this.getState()) && ((Bug)object).getType() != null && ((Bug)object).getType().equals(this.getType()) && ((Bug)object).getAttachments() != null && ((Bug)object).getAttachments().size() == this.getAttachments().size()) {
                for (int i = 0; i < ((Bug)object).getAttachments().size(); ++i) {
                    if (((Bug)object).getAttachments().get(i).equals((Object)this.getAttachments().get(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        if (this.getId() != null) {
            return this.getId().hashCode();
        }
        return -1;
    }

    public static enum BugState {
        IN_PROGRESS,
        READY_TO_BE_SENT,
        LOGS_READY_TO_BE_UPLOADED,
        ATTACHMENTS_READY_TO_BE_UPLOADED,
        NOT_AVAILABLE;

    }

    public static enum ViewHierarchyInspectionState {
        IN_PROGRESS,
        FAILED,
        DONE;

    }

    public static class Factory {
        @SuppressLint(value={"CheckResult"})
        public Bug create(Context context) {
            Bug bug;
            Bug bug2 = bug;
            bug = new Bug(System.currentTimeMillis() + "", null, BugState.IN_PROGRESS);
            if (ExternalAutoScreenRecordHelper.getInstance().isEnabled()) {
                context = ExternalAutoScreenRecordHelper.getInstance().getAutoScreenRecordingFileUri();
                ExternalAutoScreenRecordHelper.getInstance().clear();
                if (context != null) {
                    Attachment attachment;
                    Attachment attachment2 = attachment;
                    attachment2();
                    attachment2.setName(context.getLastPathSegment());
                    attachment.setLocalPath(context.getPath());
                    attachment.setType(Attachment.Type.AUTO_SCREEN_RECORDING_VIDEO);
                    bug2.getAttachments().add(attachment2);
                }
            }
            boolean bl = InstabugCore.getFeatureState((String)"VIEW_HIERARCHY_V2") == Feature.State.ENABLED;
            Object object = bug2;
            ((Bug)object).setRequiredViewHierarchy(bl);
            return object;
        }
    }
}

