/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.internal.video.customencoding;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.hardware.display.VirtualDisplay;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import android.media.projection.MediaProjection;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.view.Surface;
import androidx.annotation.Nullable;
import com.instabug.bug.internal.video.customencoding.AudioEncodeConfig;
import com.instabug.bug.internal.video.customencoding.BaseEncoder;
import com.instabug.bug.internal.video.customencoding.Encoder;
import com.instabug.bug.internal.video.customencoding.MicRecorder;
import com.instabug.bug.internal.video.customencoding.VideoEncodeConfig;
import com.instabug.bug.internal.video.customencoding.VideoEncoder;
import com.instabug.library.instacapture.exception.ScreenCapturingFailedException;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;

@TargetApi(value=21)
public class ScreenRecorder {
    private int mWidth;
    private int mHeight;
    private int mDpi;
    private String mDstPath;
    @Nullable
    private MediaProjection mMediaProjection;
    @Nullable
    private VideoEncoder mVideoEncoder;
    @Nullable
    private MicRecorder mAudioEncoder;
    @Nullable
    private MediaFormat mVideoOutputFormat;
    @Nullable
    private MediaFormat mAudioOutputFormat;
    private int mVideoTrackIndex;
    private int mAudioTrackIndex;
    @Nullable
    private MediaMuxer mMuxer;
    private boolean mMuxerStarted;
    private AtomicBoolean mForceQuit;
    private AtomicBoolean mIsRunning;
    @Nullable
    private VirtualDisplay mVirtualDisplay;
    private final MediaProjection.Callback mProjectionCallback;
    @Nullable
    private HandlerThread mWorker;
    @Nullable
    private CallbackHandler mHandler;
    @Nullable
    private Callback mCallback;
    private LinkedList<Integer> mPendingVideoEncoderBufferIndices;
    private LinkedList<Integer> mPendingAudioEncoderBufferIndices;
    private LinkedList<MediaCodec.BufferInfo> mPendingAudioEncoderBufferInfos;
    private LinkedList<MediaCodec.BufferInfo> mPendingVideoEncoderBufferInfos;
    private long mVideoPtsOffset;
    private long mAudioPtsOffset;

    public ScreenRecorder(VideoEncodeConfig object, @Nullable AudioEncodeConfig audioEncodeConfig, @Nullable MediaProjection object2, String string2) {
        VideoEncoder videoEncoder;
        LinkedList linkedList;
        LinkedList linkedList2;
        LinkedList linkedList3;
        LinkedList linkedList4;
        MediaProjection.Callback callback;
        AtomicBoolean atomicBoolean;
        AtomicBoolean atomicBoolean2;
        VideoEncodeConfig videoEncodeConfig = object;
        this.mVideoOutputFormat = null;
        this.mAudioOutputFormat = null;
        this.mVideoTrackIndex = -1;
        this.mAudioTrackIndex = -1;
        this.mMuxerStarted = false;
        Serializable serializable = atomicBoolean2;
        atomicBoolean2 = new AtomicBoolean(false);
        this.mForceQuit = serializable;
        serializable = atomicBoolean;
        atomicBoolean = new AtomicBoolean(false);
        this.mIsRunning = serializable;
        serializable = callback;
        callback = new MediaProjection.Callback(){

            public void onStop() {
                ScreenRecorder.this.quit();
            }
        };
        this.mProjectionCallback = serializable;
        serializable = linkedList4;
        linkedList4 = new LinkedList();
        this.mPendingVideoEncoderBufferIndices = serializable;
        serializable = linkedList3;
        linkedList3 = new LinkedList();
        this.mPendingAudioEncoderBufferIndices = serializable;
        serializable = linkedList2;
        linkedList2 = new LinkedList();
        this.mPendingAudioEncoderBufferInfos = serializable;
        serializable = linkedList;
        linkedList = new LinkedList();
        this.mPendingVideoEncoderBufferInfos = serializable;
        this.mWidth = videoEncodeConfig.getWidth();
        this.mHeight = videoEncodeConfig.getHeight();
        this.mDpi = videoEncodeConfig.getDensity();
        this.mMediaProjection = object2;
        this.mDstPath = string2;
        object2 = videoEncoder;
        videoEncoder = new VideoEncoder((VideoEncodeConfig)object);
        this.mVideoEncoder = object2;
        if (audioEncodeConfig == null) {
            object = null;
        } else {
            MicRecorder micRecorder;
            object = micRecorder;
            micRecorder = new MicRecorder(audioEncodeConfig);
        }
        this.mAudioEncoder = object;
    }

    private synchronized void signalEndOfStream() {
        MediaCodec.BufferInfo bufferInfo;
        MediaCodec.BufferInfo bufferInfo2 = bufferInfo;
        ByteBuffer byteBuffer = ByteBuffer.allocate(0);
        new MediaCodec.BufferInfo().set(0, 0, 0L, 4);
        int n = this.mVideoTrackIndex;
        if (n != -1) {
            this.writeSampleData(n, bufferInfo2, byteBuffer);
        }
        if ((n = this.mAudioTrackIndex) != -1) {
            this.writeSampleData(n, bufferInfo2, byteBuffer);
        }
        ScreenRecorder screenRecorder = this;
        screenRecorder.mVideoTrackIndex = -1;
        screenRecorder.mAudioTrackIndex = -1;
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    private synchronized void record() {
        if (!screenRecorder5.mIsRunning.get() && !screenRecorder5.mForceQuit.get()) {
            if (screenRecorder5.mMediaProjection != null) {
                block5: {
                    int n;
                    int n2;
                    int n3;
                    CallbackHandler callbackHandler;
                    MediaProjection mediaProjection;
                    ScreenRecorder screenRecorder = screenRecorder5;
                    screenRecorder.mIsRunning.set(true);
                    Object object = screenRecorder.mHandler;
                    if (object != null && (mediaProjection = screenRecorder5.mMediaProjection) != null) {
                        mediaProjection.registerCallback(screenRecorder5.mProjectionCallback, (Handler)object);
                    }
                    try {
                        ScreenRecorder screenRecorder2 = screenRecorder5;
                        screenRecorder2.mMuxer = new MediaMuxer(screenRecorder5.mDstPath, 0);
                        screenRecorder2.prepareVideoEncoder();
                        screenRecorder2.prepareAudioEncoder();
                        if (screenRecorder2.mVideoEncoder == null || (object = screenRecorder5.mMediaProjection) == null) break block5;
                        ScreenRecorder screenRecorder3 = screenRecorder5;
                        callbackHandler = object;
                        ScreenRecorder screenRecorder4 = screenRecorder5;
                        object = screenRecorder5 + "-display";
                        n3 = screenRecorder4.mWidth;
                        n2 = screenRecorder4.mHeight;
                        n = screenRecorder4.mDpi;
                        ScreenRecorder screenRecorder5 = screenRecorder5.mVideoEncoder.getInputSurface();
                    }
                    catch (IOException iOException) {
                        throw new ScreenCapturingFailedException((Exception)iOException);
                    }
                    screenRecorder3.mVirtualDisplay = callbackHandler.createVirtualDisplay((String)object, n3, n2, n, 1, (Surface)screenRecorder5, null, null);
                }
                return;
            }
            throw new IllegalStateException("maybe release");
        }
        throw new IllegalStateException();
    }

    private synchronized void muxVideo(int n, MediaCodec.BufferInfo bufferInfo) {
        if (!this.mIsRunning.get()) {
            return;
        }
        if (this.mMuxerStarted && this.mVideoTrackIndex != -1) {
            VideoEncoder videoEncoder = this.mVideoEncoder;
            if (videoEncoder != null) {
                ScreenRecorder screenRecorder = this;
                ByteBuffer byteBuffer = videoEncoder.getOutputBuffer(n);
                screenRecorder.writeSampleData(screenRecorder.mVideoTrackIndex, bufferInfo, byteBuffer);
                videoEncoder.releaseOutputBuffer(n);
            }
            if ((bufferInfo.flags & 4) != 0) {
                this.mVideoTrackIndex = -1;
                this.signalStop(true);
            }
            return;
        }
        ScreenRecorder screenRecorder = this;
        screenRecorder.mPendingVideoEncoderBufferIndices.add(n);
        screenRecorder.mPendingVideoEncoderBufferInfos.add(bufferInfo);
    }

    private void muxAudio(int n, MediaCodec.BufferInfo bufferInfo) {
        if (!this.mIsRunning.get()) {
            return;
        }
        if (this.mMuxerStarted && this.mAudioTrackIndex != -1) {
            MicRecorder micRecorder = this.mAudioEncoder;
            if (micRecorder != null) {
                ScreenRecorder screenRecorder = this;
                ByteBuffer byteBuffer = micRecorder.getOutputBuffer(n);
                screenRecorder.writeSampleData(screenRecorder.mAudioTrackIndex, bufferInfo, byteBuffer);
                micRecorder.releaseOutputBuffer(n);
            }
            if ((bufferInfo.flags & 4) != 0) {
                this.mAudioTrackIndex = -1;
                this.signalStop(true);
            }
            return;
        }
        ScreenRecorder screenRecorder = this;
        screenRecorder.mPendingAudioEncoderBufferIndices.add(n);
        screenRecorder.mPendingAudioEncoderBufferInfos.add(bufferInfo);
    }

    private void writeSampleData(int n, MediaCodec.BufferInfo bufferInfo, @Nullable ByteBuffer byteBuffer) {
        int n2 = bufferInfo.flags;
        if ((n2 & 2) != 0) {
            bufferInfo.size = 0;
        }
        n2 = (n2 & 4) != 0 ? 1 : 0;
        if (bufferInfo.size == 0 && n2 == 0) {
            byteBuffer = null;
        } else {
            Callback callback;
            if (bufferInfo.presentationTimeUs != 0L) {
                if (n == screenRecorder.mVideoTrackIndex) {
                    screenRecorder.resetVideoPts(bufferInfo);
                } else if (n == screenRecorder.mAudioTrackIndex) {
                    screenRecorder.resetAudioPts(bufferInfo);
                }
            }
            if (n2 == 0 && (callback = screenRecorder.mCallback) != null) {
                callback.onRecording(bufferInfo.presentationTimeUs);
            }
        }
        if (byteBuffer != null) {
            byteBuffer.position(bufferInfo.offset);
            byteBuffer.limit(bufferInfo.offset + bufferInfo.size);
            ScreenRecorder screenRecorder = screenRecorder.mMuxer;
            if (screenRecorder != null) {
                screenRecorder.writeSampleData(n, byteBuffer, bufferInfo);
            }
        }
    }

    private synchronized void resetAudioPts(MediaCodec.BufferInfo bufferInfo) {
        long l = this.mAudioPtsOffset;
        if (l == 0L) {
            this.mAudioPtsOffset = bufferInfo.presentationTimeUs;
            bufferInfo.presentationTimeUs = 0L;
        } else {
            bufferInfo.presentationTimeUs -= l;
        }
    }

    private synchronized void resetVideoPts(MediaCodec.BufferInfo bufferInfo) {
        long l = this.mVideoPtsOffset;
        if (l == 0L) {
            this.mVideoPtsOffset = bufferInfo.presentationTimeUs;
            bufferInfo.presentationTimeUs = 0L;
        } else {
            bufferInfo.presentationTimeUs -= l;
        }
    }

    private synchronized void resetVideoOutputFormat(MediaFormat mediaFormat) {
        if (this.mVideoTrackIndex < 0 && !this.mMuxerStarted) {
            this.mVideoOutputFormat = mediaFormat;
            return;
        }
        throw new IllegalStateException("output format already changed!");
    }

    private synchronized void resetAudioOutputFormat(MediaFormat mediaFormat) {
        if (this.mAudioTrackIndex < 0 && !this.mMuxerStarted) {
            this.mAudioOutputFormat = mediaFormat;
            return;
        }
        throw new IllegalStateException("output format already changed!");
    }

    private synchronized void startMuxerIfReady() {
        MediaFormat mediaFormat;
        if (!(this.mMuxerStarted || (mediaFormat = this.mVideoOutputFormat) == null || this.mAudioEncoder != null && this.mAudioOutputFormat == null)) {
            Object object = this.mMuxer;
            if (object != null) {
                this.mVideoTrackIndex = object.addTrack(mediaFormat);
                mediaFormat = this.mAudioOutputFormat;
                if (mediaFormat != null) {
                    int n = this.mAudioEncoder == null ? -1 : this.mMuxer.addTrack(mediaFormat);
                    this.mAudioTrackIndex = n;
                }
                this.mMuxer.start();
                this.mMuxerStarted = true;
            }
            if (this.mPendingVideoEncoderBufferIndices.isEmpty() && this.mPendingAudioEncoderBufferIndices.isEmpty()) {
                return;
            }
            while ((mediaFormat = this.mPendingVideoEncoderBufferInfos.poll()) != null) {
                if (this.mPendingVideoEncoderBufferIndices.peek() == null || (object = this.mPendingVideoEncoderBufferIndices.poll()) == null) continue;
                this.muxVideo((Integer)object, (MediaCodec.BufferInfo)mediaFormat);
            }
            if (this.mAudioEncoder != null) {
                while ((mediaFormat = this.mPendingAudioEncoderBufferInfos.poll()) != null) {
                    if (this.mPendingAudioEncoderBufferIndices.peek() == null || (object = this.mPendingAudioEncoderBufferIndices.poll()) == null) continue;
                    this.muxAudio((Integer)object, (MediaCodec.BufferInfo)mediaFormat);
                }
            }
            return;
        }
    }

    private synchronized void prepareVideoEncoder() {
        BaseEncoder.Callback callback;
        BaseEncoder.Callback callback2 = callback;
        callback = new BaseEncoder.Callback(){

            @Override
            public void onOutputBufferAvailable(BaseEncoder baseEncoder, int n, MediaCodec.BufferInfo bufferInfo) {
                block2: {
                    try {
                        ScreenRecorder.this.muxVideo(n, bufferInfo);
                    }
                    catch (Exception exception) {
                        InstabugSDKLogger.e((String)"IBG-Core", (String)"Muxer encountered an error! ", (Throwable)exception);
                        if (ScreenRecorder.this.mHandler == null) break block2;
                        Message.obtain((Handler)ScreenRecorder.this.mHandler, (int)2, (Object)exception).sendToTarget();
                    }
                }
            }

            @Override
            public void onError(Encoder encoder, Exception exception) {
                InstabugSDKLogger.e((String)"IBG-Core", (String)"VideoEncoder ran into an error! ", (Throwable)exception);
                if (ScreenRecorder.this.mHandler != null) {
                    Message.obtain((Handler)ScreenRecorder.this.mHandler, (int)2, (Object)exception).sendToTarget();
                }
            }

            @Override
            public void onOutputFormatChanged(BaseEncoder baseEncoder, MediaFormat mediaFormat) {
                2 v0 = this;
                v0.ScreenRecorder.this.resetVideoOutputFormat(mediaFormat);
                v0.ScreenRecorder.this.startMuxerIfReady();
            }
        };
        VideoEncoder videoEncoder = this.mVideoEncoder;
        if (videoEncoder != null) {
            videoEncoder.setCallback(callback2);
            this.mVideoEncoder.prepare();
        }
    }

    private synchronized void prepareAudioEncoder() {
        BaseEncoder.Callback callback;
        Object object = this.mAudioEncoder;
        if (object == null) {
            return;
        }
        MicRecorder micRecorder = object;
        object = callback;
        callback = new BaseEncoder.Callback(){

            @Override
            public void onOutputBufferAvailable(BaseEncoder baseEncoder, int n, MediaCodec.BufferInfo bufferInfo) {
                try {
                    ScreenRecorder.this.muxAudio(n, bufferInfo);
                }
                catch (Exception exception) {
                    InstabugSDKLogger.e((String)"IBG-Core", (String)"Muxer encountered an error! ", (Throwable)exception);
                    Message.obtain((Handler)ScreenRecorder.this.mHandler, (int)2, (Object)exception).sendToTarget();
                }
            }

            @Override
            public void onOutputFormatChanged(BaseEncoder baseEncoder, MediaFormat mediaFormat) {
                3 v0 = this;
                v0.ScreenRecorder.this.resetAudioOutputFormat(mediaFormat);
                v0.ScreenRecorder.this.startMuxerIfReady();
            }

            @Override
            public void onError(Encoder encoder, Exception exception) {
                InstabugSDKLogger.e((String)"IBG-Core", (String)"MicRecorder ran into an error! ", (Throwable)exception);
                if (ScreenRecorder.this.mHandler != null) {
                    Message.obtain((Handler)ScreenRecorder.this.mHandler, (int)2, (Object)exception).sendToTarget();
                }
            }
        };
        micRecorder.setCallback((BaseEncoder.Callback)object);
        micRecorder.prepare();
    }

    private synchronized void signalStop(boolean bl) {
        CallbackHandler callbackHandler = screenRecorder2.mHandler;
        if (callbackHandler != null) {
            ScreenRecorder screenRecorder = screenRecorder2;
            ScreenRecorder screenRecorder2 = Message.obtain((Handler)callbackHandler, (int)1, (int)(bl ? 1 : 0), (int)0);
            screenRecorder.mHandler.sendMessageAtFrontOfQueue((Message)screenRecorder2);
        }
    }

    private synchronized void stopEncoders() {
        ScreenRecorder screenRecorder = this;
        screenRecorder.mIsRunning.set(false);
        screenRecorder.mPendingAudioEncoderBufferInfos.clear();
        screenRecorder.mPendingAudioEncoderBufferIndices.clear();
        screenRecorder.mPendingVideoEncoderBufferInfos.clear();
        screenRecorder.mPendingVideoEncoderBufferIndices.clear();
        VideoEncoder videoEncoder = screenRecorder.mVideoEncoder;
        if (videoEncoder != null) {
            videoEncoder.stop();
        }
        if ((this = ((ScreenRecorder)this).mAudioEncoder) != null) {
            ((MicRecorder)this).stop();
        }
    }

    private synchronized void release() {
        Object object = this.mMediaProjection;
        if (object != null) {
            object.unregisterCallback(this.mProjectionCallback);
        }
        if ((object = this.mVirtualDisplay) != null) {
            object.release();
            this.mVirtualDisplay = null;
        }
        this.mAudioOutputFormat = null;
        this.mVideoOutputFormat = null;
        this.mAudioTrackIndex = -1;
        this.mVideoTrackIndex = -1;
        this.mMuxerStarted = false;
        object = this.mWorker;
        if (object != null) {
            object.quitSafely();
            this.mWorker = null;
        }
        if ((object = this.mVideoEncoder) != null) {
            ((VideoEncoder)object).release();
            this.mVideoEncoder = null;
        }
        if ((object = this.mAudioEncoder) != null) {
            ((MicRecorder)object).release();
            this.mAudioEncoder = null;
        }
        if ((object = this.mMediaProjection) != null) {
            object.stop();
            this.mMediaProjection = null;
        }
        if ((object = this.mMuxer) != null) {
            try {
                object.stop();
                this.mMuxer.release();
            }
            catch (Exception exception) {
                InstabugSDKLogger.e((String)"IBG-Core", (String)("Something went wrong, " + exception.getMessage()), (Throwable)exception);
            }
            this.mMuxer = null;
        }
        this.mHandler = null;
    }

    static /* synthetic */ Callback access$102(ScreenRecorder screenRecorder, Callback callback) {
        screenRecorder.mCallback = callback;
        return callback;
    }

    public final synchronized void quit() {
        ScreenRecorder screenRecorder = this;
        screenRecorder.mForceQuit.set(true);
        if (!screenRecorder.mIsRunning.get()) {
            this.release();
        } else {
            this.signalStop(false);
        }
    }

    public synchronized void start() {
        if (this.mWorker == null) {
            this.mWorker = new HandlerThread("ScreenRecorder");
            this.mWorker.start();
            ScreenRecorder screenRecorder = this;
            this.mHandler = screenRecorder.new CallbackHandler(screenRecorder.mWorker.getLooper());
            this.mHandler.sendEmptyMessage(0);
            return;
        }
        throw new IllegalStateException();
    }

    public synchronized void setCallback(Callback callback) {
        this.mCallback = callback;
    }

    protected synchronized void finalize() {
        if (this.mMediaProjection != null) {
            this.release();
        }
        super.finalize();
    }

    private class CallbackHandler
    extends Handler {
        CallbackHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message message) {
            block5: {
                block7: {
                    block6: {
                        int n = message.what;
                        if (n == 0) break block6;
                        if (n == 1 || n == 2) break block7;
                        break block5;
                    }
                    CallbackHandler callbackHandler = this;
                    callbackHandler.ScreenRecorder.this.record();
                    if (callbackHandler.ScreenRecorder.this.mCallback == null) break block5;
                    try {
                        ScreenRecorder.this.mCallback.onStart();
                        break block5;
                    }
                    catch (Exception exception) {
                        message.obj = exception;
                    }
                }
                ScreenRecorder.this.stopEncoders();
                if (message.arg1 != 1) {
                    ScreenRecorder.this.signalEndOfStream();
                }
                if (ScreenRecorder.this.mCallback != null) {
                    ScreenRecorder.this.mCallback.onStop((Throwable)message.obj);
                }
                CallbackHandler callbackHandler = this;
                ScreenRecorder.access$102(callbackHandler.ScreenRecorder.this, null);
                callbackHandler.ScreenRecorder.this.release();
            }
        }
    }

    public static interface Callback {
        public void onStop(@Nullable Throwable var1);

        public void onStart();

        public void onRecording(long var1);
    }
}

