/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.internal.video;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.Nullable;
import com.instabug.bug.internal.video.ScreenRecordingService;
import com.instabug.bug.invocation.invoker.ScreenRecordingFab;
import com.instabug.bug.settings.PerSessionSettings;
import com.instabug.library.Instabug;
import com.instabug.library.core.eventbus.ScreenRecordingEventBus;
import com.instabug.library.internal.InstabugMediaProjectionIntent;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;
import com.instabug.library.internal.video.ScreenRecordingContract;
import com.instabug.library.internal.video.ScreenRecordingEvent;
import com.instabug.library.internal.video.ScreenRecordingFileHolder;
import com.instabug.library.util.MicUtils;
import io.reactivexport.Observable;
import io.reactivexport.subjects.BehaviorSubject;
import io.reactivexport.subjects.Subject;
import java.io.File;

public class InternalScreenRecordHelper
implements ScreenRecordingContract,
ScreenRecordingFab.ScreenRecordingFloatingBtnEventListener {
    private static InternalScreenRecordHelper INSTANCE;
    private final Subject<Boolean> stopSubject = BehaviorSubject.createDefault((Object)Boolean.FALSE);
    @Nullable
    private ScreenRecordingFab fab;
    @Nullable
    private ScreenRecordingFileHolder fileHolder;
    private boolean isCurrentlyRecording = false;
    private boolean shouldPostRecordFinishedEvent = false;

    private InternalScreenRecordHelper() {
    }

    public static synchronized InternalScreenRecordHelper getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InternalScreenRecordHelper();
        }
        return INSTANCE;
    }

    private void resetFab() {
        ScreenRecordingFab screenRecordingFab = this.fab;
        if (screenRecordingFab != null) {
            screenRecordingFab.release();
            this.fab.init();
        }
    }

    @SuppressLint(value={"NULL_DEREFERENCE"})
    public void init() {
        Object object = CoreServiceLocator.getInvocationManagerContract();
        if (object != null) {
            object.switchOffInvocation();
        }
        this.fileHolder = ScreenRecordingFileHolder.getInstance();
        if (this.fab == null) {
            ScreenRecordingFab screenRecordingFab;
            object = screenRecordingFab;
            screenRecordingFab = new ScreenRecordingFab(this);
            this.fab = object;
        }
        this.fab.init();
    }

    @Override
    public void start() {
        this.isCurrentlyRecording = true;
        Context context = Instabug.getApplicationContext();
        if (context != null) {
            Context context2 = context;
            ScreenRecordingService.startScreenRecordingService(context2, ScreenRecordingService.newIntent(context2, -1, InstabugMediaProjectionIntent.getMediaProjectionIntent(), true));
        }
        new Handler(Looper.getMainLooper()).postDelayed(() -> {
            if (this.isRecording()) {
                this.stopSubject.onNext((Object)Boolean.TRUE);
            }
        }, 1000L);
    }

    @Override
    public void stop(int n) {
        if (this.isRecording()) {
            ScreenRecordingEventBus.getInstance().post((Object)new ScreenRecordingEvent(1, this.getAutoScreenRecordingFileUri(), n));
            this.release();
        }
    }

    @SuppressLint(value={"NULL_DEREFERENCE"})
    public void release() {
        ScreenRecordingFab screenRecordingFab = this.fab;
        if (screenRecordingFab != null) {
            screenRecordingFab.release();
        }
        if ((screenRecordingFab = CoreServiceLocator.getInvocationManagerContract()) != null) {
            screenRecordingFab.switchOnInvocation();
        }
        if (Instabug.getApplicationContext() != null) {
            MicUtils.unmuteMic((Context)Instabug.getApplicationContext());
        }
        this.stopSubject.onNext((Object)Boolean.FALSE);
        this.isCurrentlyRecording = false;
    }

    @Nullable
    public Uri getAutoScreenRecordingFileUri() {
        InternalScreenRecordHelper internalScreenRecordHelper = internalScreenRecordHelper.fileHolder;
        return internalScreenRecordHelper == null ? null : internalScreenRecordHelper.getAutoScreenRecordingFileUri();
    }

    public void delete() {
        InternalScreenRecordHelper internalScreenRecordHelper = internalScreenRecordHelper.fileHolder;
        if (internalScreenRecordHelper != null) {
            internalScreenRecordHelper.delete();
        }
    }

    public void clear() {
        internalScreenRecordHelper.isCurrentlyRecording = false;
        InternalScreenRecordHelper internalScreenRecordHelper = internalScreenRecordHelper.fileHolder;
        if (internalScreenRecordHelper != null) {
            internalScreenRecordHelper.clear();
        }
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isRecording() {
        return this.isCurrentlyRecording;
    }

    public void cancel() {
        if (this.isRecording()) {
            this.resetFab();
        }
    }

    public Observable<Boolean> getIsStoppableObservable() {
        return this.stopSubject.hide();
    }

    void onRecordingFinished() {
        ScreenRecordingEvent screenRecordingEvent;
        ScreenRecordingEvent screenRecordingEvent2 = screenRecordingEvent;
        screenRecordingEvent = new ScreenRecordingEvent(2, this.getAutoScreenRecordingFileUri());
        if (!this.shouldPostRecordFinishedEvent) {
            ScreenRecordingEventBus.getInstance().post((Object)screenRecordingEvent2);
        } else {
            PerSessionSettings.getInstance().setRecordReadyEvent(screenRecordingEvent2);
            this.shouldPostRecordFinishedEvent = false;
        }
    }

    void onRecordingError() {
        ScreenRecordingEventBus.getInstance().post((Object)new ScreenRecordingEvent(4, null));
    }

    void setAutoScreenRecordingFile(File file) {
        InternalScreenRecordHelper internalScreenRecordHelper = internalScreenRecordHelper.fileHolder;
        if (internalScreenRecordHelper != null) {
            internalScreenRecordHelper.setAutoScreenRecordingFile(file);
        }
    }

    void startTimerOnRecordingFAB() {
        ScreenRecordingFab screenRecordingFab = ((InternalScreenRecordHelper)((Object)screenRecordingFab)).fab;
        if (screenRecordingFab != null) {
            screenRecordingFab.startTimerOnRecordingButton();
        }
    }

    public void stopAndWait() {
        ((InternalScreenRecordHelper)((Object)screenRecordingFab)).shouldPostRecordFinishedEvent = true;
        ScreenRecordingFab screenRecordingFab = ((InternalScreenRecordHelper)((Object)screenRecordingFab)).fab;
        if (screenRecordingFab != null) {
            screenRecordingFab.stopAndWait();
        }
    }
}

