package com.instabug.bug.userConsent

import com.instabug.bug.configurations.BugReportingConfigurationsProvider
import com.instabug.library.util.collections.LimitedLinkedHashmap

interface UserConsentRepository {
    fun addUserConsent(
        userConsent: UserConsent
    )

    fun getConsents(): LinkedHashMap<String, UserConsent>

    fun removeConsent(key: String)
}

class UserConsentRepositoryImpl(
    private val configurationsProvider: BugReportingConfigurationsProvider,
) : UserConsentRepository {

    private val consentsMap: LinkedHashMap<String, UserConsent> by lazy {
        LimitedLinkedHashmap(configurationsProvider.consentsLimit)
    }

    override fun addUserConsent(
        userConsent: UserConsent
    ) {
        userConsent.key?.let { key ->
            consentsMap[key] = userConsent
        }
    }

    override fun getConsents(): LinkedHashMap<String, UserConsent> = consentsMap

    override fun removeConsent(key: String) {
        consentsMap.remove(key)
    }


    private fun removeConsentWithType(consentType: @ActionType String?) {
        consentType?.let {
            consentsMap.filter { entry -> entry.value.actionType == it }
        }?.takeIf { filteredMap ->
            filteredMap.isNotEmpty()
        }?.let { filteredMap ->
            consentsMap.remove(filteredMap.keys.first())
        }
    }
}