package com.instabug.chat.annotation.shape;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;

import com.instabug.chat.annotation.DirectionRectF;
import com.instabug.library.util.DrawingUtility;

import java.util.List;

/**
 * Created by Tarek360 on 11/24/16.
 */

public class PathShape extends RectShape {

  private final RectF rectF;
  private final Paint paint;
  private Path path;
  private Matrix resizeMatrix;
  private List<PointF> freeHandDrawingPoints;
  public PathShape(Path path, float strokeWidth, Paint paint, List<PointF> freeHandDrawingPoints) {
    super(paint.getColor(), strokeWidth, 0);
    this.path = path;
    this.paint = new Paint(paint);
    this.freeHandDrawingPoints = freeHandDrawingPoints;
    rectF = new RectF();
    path.computeBounds(rectF, true);
    resizeMatrix = new Matrix();

  }

  @Override
  public void draw(Canvas canvas, DirectionRectF bounds, DirectionRectF lastBounds) {

    resizeMatrix.reset();

    Path path = new Path(this.path);

    resizeMatrix.setRectToRect(rectF, new RectF(bounds), Matrix.ScaleToFit.FILL);

    path.transform(resizeMatrix);

    canvas.drawPath(path, this.paint);
  }

  @Override public boolean isTouched(PointF touchedPoint, DirectionRectF bounds) {


    RectF fingerRect =  new RectF(touchedPoint.x - HIT_RADIUS, touchedPoint.y - HIT_RADIUS,
             touchedPoint.x + HIT_RADIUS,  touchedPoint.y + HIT_RADIUS);

    for(PointF p: freeHandDrawingPoints){
      float[] src = {p.x, p.y};
      float[] dst = new float[2];
      resizeMatrix.mapPoints(dst , src);
      if(fingerRect.contains(dst[0], dst[1])) {
        return true;
      }
    }
      return false;
  }

  @Override
  public void adjustBounds(DirectionRectF newBounds, DirectionRectF bounds, boolean isUndo) {

    if (Math.abs(bounds.width() - newBounds.width()) < 1
        && Math.abs(bounds.height() - newBounds.height()) < 1) {
      bounds.set(newBounds);
    } else {
      // Resize with aspect ratio
      float factorWidth = newBounds.width() / bounds.width();
      float factorHeight = newBounds.height() / bounds.height();

      float factor = Math.max(factorWidth, factorHeight);

      Matrix resizeMatrix = new Matrix();

      resizeMatrix.postScale(factor, factor, bounds.centerX(), bounds.centerY());

      resizeMatrix.mapRect(bounds);
    }
  }

  @Override public void drawBorder(Canvas canvas, PointF topLeftPoint, PointF topRightPoint,
      PointF bottomRightPoint, PointF bottomLeftPoint) {
    DrawingUtility.drawLine(canvas, topLeftPoint, topRightPoint, borderPaint);
    DrawingUtility.drawLine(canvas, topLeftPoint, bottomLeftPoint, borderPaint);
    DrawingUtility.drawLine(canvas, topRightPoint, bottomRightPoint, borderPaint);
    DrawingUtility.drawLine(canvas, bottomRightPoint, bottomLeftPoint, borderPaint);
  }
}
