package com.instabug.bug.view.visualusersteps;

import android.os.Build;
import android.text.Html;
import android.text.Spanned;

import com.instabug.bug.di.ServiceLocator;
import com.instabug.bug.utils.DisclaimersLinksUtils;

/**
 Created by Barakat on 02/05/2019
 */
public class VisualUserStepsDisclaimerHelper {
    public static final String LINK = "#repro-steps-screen";


    private static String convertToHTML(String disclaimer) {
        return DisclaimersLinksUtils.convertToHTML(disclaimer, LINK, "");
    }

    public static Spanned getSpannedDisclaimer(String body, String link) {
        String disclaimer = body + " " + "[" + link + "](" + LINK + ")";
        String htmlDisclaimer = convertToHTML(disclaimer);
        Spanned spanned;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            spanned = Html.fromHtml(htmlDisclaimer, Html.FROM_HTML_MODE_LEGACY);
        } else {
            spanned = Html.fromHtml(htmlDisclaimer);
        }
        return spanned;
    }

    public static boolean isDisclaimerAvailable(String body) {
        return body!= null && !body.isEmpty() && ServiceLocator.getConfigurationsProvider().isReproScreenshotsEnabled();
    }
}
