package com.instabug.bug;

import static com.instabug.bug.Constants.ReportingProcess.PROCESS_ASK_QUESTION;
import static com.instabug.bug.Constants.ReportingProcess.PROCESS_BUG;
import static com.instabug.bug.Constants.ReportingProcess.PROCESS_FEEDBACK;
import static com.instabug.bug.Constants.ReportingProcess.PROCESS_FRUSTRATING_EXPERIENCE;
import static com.instabug.bug.Constants.ReportingProcess.PROCESS_HANGING_BUG;

import androidx.annotation.IntDef;
import androidx.annotation.StringDef;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public interface Constants {
    String EXTRA_REPORTING_MESSAGE = "bug_message";
    int REQUEST_SCREEN_RECORDING_MIC_PERMISSIONS = 0xB1;
    String EXTRA_PROCESS = "com.instabug.library.process";
    String EXTRA_BITMAP_URI = "screenshot_uri";
    String COMMENT_MIN_COUNT_LESS_THAN_2_ERROR_MESSAGE = "Description minimum limit can’t be less than 2";
    String LOG_TAG = "IBG-BR";
    String FEATURE_NAME = "Bug Reporting";
    String NULL_OR_EMPTY_USER_CONSENT_KEY = "{BugReporting.addUserConsent} User consent wasn’t added. key can't be null or empty.";
    String INVALID_USER_CONSENT_KEY_LENGTH = "{BugReporting.addUserConsent} User consent key exceeded the maximum character limit (%s) so it will be trimmed.";
    String INVALID_USER_CONSENT_DESCRIPTION_LENGTH = "{BugReporting.addUserConsent} User consent description exceeded the maximum character limit (%s) so it will be trimmed.";
    String MAX_CONSENT_NUMBER_REACHED = "{BugReporting.addUserConsent} User consent with key \"%s\" was dropped as max allowed user consents reached. Please note that you can add up to %s user consents.";
    String USER_CONSENTS_FEATURE_IS_NOT_AVAILABLE = "{BugReporting.addUserConsent} User consent wasn’t added as the feature seems to be disabled for your Instabug company account. Please contact support for more information.";
    String BUG_REPORTING_EXECUTOR_TASK = "bug_reporting_executor";
    String USER_CONSENT_KEY_PREFIX = "IBG_USER_CONSENT_";

    String AUTO_SCREEN_RECORDING_ENABLED_SERVICE_NOT_AVAILABLE_ERROR = "Please make sure to add FOREGROUND_SERVICE_MEDIA_PROJECTION to your manifest file before enabling auto screen recording.";
    String SCREENSHOT_BY_MEDIA_PROJECTION_ENABLED_SERVICE_NOT_AVAILABLE = "Initial screenshot won't be displayed in your bug reports as FOREGROUND_SERVICE_MEDIA_PROJECTION permission is missing from the app's manifest file.";
    int REPRO_SCREENSHOTS_DIR_WATCHER_ID = 0x004;

    String PROACTIVE_REPORTING_ENABLE_BE_DISABLED = "Proactive Reporting wasn't enabled as it seems to be disabled for your Instabug company account. Please, contact support to switch it on for you.";

    @Retention(RetentionPolicy.SOURCE)
    @IntDef({
            PROCESS_BUG,
            PROCESS_FEEDBACK,
            PROCESS_ASK_QUESTION,
            PROCESS_HANGING_BUG,
            PROCESS_FRUSTRATING_EXPERIENCE})
    @interface ReportingProcess {
        int PROCESS_BUG = 0xA2;
        int PROCESS_FEEDBACK = 0xA1;
        int PROCESS_ASK_QUESTION = 0xA3;
        int PROCESS_FRUSTRATING_EXPERIENCE = 0xA4;
        int PROCESS_HANGING_BUG = 0xA7;
    }


    @Retention(RetentionPolicy.SOURCE)
    @IntDef({
            PromptItemOrder.ORDER_BUG_REPORT_OPTION,
            PromptItemOrder.ORDER_FEEDBACK_REPORT_OPTION,
            PromptItemOrder.ORDER_ASK_A_QUESTION_OPTION
    })
    @interface PromptItemOrder {
        int ORDER_BUG_REPORT_OPTION = 0;
        int ORDER_FEEDBACK_REPORT_OPTION = 1;
        int ORDER_ASK_A_QUESTION_OPTION = 2;
    }


    @Retention(RetentionPolicy.SOURCE)
    @StringDef({
            ReportType.BUG,
            ReportType.FEEDBACK,
            ReportType.ASK_QUESTION,
            ReportType.FRUSTRATING_EXPERIENCE,
            ReportType.NOT_AVAILABLE,
    })
    @interface ReportType {
        String BUG = "bug";
        String FEEDBACK = "feedback";
        String ASK_QUESTION = "ask a question";
        String FRUSTRATING_EXPERIENCE = "Frustrating experience";
        String NOT_AVAILABLE = "not-available";
    }


    @Retention(RetentionPolicy.SOURCE)
    @StringDef({
            MainReportCategory.REPORT_BUG,
            MainReportCategory.FEEDBACK,
            MainReportCategory.ASK_QUESTION,
    })
    @interface MainReportCategory {
        String REPORT_BUG = "Report a problem";
        String FEEDBACK = "Suggest an Improvement";
        String ASK_QUESTION = "Ask a Question";

    }
}
