package com.instabug.chat.util;

import androidx.annotation.StyleRes;

import com.instabug.bug.R;
import com.instabug.library.Feature;
import com.instabug.library.IBGFeature;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.core.InstabugCore;

public final class ChatThemeResolver {

    @StyleRes
    public static int resolveTheme(InstabugColorTheme instabugTheme) {
        if (!InstabugCore.isFeatureEnabled(IBGFeature.CUSTOM_FONT)) {
            if (instabugTheme == InstabugColorTheme.InstabugColorThemeLight) {
                return R.style.InstabugChatLight;
            } else {
                return R.style.InstabugChatDark;
            }
        }else {
            return getCustomFontTheme(instabugTheme);
        }
    }

    @StyleRes
    private static int getCustomFontTheme(InstabugColorTheme instabugTheme) {
        if (instabugTheme == InstabugColorTheme.InstabugColorThemeLight) {
            return R.style.InstabugChatLight_CustomFont;
        } else {
            return R.style.InstabugChatDark_CustomFont;
        }
    }
}
