package com.instabug.chat.ui.chat;

import android.content.Intent;
import android.net.Uri;

import com.instabug.chat.model.Attachment;
import com.instabug.chat.model.Chat;
import com.instabug.chat.model.FlatMessage;
import com.instabug.chat.model.Message;
import com.instabug.library.core.ui.BaseContract;

import java.util.List;

import androidx.fragment.app.Fragment;

public class ChatContract {

    public interface View extends BaseContract.View<Fragment> {

        void makeLeftTopButtonCloseButton();

        void makeLeftTopButtonBackButton();

        void showAttachmentButton();

        void hideAttachmentButton();

        void updateChatMessages(List<Message> messages);

        void notifyUIForUpdates();

        void annotateAttachmentImage(Uri imageUri, String type);

        void pickImageFromGallery();

        void showMediaFileSizeAlert();

        void showVideoLengthAlert();

        void requestMediaProjectionPermission();
    }

    interface Presenter extends BaseContract.Presenter {

        void init(String chatNumber);

        void listen();

        void sleep();

        List<FlatMessage> flattenMessages(List<Message> messages);

        void sendMessage(Message message);

        void handleSentAttachment(Attachment attachment);

        Message createMessage(String chatNumber, String messageBody);

        Message createAttachmentMessage(String chatNumber, Attachment attachment);

        Attachment createImageAttachment(Uri imageUri, String typeImageGallery);

        Attachment createVideoAttachment(Uri videoUri);

        Chat getChat();

        void readChat(Chat chat);

        void startScreenshotHelper();

        void startScreenRecordingHelper();

        void startImageFromGalleryPicker();

        void cleanOfflineChats();

        void openVideoRecorder(Intent data);

        void onActivityResult(int requestCode, int resultCode, Intent data);

        void attachScreenshot();
    }

}
