package com.instabug.chat.ui.annotation;

import android.graphics.Bitmap;
import android.net.Uri;

import androidx.annotation.Nullable;

import com.instabug.chat.Constants;
import com.instabug.library.core.ui.BasePresenter;
import com.instabug.library.util.BitmapUtils;
import com.instabug.library.util.InstabugSDKLogger;


class AnnotationPresenter extends BasePresenter<AnnotationContract.View> implements
        AnnotationContract.Presenter {

    AnnotationPresenter(AnnotationContract.View view) {
        super(view);
    }

    @Override
    public void saveAnnotatedImage(@Nullable Bitmap annotatedImage, Uri imageUri) {
        if (view != null) {
            final AnnotationContract.View viewRef = view.get();
            if (viewRef != null && viewRef.getViewContext() != null && viewRef.getViewContext().getContext() != null
                    && annotatedImage != null) {
                viewRef.showPreparingDialog();
                BitmapUtils.saveBitmap(annotatedImage, imageUri, viewRef.getViewContext().getContext(),
                        new BitmapUtils.OnSaveBitmapCallback() {
                    @Override
                    public void onSuccess(Uri absolutePath) {
                        viewRef.finish();
                    }

                    @Override
                    public void onError(Throwable throwable) {
                        viewRef.finish();
                        InstabugSDKLogger.e(Constants.LOG_TAG, "Error occurred while saving bitmap", throwable);
                    }
                });
            }
        }
    }
}
