package com.instabug.chat.settings;

import android.annotation.SuppressLint;

import androidx.annotation.Nullable;

import com.instabug.library.Feature;
import com.instabug.library.OnSdkDismissCallback;

public class PerSessionSettings {

    private static PerSessionSettings perSessionSettings;
    private AttachmentTypesState attachmentTypesState;
    @Nullable
    private Runnable newMessageRunnable;
    @Nullable
    private String hangingChatId;
    @Nullable
    private String hangingMessageId;
    private boolean shouldSkipImageAttachmentAnnotation = false;
    @Nullable
    private String pushNotificationChannelId;
    @Nullable
    private OnSdkDismissCallback onSdkDismissCallback;
    private Feature.State chatsState = Feature.State.ENABLED;
    private Feature.State repliesState = Feature.State.ENABLED;

    private PerSessionSettings() {
        attachmentTypesState = new AttachmentTypesState();
    }

    private static void init() {
        perSessionSettings = new PerSessionSettings();
    }

    synchronized static PerSessionSettings getInstance() {
        if (perSessionSettings == null)
            init();
        return perSessionSettings;
    }

    @SuppressLint("ERADICATE_FIELD_NOT_NULLABLE")
    public synchronized static void release() {
        perSessionSettings = null;
    }

    @Nullable
    Runnable getNewMessageRunnable() {
        return newMessageRunnable;
    }

    void setNewMessageRunnable(@Nullable Runnable newMessageRunnable) {
        this.newMessageRunnable = newMessageRunnable;
    }

    @Nullable
    String getHangingChatId() {
        return hangingChatId;
    }

    void setHangingChatId(@Nullable String hangingConversationId) {
        this.hangingChatId = hangingConversationId;
    }

    @Nullable
    String getHangingMessageId() {
        return hangingMessageId;
    }

    void setHangingMessageId(@Nullable String hangingMessageId) {
        this.hangingMessageId = hangingMessageId;
    }

    PerSessionSettings setAttachmentsTypesParams(AttachmentTypesState attachmentTypesState) {
        this.attachmentTypesState = attachmentTypesState;
        return this;
    }

    AttachmentTypesState getAttachmentTypesState() {
        return attachmentTypesState;
    }

    public boolean shouldSkipImageAttachmentAnnotation() {
        return shouldSkipImageAttachmentAnnotation;
    }

    public void skipImageAttachmentAnnotation(boolean shouldSkipImageAttachmentAnnotation) {
        this.shouldSkipImageAttachmentAnnotation = shouldSkipImageAttachmentAnnotation;
    }

    void setPushNotificationChannelId(@Nullable String pushNotificationChannelId) {
        this.pushNotificationChannelId = pushNotificationChannelId;
    }

    @Nullable
    String getPushNotificationChannelId() {
        return pushNotificationChannelId;
    }

    @Nullable
    public OnSdkDismissCallback getOnSdkDismissCallback() {
        return onSdkDismissCallback;
    }

    public void setOnSdkDismissCallback(@Nullable OnSdkDismissCallback onSdkDismissedCallback) {
        this.onSdkDismissCallback = onSdkDismissedCallback;
    }

    public void setChatsState(Feature.State state) {
        chatsState = state;
    }

    public boolean isChatsStateEnabled() {
        return chatsState == Feature.State.ENABLED;
    }

    public void setRepliesState(Feature.State state) {
        repliesState = state;
    }

    public boolean isRepliesStateEnabled() {
        return repliesState == Feature.State.ENABLED;
    }
}
