package com.instabug.chat.screenshot;


import android.annotation.SuppressLint;
import android.content.Context;
import android.net.Uri;

import com.instabug.chat.Constants;
import com.instabug.chat.model.Attachment;
import com.instabug.chat.ui.ChatActivityLauncher;
import com.instabug.library.screenshot.ExtraScreenshotHelper;
import com.instabug.library.util.InstabugSDKLogger;

import java.lang.ref.WeakReference;

@SuppressLint("ERADICATE_FIELD_NOT_INITIALIZED")
public class ScreenshotHelper implements ExtraScreenshotHelper.OnCaptureListener {

    private static ScreenshotHelper INSTANCE;
    private WeakReference<Context> contextWeakReference;
    private ExtraScreenshotHelper extraScreenshotHelper;
    private String chatId;

    private ScreenshotHelper() {
        extraScreenshotHelper = new ExtraScreenshotHelper();
    }

    public static ScreenshotHelper getInstance() {
        if (INSTANCE == null)
            INSTANCE = new ScreenshotHelper();
        return INSTANCE;
    }

    public void startScreenshotCapturing(Context context, String chatId) {
        this.contextWeakReference = new WeakReference<>(context);
        this.chatId = chatId;
        extraScreenshotHelper.init(this);
    }

    public void release() {
        ScreenshotHelper helper = getInstance();
        helper = null;
    }

    @Override
    public void onExtraScreenshotCaptured(Uri extraScreenshotUri) {
        InstabugSDKLogger.v(Constants.LOG_TAG, "ExtraScreenshot Captured Uri: " + extraScreenshotUri);
        extraScreenshotHelper.release();
        if (contextWeakReference != null) {
            Context context = contextWeakReference.get();
            if (context != null) {
                startChatWithAttachment(context, chatId, createImageAttachment
                        (extraScreenshotUri));
            }
        }
    }

    @Override
    @SuppressLint("ERADICATE_PARAMETER_NOT_NULLABLE")
    public void onExtraScreenshotError(Throwable throwable) {
        if (contextWeakReference != null) {
            Context context = contextWeakReference.get();
            if (context != null) {
                startChatWithAttachment(context, chatId, null);
            }
        }
    }

    private void startChatWithAttachment(Context context, String chatId, Attachment attachment) {
        context.startActivity(ChatActivityLauncher.hangingChatProcessIntent(context, chatId,
                attachment));
    }

    private Attachment createImageAttachment(Uri imageUri) {
        Attachment imageAttachment = new Attachment();
        imageAttachment.setState(Attachment.AttachmentState.STATE_OFFLINE);
        imageAttachment.setType(Attachment.AttachmentType.TYPE_IMAGE_SCREENSHOT)
                .setLocalPath(imageUri.getPath())
                .setName(imageUri.getLastPathSegment());
        return imageAttachment;
    }
}
