package com.instabug.chat.network.util;

import com.instabug.library.networkv2.request.Endpoints;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.networkv2.request.RequestMethod;
import com.instabug.library.networkv2.request.RequestParameter;
import com.instabug.library.util.InstabugDateFormatter;

import org.json.JSONArray;

public class MessagingServiceUtil {

    private static final String LAST_MESSAGE_MESSAGED_AT_PARAM = "last_message_messaged_at";
    private static final String MESSAGES_COUNT_PARAM = "messages_count";
    private static final String READ_MESSAGES_PARAM = "read_messages";

    public static Request buildSyncMessagesRequest(long lastMessageMessagedAtUTCDate, final int
            messagesCount, JSONArray readMessages) {

        Request.Builder requestBuilder = new Request.Builder()
                .endpoint(Endpoints.SYNC_CHATS)
                .method(RequestMethod.POST);

        if (lastMessageMessagedAtUTCDate != 0)
            requestBuilder.addParameter(new RequestParameter<>(LAST_MESSAGE_MESSAGED_AT_PARAM, InstabugDateFormatter
                    .formatUTCDate(lastMessageMessagedAtUTCDate)));
        requestBuilder.addParameter(new RequestParameter<>(MESSAGES_COUNT_PARAM, messagesCount));
        if (readMessages != null && readMessages.length() != 0) {
            requestBuilder.addParameter(new RequestParameter<>(READ_MESSAGES_PARAM, readMessages));
        }

        return requestBuilder.build();
    }
}
