package com.instabug.bug.view.reporting.askquestion;

import android.os.Bundle;

import com.instabug.bug.Constants;
import com.instabug.bug.R;
import com.instabug.bug.di.ServiceLocator;
import com.instabug.bug.view.reporting.BaseReportingFragment;
import com.instabug.bug.view.reporting.IBaseReportingView;
import com.instabug.library.util.InstabugSDKLogger;

import androidx.annotation.Nullable;

public class AskQuestionFragment extends BaseReportingFragment {

    public static final String TAG = AskQuestionFragment.class.getSimpleName();

    public static AskQuestionFragment newInstance(@Nullable String bugMessage) {
        AskQuestionFragment fragment = new AskQuestionFragment();
        Bundle args = new Bundle();
        args.putString(Constants.EXTRA_REPORTING_MESSAGE, bugMessage);
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    @Nullable
    protected IBaseReportingView.Presenter createPresenter() {
        return ServiceLocator.getReportingPresenter(this);
    }

    @Override
    public String provideDefaultHintMessage() {
        if (isAdded()) {
            return getLocalizedString(R.string.IBGAskQuestionHint);
        } else {
            InstabugSDKLogger.v(Constants.LOG_TAG, "failed to provideDefaultHintMessage, fragment not attached yet");
            return "";
        }

    }

    @Override
    public String provideDefaultTitle() {
        if (isAdded()) {
            return getLocalizedString(R.string.askAQuestionHeader);
        } else {
            InstabugSDKLogger.v(Constants.LOG_TAG, "failed to provideDefaultTitle, fragment not attached yet");
            return "";
        }
    }

    @Override
    protected int getSendButtonContentDescriptionTitle() {
        return R.string.ibg_question_send_content_description;
    }

    @Override
    protected int getCloseButtonContentDescription() {
        return R.string.ibg_core_ic_close_ask_question_content_description;
    }

}
