package com.instabug.bug.view.reporting;

import android.content.Context;
import android.content.Intent;
import android.media.projection.MediaProjectionConfig;
import android.media.projection.MediaProjectionManager;
import android.os.Build;

import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;

import com.instabug.bug.R;
import com.instabug.bug.view.disclaimer.Disclaimer;
import com.instabug.bug.view.disclaimer.DisclaimerDetailsFragment;
import com.instabug.bug.view.disclaimer.DisclaimerFragment;
import com.instabug.bug.view.extrafields.ExtraFieldsFragment;
import com.instabug.bug.view.reporting.askquestion.AskQuestionFragment;
import com.instabug.bug.view.reporting.bugreporting.BugReportingFragment;
import com.instabug.bug.view.reporting.feedback.FeedbackFragment;
import com.instabug.bug.view.reporting.frustratingexperience.FrustratingExperienceFragment;
import com.instabug.bug.view.visualusersteps.steppreview.VisualUserStepArgs;
import com.instabug.bug.view.visualusersteps.steppreview.VisualUserStepPreviewFragment;
import com.instabug.bug.view.visualusersteps.visitedscreens.VisualUserStepsListFragment;
import com.instabug.common.photopicker.PhotoPickerActivity;
import com.instabug.library.internal.InstabugMediaProjectionIntent;

final class ReportingNavigator {

    static void navigateToBugReportingFragment(FragmentManager fragmentManager,
                                               @Nullable String reportingMessage,
                                               boolean addToStack) {
        replaceFragment(fragmentManager,
                R.id.instabug_fragment_container,
                BugReportingFragment.newInstance(reportingMessage),
                BugReportingFragment.TAG,
                addToStack);

    }

    static void navigateToFeedbackReportingFragment(FragmentManager fragmentManager,
                                                    @Nullable String reportingMessage,
                                                    boolean addToStack) {
        replaceFragment(fragmentManager,
                R.id.instabug_fragment_container,
                FeedbackFragment.newInstance(reportingMessage),
                FeedbackFragment.TAG,
                addToStack);

    }

    static void navigateToAskQuestion(FragmentManager fragmentManager
            , @Nullable String message, boolean addToStack) {
        replaceFragment(fragmentManager,
                R.id.instabug_fragment_container,
                AskQuestionFragment.newInstance(message),
                AskQuestionFragment.TAG,
                addToStack);
    }

    static void navigateToFrustratingExperience(FragmentManager fragmentManager,
                                                @Nullable String message, boolean addToStack) {
        replaceFragment(fragmentManager,
                R.id.instabug_fragment_container,
                FrustratingExperienceFragment.newInstance(message),
                FrustratingExperienceFragment.TAG,
                addToStack);
    }

    static void navigateToDisclaimerFragment(FragmentManager fragmentManager,
                                             boolean addToStack) {
        replaceFragment(fragmentManager,
                R.id.instabug_fragment_container,
                DisclaimerFragment.newInstance(),
                DisclaimerFragment.TAG,
                addToStack);
    }

    static void navigateToDisclaimerDetailsFragment(FragmentManager fragmentManager,
                                                    Disclaimer disclaimer) {
        replaceFragment(fragmentManager,
                com.instabug.library.R.id.instabug_fragment_container,
                DisclaimerDetailsFragment.newInstance(disclaimer),
                DisclaimerDetailsFragment.TAG, true);
    }


    static void navigateToVisualUserStepPreview(FragmentManager fragmentManager, @NonNull VisualUserStepArgs args) {
        replaceFragment(fragmentManager, com.instabug.library.R.id.instabug_fragment_container,
                VisualUserStepPreviewFragment.newInstance(args),
                VisualUserStepPreviewFragment.TAG, true);
    }

    static void navigateToVisualUserStepListFragment(FragmentManager supportFragmentManager,
                                                     String stepsTitle) {
        replaceFragment(supportFragmentManager,
                com.instabug.library.R.id.instabug_fragment_container,
                VisualUserStepsListFragment.newInstance(stepsTitle),
                VisualUserStepsListFragment.TAG, true);
    }

    @RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
    static void requestRecordingPermission(@NonNull MediaProjectionManager manager, BaseReportingFragment activity) {
        if (activity == null) return;
        if (InstabugMediaProjectionIntent.isMediaProjectionIntentReadyToUse()) {
            activity.openVideoRecorder();
        } else if (activity.getContext() != null && InstabugMediaProjectionIntent.canStartMediaProjectionFGService(activity.getContext())) {
            Intent intent;
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.UPSIDE_DOWN_CAKE) {
                MediaProjectionConfig configs = MediaProjectionConfig.createConfigForDefaultDisplay();
                intent = manager.createScreenCaptureIntent(configs);
            } else {
                intent = manager.createScreenCaptureIntent();
            }
            activity.startActivityForResult(
                    intent, BaseReportingPresenter.REQUEST_SCREEN_RECORDING_CAPTURE_PERMISSIONS
            );
        }
    }

    private static void replaceFragment(FragmentManager fragmentManager, @IdRes int containerViewId, Fragment fragment,
                                        @Nullable String tag, boolean addToBackStack) {
        FragmentTransaction fragmentTransaction =
                fragmentManager
                        .beginTransaction()
                        .replace(containerViewId, fragment, tag);
        if (addToBackStack) {
            fragmentTransaction.addToBackStack(tag);
        }
        fragmentTransaction.commitAllowingStateLoss();
    }


    static void navigateToExtraFields(FragmentManager fragmentManager, @Nullable String title) {
        replaceFragment(fragmentManager,
                R.id.instabug_fragment_container,
                ExtraFieldsFragment.newInstance(title),
                ExtraFieldsFragment.TAG,
                true
        );

    }

    static void navigateToPhotoPicker(BaseReportingFragment baseReportingFragment) {
        Context context = baseReportingFragment.getContext();
        if (context != null) {
            Intent picker = new Intent(context, PhotoPickerActivity.class);
            baseReportingFragment.openActivityForResult(picker, BaseReportingPresenter.PICK_IMAGE_REQUEST_CODE);
        }
    }


}
