package com.instabug.bug.view;


import androidx.appcompat.app.AppCompatActivity;

import com.instabug.bug.Constants;
import com.instabug.library.core.ui.BaseContract;

/**
 * Created by mohamedzakaria on 6/8/17.
 */

public interface BugReportingContract {
    interface View extends BaseContract.View<AppCompatActivity> {

        void startBugReporter();

        void startFeedbackSender();

        void startWithHangingBug();

        void handlePoweredByFooter();

        void navigateToBugReporting();

        void navigateToFeedback();

        void startAskQuestion();

        void startFrustratingExperience();

        void dismissReport();
    }

    interface Presenter extends BaseContract.Presenter {

        void handleBugProcess(@Constants.ReportingProcess int currentProcess);

        void handlePoweredByFooter();

        void startNavigation();
    }
}
