package com.instabug.bug.network

import android.content.Context
import com.instabug.bug.di.ServiceLocator
import com.instabug.bug.model.Bug
import com.instabug.library.diagnostics.IBGDiagnostics

class ProactiveReportsBugsUploaderJob private constructor(): InstabugBugsUploaderJob() {

    private val SDK_EVENT_PROACTIVE_BUG_SENT = "proactive_bugs_sent"
    companion object {
        private val instance = ProactiveReportsBugsUploaderJob()

        @JvmStatic
        fun getInstance(): ProactiveReportsBugsUploaderJob = instance
    }

    override fun getBugs(context: Context?): MutableList<Bug> {
        return ServiceLocator.getBugReportsDbHelper().retrieveProactiveReportingBugs(context)
    }

    override fun onBugUploaded() {
        IBGDiagnostics.logEvent(SDK_EVENT_PROACTIVE_BUG_SENT)
    }
}