package com.instabug.bug.model;

import androidx.annotation.Nullable;

/**
 * Created by tarek on 7/24/17.
 */

public class ExtraReportField {

    @Nullable
    private String id;
    private CharSequence hint;
    @Nullable
    private CharSequence unlocalizedHint;

    @Nullable
    private String fieldAccessibilityContentDescription;
    @Nullable
    private String value;
    private boolean required;

    public ExtraReportField(CharSequence hint, boolean required) {
        this.hint = hint;
        this.required = required;
    }

    public ExtraReportField(CharSequence hint, @Nullable CharSequence unlocalizedHint, boolean required, @Nullable String id) {
        this.hint = hint;
        this.unlocalizedHint = unlocalizedHint;
        this.required = required;
        this.id = id;
    }

    @Nullable
    public String getId() {
        return id;
    }

    public void setValue(@Nullable String value) {
        this.value = value;
    }

    public void setHint(CharSequence hint) {
        this.hint = hint;
    }

    @Nullable
    public String getValue() {
        return value;
    }

    public CharSequence getHint() {
        return hint;
    }

    @Nullable
    public CharSequence getUnlocalizedHint() {
        return unlocalizedHint;
    }

    public boolean isRequired() {
        return required;
    }

    @Nullable
    public String getFieldAccessibilityContentDescription() {
        return fieldAccessibilityContentDescription;
    }

    public void setFieldAccessibilityContentDescription(@Nullable String fieldAccessibilityContentDescription) {
        this.fieldAccessibilityContentDescription = fieldAccessibilityContentDescription;
    }
}
