package com.instabug.apm.webview.webview_trace.util

interface WebViewTraceUrlSanitizer {
    /**
     * passes the url through checks and sanitize it
     */
    operator fun invoke(url: String?): String?
}

class WebViewTraceUrlSanitizerImpl : WebViewTraceUrlSanitizer {

    override operator fun invoke(url: String?): String? = url?.sanitizeUrlProtocol()

    private fun String.sanitizeUrlProtocol() =
        if (matches(PROTOCOL_REGEX.toRegex(RegexOption.IGNORE_CASE))) this else "https://$this"

    companion object {
        private const val PROTOCOL_REGEX = "^[a-z][a-z0-9+.-]*://.*"
    }
}