package com.instabug.apm.webview.webview_trace.flow

import com.instabug.apm.webview.webview_trace.configuration.WebViewTraceConfigurationProvider
import com.instabug.apm.webview.webview_trace.model.event.WebViewEvent

/**
 * Ends current trace when the duration from the last event exceeds the configured threshold
 *
 */
class WebViewTimeThresholdFlow(
    private val configurations: WebViewTraceConfigurationProvider
) : WebViewEventFlow {

    private var lastEvent: WebViewEvent? = null
    private var maxEventThresholdReached: Boolean = false

    override fun process(event: WebViewEvent): Boolean =
        event.takeIf {
            it.isTimeBased
        }?.let {
            lastEvent?.let { last ->
                val duration = event.timeCapture.getDurationMillisStartingFrom(last.timeCapture)
                lastEvent = event
                maxEventThresholdReached = duration > configurations.maxCallbackThresholdMs
                !maxEventThresholdReached
            } ?: let {
                lastEvent = event
                true
            }
        } ?: true

    override fun finished(): Boolean = maxEventThresholdReached

    override fun getPendingEvent(): WebViewEvent? =
        lastEvent?.takeIf { finished() }?.copy(true)
}