package com.instabug.apm.v3_session_data_readiness

import com.instabug.library.sessionV3.providers.FeatureSessionLazyDataProvider
import java.util.Collections
import java.util.WeakHashMap

class SessionReadiness {
    var isReady = true
        private set

    fun markAsNotReady() {
        isReady = false
    }
}

interface APMSessionReadinessHandler {
    fun handle(readiness: Map<String, SessionReadiness>)
    val hasBlockedSessions: Boolean
}

class APMSessionLazyDataProvider : FeatureSessionLazyDataProvider {

    private val handlers: MutableSet<APMSessionReadinessHandler> =
        Collections.synchronizedSet(Collections.newSetFromMap(WeakHashMap()))

    fun registerHandler(handler: APMSessionReadinessHandler) {
        handlers += handler
    }

    operator fun plusAssign(handler: APMSessionReadinessHandler) = registerHandler(handler)

    fun unregisterHandler(handler: APMSessionReadinessHandler) {
        handlers -= handler
    }

    fun minusAssign(handler: APMSessionReadinessHandler) = unregisterHandler(handler)

    override fun isDataReady(sessionIds: List<String>): Map<String, Boolean> = sessionIds
        .associateWith { SessionReadiness() }
        .also(::handleReadiness)
        .mapValues { it.value.isReady }

    private fun handleReadiness(readiness: Map<String, SessionReadiness>) = synchronized(handlers) {
        handlers.forEach { it.handle(readiness) }
    }
}