package com.instabug.apm.uitrace.util

import android.app.Activity
import com.instabug.apm.cache.model.UiTraceCacheModel
import com.instabug.apm.logger.internal.Logger
import com.instabug.apm.uitrace.model.UiTraceEndParams
import com.instabug.apm.util.ClassModuleHelper
import com.instabug.apm.util.device.APMDeviceStateProvider

fun Activity.getUiTraceEndParams(
    deviceStateProvider: APMDeviceStateProvider,
    elapsedTimeMicro: Long
) = UiTraceEndParams(
    screenName,
    ClassModuleHelper.getModuleName(this::class.java),
    deviceStateProvider.getRefreshRate(this),
    elapsedTimeMicro
)

fun Logger.logAutomaticUiTraceSuccessfullyStarted(screenName:String) =
    logSDKDebug("Started Auto UI Trace for screen with name \"$screenName\".")

fun Logger.logAutomaticUiTraceSuccessfullyEnded(screenName: String, cacheModel: UiTraceCacheModel) =
    logSDKDebug(
        "Ended Auto UI Trace for screen with name \"" + screenName + "\".\n"
                + "Total duration: " + cacheModel.totalDurationInSeconds + " seconds\n"
                + "Total hang duration: " + cacheModel.totalHangDurationMillis + " ms"
    )
