package com.instabug.apm.uitrace

import com.instabug.apm.cache.model.SessionCacheModel
import com.instabug.apm.networking.mapping.sessions.SessionFeatureJsonFiller
import com.instabug.apm.networking.mapping.sessions.SessionMappingKeys
import com.instabug.apm.networking.mapping.uitrace.UiTraceMapper
import com.instabug.apm.networking.mapping.uitrace.UiTraceMappingKeys
import org.json.JSONObject

class UiTraceSessionFeatureJsonFiller(private val mapper: UiTraceMapper) :
    SessionFeatureJsonFiller {
    override fun addToJsonObject(model: SessionCacheModel, sessionJsonObject: JSONObject) {
        with(model) {
            val uiTracesJsonArray = uiTraces?.takeIf { it.isNotEmpty() }?.let(mapper::toJsonArray)
            val uiTraceCounts = sessionMetaData?.uiTracesTotalCount ?: 0
            val uiTracesJsonObject: JSONObject? =
                if (uiTraceCounts > 0 || uiTracesJsonArray != null) JSONObject() else null
            uiTracesJsonObject?.run {
                fillDroppedCounts(this@with)
                uiTracesJsonArray?.let { put(UiTraceMappingKeys.TRACES_LIST, it) }
                sessionJsonObject.put(SessionMappingKeys.SESSION_UI_TRACES_LIST, this)
            }
        }
    }

    private fun JSONObject.fillDroppedCounts(sessionCacheModel: SessionCacheModel) {
        fillUiTracesDroppedCounts(sessionCacheModel)
        fillWebViewTracesDroppedCounts(sessionCacheModel)
    }

    private fun JSONObject.fillUiTracesDroppedCounts(sessionCacheModel: SessionCacheModel) {
        sessionCacheModel.sessionMetaData?.run {
            uiTracesDroppedCount.takeIf { it != 0 }
                ?.let { put(SessionMappingKeys.DROPPED_OCCURRENCES_REQUEST_LIMIT, it) }
            getUiTracesDroppedCountStoreLimit(sessionCacheModel.uiTraces?.size ?: 0)
                .takeIf { it != 0 }
                ?.let { put(SessionMappingKeys.DROPPED_OCCURRENCES_STORE_LIMIT, it) }
        }
    }

    private fun JSONObject.fillWebViewTracesDroppedCounts(sessionCacheModel: SessionCacheModel) {
        sessionCacheModel.sessionMetaData?.run {
            webViewTracesDroppedCountRequestLimit.takeIf { it != 0 }
                ?.let { put(SessionMappingKeys.WEB_VIEWS_DROPPED_OCCURRENCES_REQUEST_LIMIT, it) }
            getWebViewTracesDroppedCountStoreLimit(sessionCacheModel.webViewTraceTotalCount)
                .takeIf { it != 0 }
                ?.let { put(SessionMappingKeys.WEB_VIEWS_DROPPED_OCCURRENCES_STORE_LIMIT, it) }
        }
    }
}