package com.instabug.apm.networkinterception.map

import com.instabug.apm.logger.APMLogger
import com.instabug.apm.model.APMNetworkLog
import com.instabug.library.logging.listeners.networklogs.NetworkLogSnapshot
import com.instabug.library.util.extenstions.toMap
import org.json.JSONObject

fun APMNetworkLog.applyFromSnapshot(snapshot: NetworkLogSnapshot) = apply {
    url = snapshot.url
    isModified = true
}

val APMNetworkLog.toSnapshot: NetworkLogSnapshot
    get() = NetworkLogSnapshot(
        url,
        requestHeaders?.toMap("Error while getting request headers"),
        requestBody,
        responseHeaders?.toMap("Error while getting response headers"),
        responseBody,
        responseCode
    )

private fun String.toMap(errorMessage: String) = try {
    JSONObject(this).toMap()
} catch (t: Throwable) {
    APMLogger.i("$errorMessage: ${t.message}")
    null
}
