package com.instabug.apm.di

import com.instabug.apm.appflow.di.AppFlowServiceLocator
import com.instabug.apm.configuration.ConfigurationHandler

class APMConfigurationHandlersProvider : Provider<Array<ConfigurationHandler?>> {
    private val handlers: Array<ConfigurationHandler?>
        get() = arrayOf(
            ServiceLocator.getWebViewTraceConfigurationHandler(),
            AppFlowServiceLocator.configurationHandler
        )

    override fun invoke(): Array<ConfigurationHandler?> = handlers
}