package com.instabug.apm.constants;

import com.instabug.apm.model.LogLevel;

public interface DefaultValues {
    boolean IS_APM_FEATURE_AVAILABLE = false;
    boolean IS_APM_SDK_ENABLED = true;
    long SYNC_INTERVAL = 21600L;
    long APM_LAST_SYNC_TIME = 0L;
    boolean CRASH_DETECTION_ENABLED = false;
    boolean DEBUG_MODE_ENABLED = false;
    int DEFAULT_LOG_LEVEL = LogLevel.INFO;
    boolean SESSION_STORE_LIMIT_ENABLED = false;
    int SESSION_STORE_LIMIT = 300;
    boolean SHOULD_DEPEND_ON_V3_SESSION = false;

    interface Launches {
        boolean ENABLED = false;
        boolean SDK_ENABLED = true;
        long STORE_LIMIT_COLD = 1000L;
        long LIMIT_PER_REQUEST_COLD = 200L;
        long STORE_LIMIT_HOT = 1000L;
        long LIMIT_PER_REQUEST_HOT = 200L;
        boolean WARM_ENABLED = false;
        boolean END_WARM_ENABLED = false;
        long STORE_LIMIT_WARM = 1000L;
        long LIMIT_PER_REQUEST_WARM = 200L;
        boolean WARM_SDK_ENABLED = true;
    }

    interface Network {
        boolean ENABLED = false;
        boolean GRAPH_QL_ENABLED = false;
        boolean GRPC_ENABLED = false;
        long STORE_LIMIT = 1000L;
        long LIMIT_PER_REQUEST = 200L;
        int ATTRIBUTES_STORE_LIMIT = 5;
        int ATTRIBUTE_KEY_LENGTH = 30;
        int ATTRIBUTE_VALUE_LENGTH = 60;
    }

    interface UiTraces {
        boolean SDK_ENABLED = true;            // SDK API default state
        float LARGE_DROP_THRESHOLD = 250000.00f;     // A duration in microseconds
        float SMALL_DROP_THRESHOLD = 16700.000f;     // A duration in microseconds
        long STORE_LIMIT = 1000L;
        long LIMIT_PER_REQUEST = 200L;
        int DEFAULT_REFRESH_RATE = 60;
        int NAME_LENGTH = 150;
    }

    interface UiHangs {
        boolean ENABLED = false;     // BE configuration fallback
        boolean SDK_ENABLED = true;
    }

    interface UiLoadingMetrics {
        boolean ENABLED = false;  // BE configuration fallback
        boolean SDK_ENABLED = true;
        boolean END_SCREEN_LOADING_ENABLED = false; // BE configuration fallback
    }

    interface Experiments {
        boolean ENABLED = false;
        int LIMIT_PER_REQUEST = 1000;
    }

    interface FragmentSpans {
        boolean ENABLED = false;
        boolean SDK_ENABLED = true;
        int LIMIT_PER_REQUEST = 200;
        int STORE_LIMIT = 1000;
    }
}
