package com.instabug.apm.constants;

import androidx.annotation.IntDef;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

import static com.instabug.apm.constants.Constants.SessionEndStatusCode.CRASHING_SESSION;
import static com.instabug.apm.constants.Constants.SessionEndStatusCode.NON_CRASHING_SESSION;
import static com.instabug.apm.constants.Constants.SessionEndStatusCode.UNDEFINED;

public interface Constants {

    String LOG_TAG = "IBG-APM";
    String FEATURE_NAME = "APM";

    String EXECUTION_TRACES_THREAD_EXECUTOR = "execution_traces_thread_executor";
    String APP_LAUNCH_THREAD_EXECUTOR = "app_launch_thread_executor";
    String NETWORK_LOG_THREAD_EXECUTOR = "network_log_thread_executor";
    String SESSION_PURGING_THREAD_EXECUTOR = "session_purging_thread_executor";
    String UI_TRACE_THREAD_EXECUTOR = "ui_trace_thread_executor";
    String TRACES_STOP_EXECUTOR = "execution_traces_stop_thread_executor";
    String NETWORK_LOG_CLEAN_EXECUTOR = "network_log_stop_thread_executor";
    String CP_UI_ORDERED_EXECUTOR_KEY = "cp-ui-executor";

    interface AppLaunch {
        String APP_ON_CREATE_DURATION = "ap_on_c_mus";
        String APP_ON_CREATE_START_TIMESTAMP = APP_ON_CREATE_DURATION + "_st";
        String ACTIVITY_ON_CREATE_DURATION = "ac_on_c_mus";
        String ACTIVITY_ON_CREATE_TIME_STAMP = ACTIVITY_ON_CREATE_DURATION + "_st";
        String ACTIVITY_ON_START_DURATION = "ac_on_st_mus";
        String ACTIVITY_ON_START_TIME_STAMP = ACTIVITY_ON_START_DURATION + "_st";
        String END_APP_LAUNCH_DURATION = "eal_mus";
        String END_APP_LAUNCH_TIME_STAMP = END_APP_LAUNCH_DURATION + "_st";
    }

    interface BaseRequestKeys {
        String APP_VERSION = "av";
        String DEVICE_NAME = "dv";
        String OS_VERSION = "os";
        String APPLICATION_TOKEN_PARAM = "at";
        String DEBUG_MODE_HEADER = "IBG-APM-DEBUG-MODE";
        String DEBUG_MODE_PARAM = "dm";
    }

    @Retention(RetentionPolicy.SOURCE)
    @IntDef({UNDEFINED, NON_CRASHING_SESSION, CRASHING_SESSION})
    @interface SessionEndStatusCode {
        int UNDEFINED = -1;
        int NON_CRASHING_SESSION = 0;
        int CRASHING_SESSION = 1;
    }

    @IntDef({SessionSyncStatus.UNDEFINED,
            SessionSyncStatus.READY_TO_BE_SENT})
    @interface SessionSyncStatus {
        int UNDEFINED = -1;
        int READY_TO_BE_SENT = 0;
    }

}
