package com.instabug.apm.configuration

import android.content.SharedPreferences
import com.instabug.library.internal.sharedpreferences.PreferencesProperty

interface APMPreferencePropertyFactory {
    fun <T> create(key: String, defaultValue: T): PreferencesProperty<T>
}

class APMPreferencePropertyFactoryImpl(
    private val sharedPreferences: SharedPreferences
) : APMPreferencePropertyFactory {
    override fun <T>create(key: String, defaultValue: T): PreferencesProperty<T> =
        APMPreferenceProperty(sharedPreferences, key, defaultValue)
}

class ReadOnceAPMPreferencePropertyFactoryImpl(
    private val sharedPreferences: SharedPreferences
) : APMPreferencePropertyFactory {
    override fun <T>create(key: String, defaultValue: T): PreferencesProperty<T> =
        ReadOnceAPMPreferenceProperty(sharedPreferences, key, defaultValue)
}